/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.PoolImplBase;
import com.ibm.ejs.csi.PoolManagerImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.PoolDiscardStrategy;
import com.ibm.websphere.csi.PooledObject;
import com.ibm.websphere.pmi.PmiBean;

public final class PoolImplThreadSafe
extends PoolImplBase {
    private static final TraceComponent tc = Tr.register((Class)PoolImplThreadSafe.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private Object[] elements;
    private int topOfPool;
    private PoolDiscardStrategy discardStrategy;
    private int maxDrainAmount;
    private PmiBean beanPerf = null;

    PoolImplThreadSafe(int n, int n2, int n3, PmiBean pmiBean, PoolDiscardStrategy poolDiscardStrategy, PoolManagerImpl poolManagerImpl) {
        this.minSize = n;
        this.maxSize = n2;
        this.elements = new Object[this.maxSize];
        this.topOfPool = 0;
        this.discardStrategy = poolDiscardStrategy;
        this.poolMgr = poolManagerImpl;
        this.beanPerf = pmiBean;
        int n4 = this.maxSize - this.minSize;
        this.maxDrainAmount = n4 <= 0 ? 0 : (n4 <= 100 / n3 ? n4 : n4 * n3 / 100);
        if (this.beanPerf != null) {
            this.beanPerf.poolCreated(this.topOfPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get() {
        this.inactive = false;
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            Object object;
            if (this.topOfPool > 0) {
                object = this.elements[--this.topOfPool];
                this.elements[this.topOfPool] = null;
            } else {
                object = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (this.beanPerf != null) {
                this.beanPerf.objectRetrieve(this.topOfPool, object != null);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Object object) {
        boolean bl = false;
        if (object instanceof PooledObject) {
            ((PooledObject)object).reset();
        }
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            if (this.topOfPool < this.maxSize) {
                this.elements[this.topOfPool++] = object;
            } else {
                bl = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                if (object instanceof PooledObject) {
                    ((PooledObject)object).discard();
                } else if (this.discardStrategy != null) {
                    this.discardStrategy.discard(object);
                }
            }
            if (this.beanPerf != null) {
                this.beanPerf.objectReturn(this.topOfPool, bl);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void periodicDrain() {
        int n = 0;
        Object object = null;
        while (this.inactive && this.topOfPool > this.minSize && n < this.maxDrainAmount) {
            Object[] objectArray = this.elements;
            // MONITORENTER : this.elements
            if (this.inactive && this.topOfPool > this.minSize && n < this.maxDrainAmount) {
                object = this.elements[--this.topOfPool];
                this.elements[this.topOfPool] = null;
                ++n;
            }
            // MONITOREXIT : objectArray
            if (object instanceof PooledObject) {
                ((PooledObject)object).discard();
                continue;
            }
            if (this.discardStrategy == null) continue;
            this.discardStrategy.discard(object);
        }
        if (this.beanPerf == null) return;
        this.beanPerf.poolDrained(this.topOfPool, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final void completeDrain() {
        Object object = null;
        int n = this.topOfPool;
        while (true) {
            if (this.topOfPool <= 0) {
                if (this.beanPerf == null) return;
                this.beanPerf.poolDrained(0, n);
                return;
            }
            Object[] objectArray = this.elements;
            // MONITORENTER : this.elements
            if (this.topOfPool > 0) {
                object = this.elements[--this.topOfPool];
                this.elements[this.topOfPool] = null;
            }
            // MONITOREXIT : objectArray
            if (object instanceof PooledObject) {
                ((PooledObject)object).discard();
                continue;
            }
            if (this.discardStrategy == null) continue;
            this.discardStrategy.discard(object);
        }
    }
}

