/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class StringRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = 3348787800915702263L;
    protected String lowerRange_;
    protected String upperRange_;

    public StringRange() {
        this.lowerRange_ = new String();
        this.upperRange_ = new String();
    }

    public StringRange(String string, String string2) throws IllegalArgumentException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        if (string2.compareTo(string) < 0) {
            throw new IllegalArgumentException(string2);
        }
        this.lowerRange_ = string;
        this.upperRange_ = string2;
    }

    public Object clone() {
        try {
            StringRange stringRange = (StringRange)super.clone();
            return stringRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof StringRange)) {
            return false;
        }
        StringRange stringRange = (StringRange)object;
        if (!this.lowerRange_.equals(stringRange.lowerRange_)) {
            return false;
        }
        return this.upperRange_.equals(stringRange.upperRange_);
    }

    public Object getLowerRange() {
        return this.lowerRange_;
    }

    public Object[] getRangeValues() {
        Object[] objectArray = new String[]{this.lowerRange_, this.upperRange_};
        return objectArray;
    }

    public Object getUpperRange() {
        return this.upperRange_;
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        return StringRange.isInRange(this.lowerRange_, this.upperRange_, string);
    }

    public static boolean isInRange(String string, String string2, String string3) throws IllegalArgumentException {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException();
        }
        if (string2.compareTo(string) < 0) {
            throw new IllegalArgumentException(string2);
        }
        return string.compareTo(string3) <= 0 && string2.compareTo(string3) >= 0;
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = (String)object;
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = (String)object;
    }
}

