/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.ConversionUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallPackedDecimalUtils {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public static void marshallPackedDecimalIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, int n2, boolean bl, int n3) throws IllegalArgumentException {
        bigDecimal = bigDecimal.movePointRight(n3);
        if (n2 < 10) {
            MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(bigDecimal.longValue(), byArray, n, n2, bl);
        } else {
            char[] cArray = bigDecimal.toString().toCharArray();
            byte[] byArray2 = ConversionUtils.convertToPackedDecimal(cArray, n2, bl);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
    }

    public static void marshallPackedDecimalIntoBuffer(BigInteger bigInteger, byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException {
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(bigDecimal, byArray, n, n2, bl, 0);
    }

    public static void marshallPackedDecimalIntoBuffer(double d, byte[] byArray, int n, int n2, boolean bl, int n3) throws IllegalArgumentException {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(bigDecimal, byArray, n, n2, bl, n3);
    }

    public static void marshallPackedDecimalIntoBuffer(float f, byte[] byArray, int n, int n2, boolean bl, int n3) throws IllegalArgumentException {
        BigDecimal bigDecimal = new BigDecimal(Float.toString(f));
        MarshallPackedDecimalUtils.marshallPackedDecimalIntoBuffer(bigDecimal, byArray, n, n2, bl, n3);
    }

    public static void marshallPackedDecimalIntoBuffer(long l, byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToPackedDecimal(l, n2, bl);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static byte unmarshallByteFromBuffer(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        byte by = (byte)MarshallPackedDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2);
        return by;
    }

    public static short unmarshallShortFromBuffer(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        short s = (short)MarshallPackedDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2);
        return s;
    }

    public static int unmarshallIntFromBuffer(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        int n3 = (int)MarshallPackedDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2);
        return n3;
    }

    public static long unmarshallLongFromBuffer(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        long l = 0L;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        l = ConversionUtils.convertPackedDecimalToBinary(byArray2);
        return l;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] byArray, int n, int n2, int n3) throws IllegalArgumentException {
        BigDecimal bigDecimal = null;
        if (n2 < 10) {
            long l = MarshallPackedDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2);
            bigDecimal = new BigDecimal(Long.toString(l));
        } else {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            bigDecimal = ConversionUtils.convertPackedDecimalToBigDecimal(byArray2);
        }
        bigDecimal = bigDecimal.movePointLeft(n3);
        return bigDecimal;
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        BigInteger bigInteger = MarshallPackedDecimalUtils.unmarshallBigDecimalFromBuffer(byArray, n, n2, 0).toBigInteger();
        return bigInteger;
    }

    public static double unmarshallDoubleFromBuffer(byte[] byArray, int n, int n2, int n3) throws IllegalArgumentException {
        double d = MarshallPackedDecimalUtils.unmarshallBigDecimalFromBuffer(byArray, n, n2, n3).doubleValue();
        return d;
    }

    public static float unmarshallFloatFromBuffer(byte[] byArray, int n, int n2, int n3) throws IllegalArgumentException {
        float f = MarshallPackedDecimalUtils.unmarshallBigDecimalFromBuffer(byArray, n, n2, n3).floatValue();
        return f;
    }
}

