/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.ConversionUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MarshallExternalDecimalUtils {
    private static final String copyright = "(c) Copyright IBM Corporation 2001,2003.";
    public static final int EXTERNAL_DECIMAL_SIGN_EBCDIC = 0;
    public static final int EXTERNAL_DECIMAL_SIGN_EBCDIC_CUSTOM = 1;
    public static final int EXTERNAL_DECIMAL_SIGN_ASCII = 2;
    public static final int SIGN_FORMAT_LEADING = 0;
    public static final int SIGN_FORMAT_TRAILING = 1;
    public static final int SIGN_FORMAT_LEADING_SEPARATE = 2;
    public static final int SIGN_FORMAT_TRAILING_SEPARATE = 3;

    public static void marshallExternalDecimalIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bigDecimal, byArray, n, n2, bl, n3, n4, n5, null);
    }

    public static void marshallExternalDecimalIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5, String string) throws IllegalArgumentException {
        bigDecimal = bigDecimal.movePointRight(n3);
        if (n2 < 19) {
            MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bigDecimal.longValue(), byArray, n, n2, bl, n4, n5, string);
        } else {
            char[] cArray = bigDecimal.toString().toCharArray();
            byte[] byArray2 = ConversionUtils.convertToExternalDecimal(cArray, n2, bl, n4, n5, string);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
    }

    public static void marshallExternalDecimalIntoBuffer(BigInteger bigInteger, byte[] byArray, int n, int n2, boolean bl, int n3, int n4) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bigInteger, byArray, n, n2, bl, n3, n4, null);
    }

    public static void marshallExternalDecimalIntoBuffer(BigInteger bigInteger, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, String string) throws IllegalArgumentException {
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bigDecimal, byArray, n, n2, bl, 0, n3, n4, string);
    }

    public static void marshallExternalDecimalIntoBuffer(double d, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(d, byArray, n, n2, bl, n3, n4, n5, null);
    }

    public static void marshallExternalDecimalIntoBuffer(double d, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5, String string) throws IllegalArgumentException {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bigDecimal, byArray, n, n2, bl, n3, n4, n5, string);
    }

    public static void marshallExternalDecimalIntoBuffer(float f, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(f, byArray, n, n2, bl, n3, n4, n5, null);
    }

    public static void marshallExternalDecimalIntoBuffer(float f, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5, String string) throws IllegalArgumentException {
        BigDecimal bigDecimal = new BigDecimal(Float.toString(f));
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(bigDecimal, byArray, n, n2, bl, n3, n4, n5, string);
    }

    public static void marshallExternalDecimalIntoBuffer(long l, byte[] byArray, int n, int n2, boolean bl, int n3, int n4) throws IllegalArgumentException {
        MarshallExternalDecimalUtils.marshallExternalDecimalIntoBuffer(l, byArray, n, n2, bl, n3, n4, null);
    }

    public static void marshallExternalDecimalIntoBuffer(long l, byte[] byArray, int n, int n2, boolean bl, int n3, int n4, String string) throws IllegalArgumentException {
        byte[] byArray2 = ConversionUtils.convertToExternalDecimal(l, n2, bl, n3, n4, string);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static byte unmarshallByteFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallByteFromBuffer(byArray, n, n2, bl, n3, n4, null);
    }

    public static byte unmarshallByteFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, String string) throws IllegalArgumentException {
        byte by = (byte)MarshallExternalDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2, bl, n3, n4, string);
        return by;
    }

    public static short unmarshallShortFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallShortFromBuffer(byArray, n, n2, bl, n3, n4, null);
    }

    public static short unmarshallShortFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, String string) throws IllegalArgumentException {
        short s = (short)MarshallExternalDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2, bl, n3, n4, string);
        return s;
    }

    public static int unmarshallIntFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallIntFromBuffer(byArray, n, n2, bl, n3, n4, null);
    }

    public static int unmarshallIntFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, String string) throws IllegalArgumentException {
        int n5 = (int)MarshallExternalDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2, bl, n3, n4, string);
        return n5;
    }

    public static long unmarshallLongFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2, bl, n3, n4, null);
    }

    public static long unmarshallLongFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, String string) throws IllegalArgumentException {
        long l = 0L;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        l = ConversionUtils.convertExternalDecimalToBinary(byArray2, bl, n3, n4, string);
        return l;
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(byArray, n, n2, bl, n3, n4, n5, null);
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5, String string) throws IllegalArgumentException {
        BigDecimal bigDecimal = null;
        if (n2 < 19) {
            long l = MarshallExternalDecimalUtils.unmarshallLongFromBuffer(byArray, n, n2, bl, n4, n5, string);
            bigDecimal = new BigDecimal(Long.toString(l));
        } else {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            bigDecimal = ConversionUtils.convertExternalDecimalToBigDecimal(byArray2, bl, n4, n5, string);
        }
        bigDecimal = bigDecimal.movePointLeft(n3);
        return bigDecimal;
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallBigIntegerFromBuffer(byArray, n, n2, bl, n3, n4, null);
    }

    public static BigInteger unmarshallBigIntegerFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, String string) throws IllegalArgumentException {
        BigInteger bigInteger = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(byArray, n, n2, bl, 0, n3, n4, string).toBigInteger();
        return bigInteger;
    }

    public static double unmarshallDoubleFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallDoubleFromBuffer(byArray, n, n2, bl, n3, n4, n5, null);
    }

    public static double unmarshallDoubleFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5, String string) throws IllegalArgumentException {
        double d = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(byArray, n, n2, bl, n3, n4, n5, string).doubleValue();
        return d;
    }

    public static float unmarshallFloatFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5) throws IllegalArgumentException {
        return MarshallExternalDecimalUtils.unmarshallFloatFromBuffer(byArray, n, n2, bl, n3, n4, n5, null);
    }

    public static float unmarshallFloatFromBuffer(byte[] byArray, int n, int n2, boolean bl, int n3, int n4, int n5, String string) throws IllegalArgumentException {
        float f = MarshallExternalDecimalUtils.unmarshallBigDecimalFromBuffer(byArray, n, n2, bl, n3, n4, n5, string).floatValue();
        return f;
    }
}

