/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class FloatRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = -4489841197295344943L;
    protected float lowerRange_;
    protected float upperRange_;

    public FloatRange() {
        this.lowerRange_ = 0.0f;
        this.upperRange_ = 0.0f;
    }

    public FloatRange(float f, float f2) throws IllegalArgumentException {
        if (f2 < f) {
            throw new IllegalArgumentException(Float.toString(f2));
        }
        this.lowerRange_ = f;
        this.upperRange_ = f2;
    }

    public Object clone() {
        try {
            FloatRange floatRange = (FloatRange)super.clone();
            return floatRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof FloatRange)) {
            return false;
        }
        FloatRange floatRange = (FloatRange)object;
        if (this.lowerRange_ != floatRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == floatRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Float(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Float(this.upperRange_);
    }

    public static boolean isInRange(float f, float f2, float f3) throws IllegalArgumentException {
        if (f2 < f) {
            throw new IllegalArgumentException(Float.toString(f2));
        }
        return f3 >= f && f3 <= f2;
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof Float)) {
            return false;
        }
        float f = ((Float)object).floatValue();
        return FloatRange.isInRange(this.lowerRange_, this.upperRange_, f);
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Float)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = ((Float)object).floatValue();
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Float)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = ((Float)object).floatValue();
    }
}

