/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class DoubleRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = 3380398617924967024L;
    protected double lowerRange_;
    protected double upperRange_;

    public DoubleRange() {
        this.lowerRange_ = 0.0;
        this.upperRange_ = 0.0;
    }

    public DoubleRange(double d, double d2) throws IllegalArgumentException {
        if (d2 < d) {
            throw new IllegalArgumentException(Double.toString(d2));
        }
        this.lowerRange_ = d;
        this.upperRange_ = d2;
    }

    public Object clone() {
        try {
            DoubleRange doubleRange = (DoubleRange)super.clone();
            return doubleRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof DoubleRange)) {
            return false;
        }
        DoubleRange doubleRange = (DoubleRange)object;
        if (this.lowerRange_ != doubleRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == doubleRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Double(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Double(this.upperRange_);
    }

    public static boolean isInRange(double d, double d2, double d3) throws IllegalArgumentException {
        if (d2 < d) {
            throw new IllegalArgumentException(Double.toString(d2));
        }
        return d3 >= d && d3 <= d2;
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = (Double)object;
        return DoubleRange.isInRange(this.lowerRange_, this.upperRange_, d);
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Double)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = (Double)object;
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Double)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = (Double)object;
    }
}

