/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.lock;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class WriterPriorityReadersWriterLock {
    private static final TraceComponent tc = Tr.register((Class)WriterPriorityReadersWriterLock.class, null, null);
    private int nr = 0;
    private int nw = 0;
    private int nrtotal = 0;
    private int nwtotal = 0;

    public synchronized void startReading() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startReading", (Object)this);
        }
        ++this.nrtotal;
        while (this.nwtotal != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Have to wait for a writer");
            }
            this.wait();
        }
        ++this.nr;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startReading");
        }
    }

    public synchronized boolean attemptReading(long l) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"attemptReading", (Object)new Object[]{new Long(l), this});
        }
        if (l < 0L) {
            this.startReading();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"attemptReading", (Object)Boolean.TRUE);
            }
            return true;
        }
        boolean bl = true;
        ++this.nrtotal;
        long l2 = System.currentTimeMillis();
        while (this.nwtotal != 0 && l > 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Have to wait for a writer");
            }
            this.wait(l);
            l -= System.currentTimeMillis() - l2;
            bl = this.nwtotal == 0;
        }
        if (bl) {
            ++this.nr;
        } else {
            --this.nrtotal;
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"attemptReading", (Object)new Boolean(bl));
        }
        return bl;
    }

    public synchronized void startWriting() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startWriting", (Object)this);
        }
        ++this.nwtotal;
        while (this.nr + this.nw != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Have to wait for a reader");
            }
            this.wait();
        }
        this.nw = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startWriting");
        }
    }

    public synchronized boolean attemptWriting(long l) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"attemptWriting", (Object)new Object[]{new Long(l), this});
        }
        if (l < 0L) {
            this.startWriting();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"attemptWriting", (Object)Boolean.TRUE);
            }
            return true;
        }
        ++this.nwtotal;
        boolean bl = true;
        long l2 = System.currentTimeMillis();
        while (this.nr + this.nw != 0 && l > 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Have to wait for a reader");
            }
            this.wait(l);
            l -= System.currentTimeMillis() - l2;
            bl = this.nr + this.nw == 0;
        }
        if (bl) {
            this.nw = 1;
        } else {
            --this.nwtotal;
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"attemptWriting", (Object)new Boolean(bl));
        }
        return bl;
    }

    public synchronized void stopReading() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopReading", (Object)this);
        }
        --this.nr;
        --this.nrtotal;
        if (this.nr == 0) {
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopReading");
        }
    }

    public synchronized void stopWriting() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopWriting", (Object)this);
        }
        this.nw = 0;
        --this.nwtotal;
        this.notifyAll();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopWriting");
        }
    }

    public synchronized boolean hasReaderOrWriter() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasReaderOrWriter", (Object)this);
        }
        boolean bl2 = bl = this.nrtotal + this.nwtotal != 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hasReaderOrWriter", (Object)new Boolean(bl));
        }
        return bl;
    }
}

