/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class FileProps {
    protected String fileName = null;
    protected String header = null;
    protected ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.util.config.wsinstance", Locale.getDefault());

    public FileProps(String string) {
        this(string, "");
    }

    public FileProps(String string, String string2) {
        this.fileName = string;
        this.header = string2;
    }

    void add(String string, String string2) throws Exception {
        Properties properties = this.getProperties();
        if (properties.get(string) != null || properties.contains(string2)) {
            throw new RuntimeException(this.bundle.getString("instancealready"));
        }
        properties.put(string, string2);
        this.saveToFile(properties, this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getProperties() throws Exception {
        Properties properties = new Properties();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            file = new File(this.fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            fileInputStream = new FileInputStream(this.fileName);
            properties.load(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String string) throws Exception {
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            file = new File(this.fileName);
            if (!file.exists()) {
                throw new RuntimeException(this.bundle.getString("instancenotpresent"));
            }
            fileInputStream = new FileInputStream(this.fileName);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            if (properties.get(string) == null) {
                throw new RuntimeException(this.bundle.getString("instancenotpresent"));
            }
            properties.remove(string);
            this.saveToFile(properties, this.fileName);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToFile(Properties properties, String string) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, this.header);
        }
        finally {
            fileOutputStream.close();
        }
    }

    void throwError() {
        throw new RuntimeException();
    }

    private void processArgs(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            this.throwError();
        }
        if (stringArray[1].equalsIgnoreCase("add")) {
            if (stringArray.length < 4) {
                this.throwError();
            }
            this.add(stringArray[2], stringArray[3]);
        } else if (stringArray[1].equalsIgnoreCase("delete")) {
            if (stringArray.length < 3) {
                this.throwError();
            }
            this.remove(stringArray[2]);
        } else {
            this.throwError();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        FileProps fileProps = new FileProps(stringArray[0]);
        fileProps.processArgs(stringArray);
    }
}

