/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.util.CapturedSocket;
import com.ibm.ws.util.ReplaySocket;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;

public class ReplayServerSocket
extends ServerSocket {
    private int port = -1;
    private HttpTransport httpTransport = null;
    private String captureFile = null;
    private ArrayList capturedSockets = new ArrayList();
    private int curSocket = 0;
    private int curIteration = 0;
    private int curInterval = 0;
    private int curAccepts = 0;
    private int curCompletions = 0;
    private int maxSockets;
    private int[] maxIterations = null;
    private int maxIntervals;
    private int maxRequests;
    private long startTime;

    public ReplayServerSocket(HttpTransport httpTransport, String string, int[] nArray) throws IOException {
        super(httpTransport.getPort(), 1, null);
        this.port = httpTransport.getPort();
        this.httpTransport = httpTransport;
        this.captureFile = string;
        this.initCapturedSockets();
        this.maxSockets = this.capturedSockets.size();
        this.maxIterations = nArray;
        this.maxIntervals = nArray.length;
    }

    public synchronized Socket accept() throws IOException {
        if (this.curSocket >= this.maxSockets) {
            if (++this.curIteration >= this.maxIterations[this.curInterval]) {
                if (this.curInterval >= this.maxIntervals - 1) {
                    System.out.println("completed replaying");
                    this.httpTransport.shutdown(true);
                    throw new IOException("completed replaying");
                }
                while (this.curCompletions < this.curAccepts) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.curCompletions = 0;
                this.curAccepts = 0;
                this.curIteration = 0;
                ++this.curInterval;
            }
            this.curSocket = 0;
        }
        if (this.curAccepts++ == 0) {
            if (this.curInterval == 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("starting " + this.maxIterations[this.curInterval] + " iterations through " + this.captureFile);
            }
            this.maxRequests = this.maxSockets * this.maxIterations[this.curInterval];
            this.startTime = new Date().getTime();
        }
        return new ReplaySocket(this, (CapturedSocket)this.capturedSockets.get(this.curSocket++), this.curIteration);
    }

    private void initCapturedSockets() throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.captureFile));
        try {
            while (true) {
                this.capturedSockets.add(objectInputStream.readObject());
            }
        }
        catch (EOFException eOFException) {
            objectInputStream.close();
            if (this.capturedSockets.size() == 0) {
                throw new IOException("no captured sockets found in " + this.captureFile);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    public void close() {
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public int getLocalPort() {
        return this.port;
    }

    public synchronized void replayComplete(ReplaySocket replaySocket) {
        if (++this.curCompletions >= this.maxRequests) {
            long l = new Date().getTime();
            System.out.println("completed interval " + (this.curInterval + 1));
            System.out.println("   total requests completed: " + this.curCompletions);
            float f = (float)(this.curCompletions * 1000) / (float)(l - this.startTime);
            System.out.println("   req/sec: " + f);
            this.notify();
        }
    }
}

