/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.DebugServerSocket;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class DebugInputStream
extends FilterInputStream {
    private static final byte[] eof = "EOF".getBytes();
    private OutputStream traceOs = null;
    private byte[] prefix;

    public DebugInputStream(InputStream inputStream, OutputStream outputStream) {
        super(inputStream);
        this.traceOs = outputStream;
        this.prefix = "(input)".getBytes();
    }

    public int read() throws IOException {
        int n = super.read();
        this.traceOs.write(this.prefix);
        if (n < 0) {
            this.traceOs.write(eof);
        } else {
            this.traceOs.write(n);
        }
        this.traceOs.write(DebugServerSocket.NL);
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        this.traceOs.write(this.prefix);
        if (n < 0) {
            this.traceOs.write(eof);
        } else {
            this.traceOs.write(byArray, 0, n);
        }
        this.traceOs.write(DebugServerSocket.NL);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        this.traceOs.write(this.prefix);
        if (n3 < 0) {
            this.traceOs.write(eof);
        } else {
            this.traceOs.write(byArray, n, n3);
        }
        this.traceOs.write(DebugServerSocket.NL);
        return n3;
    }

    public void close() throws IOException {
        super.close();
        this.traceOs.flush();
    }
}

