/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.ObjectPool;

public class Buffer {
    private static ObjectPool pool = new ObjectPool(Buffer.class.getName(), 256){

        protected Object createObject() {
            return new Buffer();
        }
    };
    public static int SIZE = 8192;
    protected Buffer next;
    protected byte[] buf = new byte[SIZE];
    protected int offset;
    protected int length;

    private Buffer() {
    }

    public static Buffer allocate() {
        Buffer buffer = (Buffer)pool.remove();
        buffer.clear();
        return buffer;
    }

    public void clear() {
        this.next = null;
        this.offset = 0;
        this.length = 0;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int write(byte[] byArray, int n, int n2) {
        if (SIZE - this.length < n2) {
            n2 = SIZE - this.length;
        }
        System.arraycopy(byArray, n, this.buf, this.length, n2);
        this.length += n2;
        return n2;
    }

    public int getAvailable() {
        return this.buf.length - this.length;
    }

    public Buffer getNext() {
        return this.next;
    }

    public void setNext(Buffer buffer) {
        this.next = buffer;
    }

    public static void free(Buffer buffer) {
        buffer.next = null;
        pool.add(buffer);
    }

    public static void freeAll(Buffer buffer) {
        while (buffer != null) {
            Buffer buffer2 = buffer.next;
            Buffer.free(buffer);
            buffer = buffer2;
        }
    }
}

