/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

public class BoundedBuffer {
    private Object[] buffer;
    private int takeIndex = 0;
    private int putIndex = 0;
    private int numberOfUsedSlots = 0;
    private int numberOfEmptySlots;
    private final BoundedBufferLock lock = new BoundedBufferLock();

    public BoundedBuffer(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[n];
        this.numberOfEmptySlots = n;
    }

    public synchronized int size() {
        return this.numberOfUsedSlots;
    }

    public int capacity() {
        return this.buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.numberOfUsedSlots > 0) {
                return this.buffer[this.takeIndex];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            while (this.numberOfEmptySlots <= 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.lock.notify();
                    throw interruptedException;
                }
            }
            this.insert(object);
        }
        this.incrementUsedSlotCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, long l) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            long l2 = l <= 0L ? 0L : System.currentTimeMillis();
            long l3 = l;
            while (this.numberOfEmptySlots <= 0) {
                if (l3 <= 0L) {
                    return null;
                }
                try {
                    this.lock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    this.lock.notify();
                    throw interruptedException;
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            this.insert(object);
        }
        this.incrementUsedSlotCount();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, long l, int n) throws InterruptedException {
        if (object == null || n > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            int n2 = this.buffer.length - n;
            long l2 = l <= 0L ? 0L : System.currentTimeMillis();
            long l3 = l;
            while (this.numberOfEmptySlots - n2 <= 0) {
                if (l3 <= 0L) {
                    return null;
                }
                try {
                    this.lock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    this.lock.notify();
                    throw interruptedException;
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            this.insert(object);
        }
        this.incrementUsedSlotCount();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object, long l) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        long l2 = l <= 0L ? 0L : System.currentTimeMillis();
        long l3 = l;
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            while (this.numberOfEmptySlots <= 0) {
                if (l3 <= 0L) {
                    return false;
                }
                try {
                    this.lock.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    this.lock.notify();
                    throw interruptedException;
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            this.insert(object);
        }
        this.incrementUsedSlotCount();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object object = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            while (this.numberOfUsedSlots <= 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            object = this.extract();
        }
        this.incrementEmptySlotCount();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long l) throws InterruptedException {
        Object object = null;
        long l2 = l <= 0L ? 0L : System.currentTimeMillis();
        long l3 = l;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            while (this.numberOfUsedSlots <= 0) {
                if (l3 <= 0L) {
                    return null;
                }
                try {
                    this.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            object = this.extract();
        }
        this.incrementEmptySlotCount();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementEmptySlotCount() {
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            ++this.numberOfEmptySlots;
            this.lock.notify();
        }
    }

    private synchronized void incrementUsedSlotCount() {
        ++this.numberOfUsedSlots;
        this.notify();
    }

    private final void insert(Object object) {
        --this.numberOfEmptySlots;
        this.buffer[this.putIndex] = object;
        if (++this.putIndex >= this.buffer.length) {
            this.putIndex = 0;
        }
    }

    private final Object extract() {
        --this.numberOfUsedSlots;
        Object object = this.buffer[this.takeIndex];
        this.buffer[this.takeIndex] = null;
        if (++this.takeIndex >= this.buffer.length) {
            this.takeIndex = 0;
        }
        return object;
    }

    public synchronized void expand(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = new Object[this.buffer.length + n];
        if (this.putIndex > this.takeIndex) {
            System.arraycopy(this.buffer, this.takeIndex, objectArray, 0, this.numberOfUsedSlots);
        } else {
            System.arraycopy(this.buffer, this.takeIndex, objectArray, 0, this.buffer.length - this.takeIndex);
            System.arraycopy(this.buffer, 0, objectArray, this.buffer.length - this.takeIndex, this.putIndex);
        }
        this.putIndex = this.numberOfUsedSlots;
        this.takeIndex = 0;
        this.numberOfEmptySlots = objectArray.length - this.numberOfUsedSlots;
        this.buffer = objectArray;
    }

    private class BoundedBufferLock {
        private BoundedBufferLock() {
        }
    }
}

