/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.SSLConfig;
import java.util.Enumeration;
import java.util.Properties;

public class OrbSSLConfig {
    private static TraceComponent tc = Tr.register((String)OrbSSLConfig.class.getName(), (String)"SSL");
    public static final String ORB_PREFIX = "com.ibm.CORBA.";
    public static final String ORB_SERVER_QOP = "com.ibm.CORBA.standardClaimQOPModels";
    public static final String ORB_CLIENT_QOP = "com.ibm.CORBA.standardPerformQOPModels";
    private static final SSLConfig serverSSL = new SSLConfig(SSLConfig.getDefaultServerConfig(), "");

    public static boolean syncSASPropsFromWCCM(Properties properties, Properties properties2) {
        serverSSL.init(properties2);
        boolean bl = false;
        for (int i = 0; i < SSLConfig.PROP_NAMES.length; ++i) {
            if (!OrbSSLConfig.setSasProp(properties, SSLConfig.PROP_NAMES[i], serverSSL.getProperty(SSLConfig.PROP_NAMES[i]))) continue;
            bl = true;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("com.ibm.ssl.") || serverSSL.getProperty(string) != null) continue;
            properties.remove(string);
            Tr.audit((TraceComponent)tc, (String)"security.sas.prop.updated", (Object)new Object[]{string});
            bl = true;
        }
        if (OrbSSLConfig.setSasProp(properties, ORB_SERVER_QOP, serverSSL.getProperty("com.ibm.ssl.securityLevel"))) {
            bl = true;
        }
        return bl;
    }

    private static boolean setSasProp(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (!(string.equals("com.ibm.ssl.securityLevel") || !OrbSSLConfig.hasValue(string2) || OrbSSLConfig.hasValue(string3) && string3.equals(string2))) {
            Tr.audit((TraceComponent)tc, (String)"security.sas.prop.updated", (Object)new Object[]{string});
            return true;
        }
        return false;
    }

    private static boolean hasValue(String string) {
        return string != null && string.length() > 0;
    }
}

