/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.io.Stream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class WriteStream
extends OutputStream {
    private byte[] write_buffer = new byte[8192];
    private int write_length;
    private Stream source;
    private char[] chars;
    private byte[] bytes;
    private boolean disableClose;
    private StreamWriter writer;
    private PrintWriter printWriter;

    public void init(Stream stream) {
        this.disableClose = false;
        if (this.source != null && this.source != stream) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.io.WriteStream.init", (String)"49", (Object)this);
                iOException.printStackTrace();
            }
        }
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        this.source = stream;
        this.write_length = 0;
        this.printWriter = null;
    }

    public Stream getSource() {
        return this.source;
    }

    public void write(int n) throws IOException {
        if (this.write_length >= this.write_buffer.length) {
            this.flushMyBuf(false);
        }
        this.write_buffer[this.write_length++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            if (this.write_length == 0 && n2 >= this.write_buffer.length) {
                this.source.write(byArray, n, n2, false);
                return;
            }
            int n3 = this.write_buffer.length - this.write_length;
            if (n3 > n2) {
                n3 = n2;
            }
            System.arraycopy(byArray, n, this.write_buffer, this.write_length, n3);
            this.write_length += n3;
            n += n3;
            n2 -= n3;
            if (this.write_length < this.write_buffer.length) continue;
            this.flushMyBuf(false);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void flush() throws IOException {
        if (this.write_length > 0) {
            this.flushMyBuf(false);
        }
        this.source.flush();
    }

    private void flushMyBuf(boolean bl) throws IOException {
        int n = this.write_length;
        this.write_length = 0;
        this.source.write(this.write_buffer, 0, n, bl);
    }

    public final void print(char[] cArray, int n, int n2) throws IOException {
        byte[] byArray = this.write_buffer;
        if (byArray == null) {
            return;
        }
        while (n2 > 0) {
            int n3 = this.write_length;
            int n4 = byArray.length - n3;
            if (n4 <= 0) {
                this.flushMyBuf(false);
                n4 = byArray.length;
                n3 = this.write_length;
            }
            if (n2 < n4) {
                n4 = n2;
            }
            for (int i = 0; i < n4; ++i) {
                byArray[n3 + i] = (byte)cArray[n + i];
            }
            this.write_length = n3 + n4;
            n += n4;
            n2 -= n4;
        }
    }

    public final void print(char c) throws IOException {
        this.write((byte)c);
    }

    public final void print(char[] cArray) throws IOException {
        this.print(cArray, 0, cArray.length);
    }

    public final void print(String string) throws IOException {
        this.print(string, 0, string.length());
    }

    public final void print(String string, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            int n4 = n3 = n2 < 1024 ? n2 : 1024;
            if (this.chars == null || this.chars.length < n3) {
                this.chars = new char[n3 < 32 ? 32 : n3];
            }
            string.getChars(n, n + n3, this.chars, 0);
            this.print(this.chars, 0, n3);
            n2 -= n3;
            n += n3;
        }
    }

    public final void print(boolean bl) throws IOException {
        this.print(String.valueOf(bl));
    }

    public final void print(int n) throws IOException {
        if (n == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        if (n < 0) {
            this.write(45);
            n = -n;
        } else if (n == 0) {
            this.write(48);
            return;
        }
        int n2 = 31;
        while (n > 0) {
            this.bytes[--n2] = (byte)(n % 10 + 48);
            n /= 10;
        }
        this.write(this.bytes, n2, 31 - n2);
    }

    public final void print(long l) throws IOException {
        if (l == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (this.bytes == null) {
            this.bytes = new byte[32];
        }
        if (l < 0L) {
            this.write(45);
            l = -l;
        } else if (l == 0L) {
            this.write(48);
            return;
        }
        int n = 31;
        while (l > 0L) {
            this.bytes[--n] = (byte)(l % 10L + 48L);
            l /= 10L;
        }
        this.write(this.bytes, n, 31 - n);
    }

    public final void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object object) throws IOException {
        this.print(object.toString());
    }

    public PrintWriter getPrintWriter() {
        if (this.writer == null) {
            this.writer = new StreamWriter();
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(this.writer);
        }
        return this.printWriter;
    }

    public void setDisableClose(boolean bl) {
        this.disableClose = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void close() throws IOException {
        Stream stream;
        try {
            if (this.write_length > 0) {
                this.flushMyBuf(true);
            }
            Object var2_1 = null;
            if (this.disableClose) {
                this.printWriter = null;
                return;
            }
            stream = this.source;
            this.source = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.disableClose) {
                this.printWriter = null;
                return;
            }
            Stream stream2 = this.source;
            this.source = null;
            if (stream2 == null) throw throwable;
            stream2.close();
            throw throwable;
        }
        stream.close();
    }

    private class StreamWriter
    extends Writer {
        private StreamWriter() {
        }

        public final void write(char c) throws IOException {
            WriteStream.this.print(c);
        }

        public final void write(char[] cArray, int n, int n2) throws IOException {
            WriteStream.this.print(cArray, n, n2);
        }

        public final void write(char[] cArray) throws IOException {
            WriteStream.this.print(cArray, 0, cArray.length);
        }

        public final void write(String string) throws IOException {
            WriteStream.this.print(string);
        }

        public final void write(String string, int n, int n2) throws IOException {
            WriteStream.this.print(string, n, n2);
        }

        public final void flush() throws IOException {
            WriteStream.this.flush();
        }

        public final void close() throws IOException {
            WriteStream.this.printWriter = null;
        }
    }
}

