/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ws.util.ObjectPool;
import java.io.IOException;
import java.io.Writer;

public class WSCharArrayWriter
extends Writer {
    protected Buffer head;
    protected Buffer tail;
    protected boolean isClosed = false;
    static /* synthetic */ Class class$com$ibm$ws$io$WSCharArrayWriter$Buffer;

    public WSCharArrayWriter() {
        this(16384);
    }

    public WSCharArrayWriter(int n) {
    }

    public void write(int n) {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        while (n2 > 0 && !this.isClosed) {
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                Buffer buffer = Buffer.allocate();
                this.tail.setNext(buffer);
                this.tail = buffer;
            }
            int n3 = this.tail.write(cArray, n, n2);
            n += n3;
            n2 -= n3;
        }
    }

    public void write(String string, int n, int n2) {
        while (n2 > 0 && !this.isClosed) {
            Object object;
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                object = Buffer.allocate();
                this.tail.setNext((Buffer)object);
                this.tail = object;
            }
            object = this.tail.getBuffer();
            int n3 = Math.min(this.tail.getAvailable(), n2);
            string.getChars(n, n + n3, (char[])object, this.tail.getCurrentOffset());
            this.tail.length += n3;
            n += n3;
            n2 -= n3;
        }
    }

    public void writeTo(Writer writer) throws IOException {
        for (Buffer buffer = this.head; buffer != null; buffer = buffer.getNext()) {
            writer.write(buffer.getBuffer(), 0, buffer.getLength());
        }
    }

    public void reset() {
        Buffer.freeAll(this.head);
        this.tail = null;
        this.head = null;
        this.isClosed = false;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.size()];
        int n = 0;
        for (Buffer buffer = this.head; buffer != null; buffer = buffer.getNext()) {
            System.arraycopy(buffer.getBuffer(), 0, cArray, n, buffer.getLength());
            n += buffer.getLength();
        }
        return cArray;
    }

    public int size() {
        int n = 0;
        for (Buffer buffer = this.head; buffer != null; buffer = buffer.getNext()) {
            n += buffer.getLength();
        }
        return n;
    }

    public String toString() {
        char[] cArray = this.toCharArray();
        return new String(cArray, 0, cArray.length);
    }

    public void flush() {
    }

    public void close() {
        this.isClosed = true;
    }

    static class Buffer {
        private static ObjectPool pool = new ObjectPool((class$com$ibm$ws$io$WSCharArrayWriter$Buffer == null ? (class$com$ibm$ws$io$WSCharArrayWriter$Buffer = WSCharArrayWriter.class$("com.ibm.ws.io.WSCharArrayWriter$Buffer")) : class$com$ibm$ws$io$WSCharArrayWriter$Buffer).getName(), 64){

            protected Object createObject() {
                return new Buffer();
            }
        };
        public static int SIZE = 16384;
        protected Buffer next;
        protected char[] buf = new char[SIZE];
        protected int length;

        private Buffer() {
        }

        public static Buffer allocate() {
            Buffer buffer = (Buffer)pool.remove();
            buffer.clear();
            return buffer;
        }

        public void clear() {
            this.next = null;
            this.length = 0;
        }

        public char[] getBuffer() {
            return this.buf;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public int write(char[] cArray, int n, int n2) {
            if (SIZE - this.length < n2) {
                n2 = SIZE - this.length;
            }
            System.arraycopy(cArray, n, this.buf, this.length, n2);
            this.length += n2;
            return n2;
        }

        public int getAvailable() {
            return this.buf.length - this.length;
        }

        public int getCurrentOffset() {
            return this.length;
        }

        public Buffer getNext() {
            return this.next;
        }

        public void setNext(Buffer buffer) {
            this.next = buffer;
        }

        public static void free(Buffer buffer) {
            buffer.next = null;
            pool.add(buffer);
        }

        public static void freeAll(Buffer buffer) {
            while (buffer != null) {
                Buffer buffer2 = buffer.next;
                Buffer.free(buffer);
                buffer = buffer2;
            }
        }
    }
}

