/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ws.util.Buffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class WSByteArrayOutputStream
extends OutputStream {
    protected Buffer head;
    protected Buffer tail;
    protected boolean isClosed = false;

    public WSByteArrayOutputStream() {
        this(8192);
    }

    public WSByteArrayOutputStream(int n) {
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        while (n2 > 0 && !this.isClosed) {
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                Buffer buffer = Buffer.allocate();
                this.tail.setNext(buffer);
                this.tail = buffer;
            }
            int n3 = this.tail.write(byArray, n, n2);
            n += n3;
            n2 -= n3;
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        for (Buffer buffer = this.head; buffer != null; buffer = buffer.getNext()) {
            outputStream.write(buffer.getBuffer(), 0, buffer.getLength());
        }
    }

    public synchronized void reset() {
        Buffer.freeAll(this.head);
        this.tail = null;
        this.head = null;
        this.isClosed = false;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        int n = 0;
        for (Buffer buffer = this.head; buffer != null; buffer = buffer.getNext()) {
            System.arraycopy(buffer.getBuffer(), 0, byArray, n, buffer.getLength());
            n += buffer.getLength();
        }
        return byArray;
    }

    public int size() {
        int n = 0;
        for (Buffer buffer = this.head; buffer != null; buffer = buffer.getNext()) {
            n += buffer.getLength();
        }
        return n;
    }

    public String toString() {
        byte[] byArray = this.toByteArray();
        return new String(byArray, 0, byArray.length);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        byte[] byArray = this.toByteArray();
        return new String(byArray, 0, byArray.length, string);
    }

    public String toString(int n) {
        byte[] byArray = this.toByteArray();
        return new String(byArray, n, 0, byArray.length);
    }
}

