/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.io;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.io.Stream;
import com.ibm.ws.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReadStream
extends InputStream {
    private byte[] read_buffer = new byte[8192];
    private int read_offset;
    private int read_length;
    private Stream source = null;
    private boolean disableClose;
    private Reader reader;

    public void init(Stream stream) {
        this.disableClose = false;
        if (this.source != null && this.source != stream) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.io.ReadStream.init", (String)"60", (Object)this);
                iOException.printStackTrace();
            }
        }
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        this.source = stream;
        this.read_offset = 0;
        this.read_length = 0;
    }

    public Stream getSource() {
        return this.source;
    }

    public byte[] getBuffer() {
        return this.read_buffer;
    }

    public int getOffset() {
        return this.read_offset;
    }

    public int getLength() {
        return this.read_length;
    }

    public int available() throws IOException {
        if (this.read_length > this.read_offset) {
            return this.read_length - this.read_offset;
        }
        return this.source.available();
    }

    public final int read() throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final void unread() {
        if (this.read_offset <= 0) {
            throw new RuntimeException();
        }
        --this.read_offset;
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while ((long)this.read_offset + l - (long)n > (long)this.read_length) {
            n += this.read_length - this.read_offset;
            this.read_offset = 0;
            this.read_length = 0;
            if (this.readBuffer()) continue;
            return n;
        }
        this.read_offset = (int)((long)this.read_offset + (l - (long)n));
        return l;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.read_length - this.read_offset;
        if (n3 > 0) {
            if (n3 >= n2) {
                System.arraycopy(this.read_buffer, this.read_offset, byArray, n, n2);
                this.read_offset += n2;
                return n2;
            }
            System.arraycopy(this.read_buffer, this.read_offset, byArray, n, n3);
            this.read_length = 0;
            this.read_offset = 0;
            n += n3;
            n2 -= n3;
        }
        int n4 = n3;
        int n5 = this.source.read(byArray, n, n2);
        if (n5 > 0) {
            n4 += n5;
        }
        return n4 == 0 ? -1 : n4;
    }

    public int readAll(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.read(byArray, n, n2);
            if (n4 < 0) {
                return n3 == 0 ? -1 : n3;
            }
            n += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    public final int readChar() throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray = this.read_buffer;
        if (byArray == null) {
            return -1;
        }
        int n3 = this.read_length;
        int n4 = this.read_offset;
        int n5 = n3 - n4;
        if (n5 <= 0) {
            if (!this.readBuffer()) {
                return -1;
            }
            n3 = this.read_length;
            n4 = this.read_offset;
            n5 = n3 - n4;
        }
        if (n2 < n5) {
            n5 = n2;
        }
        for (int i = 0; i < n5; ++i) {
            cArray[n + i] = (char)(byArray[n4 + i] & 0xFF);
        }
        this.read_offset += n5;
        return n5;
    }

    public int readAll(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.read(cArray, n, n2);
            if (n4 <= 0) {
                return this.read_length;
            }
            n += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    public int read(CharBuffer charBuffer, int n) throws IOException {
        int n2 = charBuffer.length();
        charBuffer.setLength(n2 + n);
        int n3 = this.read(charBuffer.getValue(), n2, n);
        if (n3 < 0) {
            charBuffer.setLength(n2);
        } else if (n3 < n) {
            charBuffer.setLength(n2 + n3);
        }
        return n;
    }

    public int readAll(CharBuffer charBuffer, int n) throws IOException {
        int n2 = charBuffer.length();
        charBuffer.setLength(n2 + n);
        int n3 = this.readAll(charBuffer.getValue(), n2, n);
        if (n3 < 0) {
            charBuffer.setLength(n2);
        } else if (n3 < n) {
            charBuffer.setLength(n2 + n3);
        }
        return n;
    }

    public final boolean readLine(CharBuffer charBuffer) throws IOException {
        int n = charBuffer.capacity();
        int n2 = charBuffer.length();
        char[] cArray = charBuffer.getValue();
        byte[] byArray = this.read_buffer;
        while (true) {
            int n3;
            if ((n3 = this.read_length - this.read_offset) > n - n2) {
                n3 = n - n2;
            }
            while (n3 > 0) {
                int n4;
                if ((n4 = byArray[this.read_offset++] & 0xFF) == 10) {
                    if (n2 > 0 && cArray[n2 - 1] == '\r') {
                        charBuffer.setLength(n2 - 1);
                    } else {
                        charBuffer.setLength(n2);
                    }
                    return true;
                }
                cArray[n2++] = (char)n4;
                --n3;
            }
            if (this.read_offset >= this.read_length && !this.readBuffer()) {
                charBuffer.setLength(n2);
                return n2 > 0;
            }
            if (n2 < n) continue;
            charBuffer.setLength(n2 + 1);
            String string = new String(cArray);
            charBuffer = charBuffer.replace(0, string.length(), string);
            n = charBuffer.capacity();
            cArray = charBuffer.getValue();
        }
    }

    public String readLine() throws IOException {
        CharBuffer charBuffer = new CharBuffer();
        if (this.readLine(charBuffer)) {
            return charBuffer.toString();
        }
        if (charBuffer.length() == 0) {
            return null;
        }
        return charBuffer.toString();
    }

    private boolean readBuffer() throws IOException {
        if (this.read_buffer == null) {
            this.read_offset = 0;
            this.read_length = 0;
            return false;
        }
        this.read_offset = 0;
        this.read_length = this.source.read(this.read_buffer, 0, this.read_buffer.length);
        return this.read_length > 0;
    }

    public void setDisableClose(boolean bl) {
        this.disableClose = bl;
    }

    public final void close() throws IOException {
        if (this.disableClose) {
            return;
        }
        if (this.source != null) {
            Stream stream = this.source;
            this.source = null;
            stream.close();
        }
    }

    private class StreamReader
    extends Reader {
        private StreamReader() {
        }

        public final int read(char[] cArray, int n, int n2) throws IOException {
            return ReadStream.this.read(cArray, n, n2);
        }

        public boolean ready() throws IOException {
            return ReadStream.this.available() > 0;
        }

        public final void close() throws IOException {
        }
    }
}

