/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpResponse;
import com.ibm.ws.io.Stream;
import com.ibm.ws.io.WriteStream;
import com.ibm.ws.util.Buffer;
import java.io.IOException;

public class ResponseStream
extends Stream {
    public static byte[] CRLF = new byte[]{13, 10};
    static byte[] CONTINUE = "HTTP/1.1 100 Continue\r\n\r\n".getBytes();
    static byte[] EXTENDED_HANDSHAKE = "HTTP/1.1 200 OK\r\n\r\n".getBytes();
    protected HttpResponse response;
    protected WriteStream next;
    protected boolean chunkedEncoding;
    protected Buffer head;
    protected Buffer tail;
    protected int chunkLength;
    protected int bufferSize;
    protected int numBytesWritten;
    protected boolean flushToWire;
    protected boolean isClosed;
    protected boolean noBody;
    private static TraceComponent tc = Tr.register((String)ResponseStream.class.getName(), (String)"HTTP_Transport");
    private byte[] chunkBuf = new byte[16];

    public void init(HttpResponse httpResponse, WriteStream writeStream) {
        this.response = httpResponse;
        this.next = writeStream;
    }

    void start() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"start");
        }
        this.chunkedEncoding = false;
        this.response.headersWritten = false;
        this.chunkLength = 0;
        this.bufferSize = 8192;
        if (this.head != null) {
            this.head.clear();
        }
        this.tail = this.head;
        this.numBytesWritten = 0;
        this.setFlushMode(true);
        this.isClosed = false;
        this.noBody = false;
    }

    public void setNoBody() {
        this.noBody = true;
        this.bufferSize = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setNoBody");
        }
    }

    public int getNumBytesWritten() {
        return this.numBytesWritten;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        int n2 = Buffer.SIZE;
        this.bufferSize = n2 * ((n + n2 - 1) / n2);
        if (this.bufferSize <= 0) {
            this.bufferSize = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setBufferSize", (Object)("requested: " + n + "; actual: " + this.bufferSize));
        }
    }

    public boolean isCommitted() {
        boolean bl;
        boolean bl2 = bl = this.response.headersWritten || this.isClosed;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isCommitted", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clear");
        }
        if (this.head != null) {
            Buffer.freeAll(this.head.getNext());
            this.head.clear();
        }
        this.tail = this.head;
        this.chunkLength = 0;
        this.numBytesWritten = 0;
    }

    public void write(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)("length=" + n2 + "; isEnd=" + bl));
        }
        if (this.noBody || this.isClosed) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"noBody or closed");
            }
            return;
        }
        if (n2 > 0) {
            this.numBytesWritten += n2;
        }
        if (bl) {
            this.flushBuffer(true);
            this.writeChunk(byArray, n, n2);
            return;
        }
        while (n2 > 0 && !this.isClosed) {
            if (this.head == null) {
                this.head = this.tail = Buffer.allocate();
            } else if (this.tail.getLength() >= Buffer.SIZE) {
                if (this.chunkLength + n2 > this.bufferSize - Buffer.SIZE) {
                    this.flushBuffer(bl);
                } else {
                    Buffer buffer = Buffer.allocate();
                    this.tail.setNext(buffer);
                    this.tail = buffer;
                }
            }
            int n3 = this.tail.write(byArray, n, n2);
            n += n3;
            n2 -= n3;
            this.chunkLength += n3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void finish(boolean bl, boolean bl2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish", (Object)("close=" + bl + "; flush=" + bl2));
        }
        if (this.next == null || this.isClosed) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"finish", (Object)"closed");
            }
            return;
        }
        this.flushBuffer(true);
        this.isClosed = true;
        try {
            if (this.chunkedEncoding) {
                this.next.write(48);
                this.next.write(CRLF);
                this.next.write(CRLF);
            }
            if (bl) {
                this.next.close();
                this.next = null;
            } else if (bl2) {
                this.next.flush();
            }
        }
        catch (IOException iOException) {
            this.clear();
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    public void flushBuffer(boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushBuffer", (Object)new Boolean(bl));
        }
        if (this.isClosed) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushBuffer", (Object)"closed");
            }
            return;
        }
        this.writeHeaders(bl ? this.numBytesWritten : -1);
        while (this.head != null) {
            this.writeChunk(this.head.getBuffer(), 0, this.head.getLength());
            Buffer buffer = this.head.getNext();
            if (buffer == null) break;
            Buffer.free(this.head);
            this.head = buffer;
        }
        this.tail = this.head;
        if (this.head != null) {
            this.head.clear();
        }
        this.chunkLength = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushBuffer");
        }
    }

    private void writeHeaders(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeHeaders");
        }
        if (this.response.headersWritten || this.isClosed) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeHeaders", (Object)"closed");
            }
            return;
        }
        this.chunkedEncoding = this.response.writeHeaders(this.next, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeHeaders");
        }
    }

    private void writeChunk(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeChunk", (Object)("length=" + n2));
        }
        if (n2 <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeChunk", (Object)"no length");
            }
            return;
        }
        if (this.next == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeChunk", (Object)"no next");
            }
            return;
        }
        if (this.noBody) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeChunk", (Object)"noBody");
            }
            return;
        }
        try {
            if (!this.chunkedEncoding) {
                this.next.write(byArray, n, n2);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeChunk", (Object)"not chunked");
                }
                return;
            }
            int n3 = this.chunkBuf.length;
            this.chunkBuf[--n3] = 10;
            this.chunkBuf[--n3] = 13;
            for (int i = n2; i > 0; i >>= 4) {
                int n4 = i & 0xF;
                this.chunkBuf[--n3] = n4 <= 9 ? (byte)(48 + n4) : (byte)(97 + n4 - 10);
            }
            this.next.write(this.chunkBuf, n3, this.chunkBuf.length - n3);
            this.next.write(byArray, n, n2);
            this.next.write(this.chunkBuf, this.chunkBuf.length - 2, 2);
        }
        catch (IOException iOException) {
            this.clear();
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeChunk");
        }
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flush");
        }
        if (this.flushToWire && !this.isClosed) {
            this.flushBuffer(false);
            try {
                this.next.flush();
            }
            catch (IOException iOException) {
                this.clear();
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush");
        }
    }

    public void close() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close");
        }
    }

    void sendContinue() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendContinue");
        }
        try {
            this.next.write(CONTINUE);
            this.next.flush();
        }
        catch (IOException iOException) {
            this.clear();
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendContinue");
        }
    }

    void sendExtendedHandshake() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendExtendedHandshake");
        }
        try {
            this.next.write(EXTENDED_HANDSHAKE);
            this.next.flush();
            this.isClosed = true;
        }
        catch (IOException iOException) {
            this.clear();
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendExtendedHandshake");
        }
    }

    public void setFlushMode(boolean bl) {
        this.flushToWire = bl;
    }
}

