/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpSSLServerSocketFactory;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.Logger;
import com.ibm.ws.util.TransportLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import javax.net.ServerSocketFactory;

public class HttpTransport
implements Runnable {
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String MAX_CONNECT_BACKLOG = "MaxConnectBacklog";
    public static final String TCP_NO_DELAY = "TcpNoDelay";
    public static final String KEEP_ALIVE_ENABLE = "KeepAliveEnabled";
    Logger logger;
    HttpServer httpserver;
    private static TraceComponent tc = Tr.register((String)HttpTransport.class.getName(), (String)"HTTP_Transport");
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private HttpServer httpServer = null;
    private String host = null;
    private int port = -1;
    private int maxBacklog = 511;
    private boolean tcpNoDelay = true;
    private ServerSocket serverSocket;
    private boolean alive;
    private String scheme = "http";
    private boolean isSecure = false;
    private Thread acceptThread = null;
    private boolean prevAcceptError = false;
    private int AcceptErrCnt = 0;
    private int maxKeepAliveRequests = 100;
    private int connectionIOTimeout = 5000;
    private int connectionKeepAliveTimeout = 5000;
    private boolean isKeepAlive = true;

    public void initialize(HttpServer httpServer, Transport transport) throws Exception {
        this.initialize(httpServer, transport, new Properties());
    }

    public void initialize(HttpServer httpServer, Transport transport, Properties properties) throws Exception {
        if (!HttpServer.errorLogDisable) {
            Logger.log(3, "HTTP0101I Initializing . . .");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.httpServer = httpServer;
        this.alive = true;
        InetAddress inetAddress = null;
        if (this.host != null && this.host.length() != 0 && !this.host.equals("*")) {
            inetAddress = InetAddress.getByName(this.host);
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: Determined Internet Address " + inetAddress + "from host " + this.host);
            }
        }
        if (transport != null && ((HTTPTransport)transport).isSslEnabled()) {
            this.scheme = HTTPS;
            this.isSecure = true;
            if (this.port == -1) {
                this.port = 443;
            }
            HttpSSLServerSocketFactory httpSSLServerSocketFactory = new HttpSSLServerSocketFactory(properties);
            this.serverSocket = ((ServerSocketFactory)httpSSLServerSocketFactory).createServerSocket(this.port, this.maxBacklog, inetAddress);
            if (this.serverSocket != null && !HttpServer.errorLogDisable) {
                Logger.log(3, "HTTP0200I  SSL is enabled for port " + this.port);
            }
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: Socket has be opened for port " + this.port + " with Security Enabled");
            }
        } else {
            String string;
            String string2;
            if (this.port == -1) {
                this.port = 80;
            }
            if ((string2 = System.getProperty(string = "com.ibm.ws.http.socketProps." + this.port)) != null) {
                Properties properties2 = new Properties();
                properties2.load(new FileInputStream(string2));
                this.serverSocket = com.ibm.ws.util.ServerSocketFactory.getInstance(this.port, this.maxBacklog, inetAddress, this, properties2);
                if (this.serverSocket != null && !HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0201I  SSL is not enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has been opened for port " + this.port);
                }
            } else {
                this.serverSocket = new ServerSocket(this.port, this.maxBacklog, inetAddress);
                if (this.serverSocket != null && !HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0202I  SSL is not enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has been opened for port " + this.port);
                }
            }
        }
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Initialization has completed");
        }
    }

    public void shutdown(boolean bl) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"shutdown");
            }
            this.alive = false;
            try {
                try {
                    Socket socket = new Socket("localhost", this.serverSocket.getLocalPort());
                }
                catch (Exception exception) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(0, "HTTP0104C Local Connection Failed");
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.http.HttpTransport.run", (String)"125");
                    this.acceptThread.interrupt();
                }
                this.acceptThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.HttpTransport.run", (String)"134");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"shutdown", (Object)interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Shutdown has completed");
        }
    }

    public boolean isAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Determine if socket is alive");
        }
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block34: {
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: Running Thread");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run");
            }
            while (this.alive) {
                Socket socket;
                block33: {
                    socket = null;
                    try {
                        socket = this.serverSocket.accept();
                        this.prevAcceptError = false;
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpTransport: Accept Socket");
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.http.HttpTransport.run", (String)"153");
                        if (!this.alive) break block33;
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0102E Server Socket Accept Failed");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"server socket accept failure", (Object)iOException);
                        }
                        if (this.prevAcceptError) {
                            if (++this.AcceptErrCnt > 50) {
                                try {
                                    Thread.sleep(30000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        this.prevAcceptError = true;
                        this.AcceptErrCnt = 1;
                    }
                }
                if (socket == null) continue;
                if (this.alive) {
                    HttpConnection httpConnection = null;
                    int n = -1;
                    String string = "unknown";
                    if (TransportLogger.debugEnabled()) {
                        n = socket.getPort();
                        string = socket.getInetAddress().getHostAddress();
                        TransportLogger.debug("HttpTransport.run():  accept: remotePort=[" + n + "] remoteAddress=[" + string + "]");
                    }
                    try {
                        httpConnection = this.httpServer.allocateConnection();
                        httpConnection.init(this, socket);
                        HttpConnection httpConnection2 = httpConnection;
                        synchronized (httpConnection2) {
                            try {
                                this.httpServer.handleConnection(httpConnection);
                            }
                            catch (Throwable throwable) {
                                httpConnection.setAborted(true);
                                httpConnection.cleanup();
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.HttpTransport.run", (String)"175");
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpTransport.run(): error handling the connection " + throwable.getMessage() + " remotePort=[" + n + "] remoteAddress=[" + string + "]");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"failure handling connection", (Object)throwable);
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0103E Could not handle Connection");
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            if (HttpServer.errorLogDisable) continue;
                            Logger.log(1, "HTTP0104E Could not close Socket");
                        }
                        continue;
                    }
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    if (HttpServer.errorLogDisable) continue;
                    Logger.log(1, "HTTP0105E Could not close Socket");
                }
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.http.HttpTransport.run", (String)"198");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"error closing server socket", (Object)iOException);
                    }
                    if (HttpServer.errorLogDisable) break block34;
                    Logger.log(1, "HTTP0106E Could not close Socket");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    public boolean isSecure() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Determine if is secure Connection");
        }
        return this.isSecure;
    }

    public String getScheme() {
        return this.scheme;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public void setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Setting HttpServer");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = Integer.parseInt(string);
    }

    public int getMaxBacklog() {
        return this.maxBacklog;
    }

    public void setMaxBacklog(String string) {
        this.maxBacklog = Integer.parseInt(string);
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(String string) {
        this.tcpNoDelay = this.getBooleanValue(TCP_NO_DELAY, string, true);
    }

    private boolean getBooleanValue(String string, String string2, boolean bl) {
        if (string2.equalsIgnoreCase("true")) {
            Tr.debug((TraceComponent)tc, (String)(string + " set to true"));
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: " + string + " set to true");
            }
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            Tr.debug((TraceComponent)tc, (String)(string + " set to false"));
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: " + string + " set to false");
            }
            return false;
        }
        Tr.warning((TraceComponent)tc, (String)("invalid value for " + string + ": '" + string2 + "'; setting to " + bl));
        if (!HttpServer.errorLogDisable) {
            Logger.log(2, "HTTP0309W invalid value for " + string + ": '" + string2 + "'; setting to " + bl);
        }
        return bl;
    }

    public int getConnectionIOTimeout() {
        return this.connectionIOTimeout;
    }

    public int getConnectionKeepAliveTimeout() {
        return this.connectionKeepAliveTimeout;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setConnectionIOTimeout(int n) {
        this.connectionIOTimeout = n;
    }

    public void setConnectionKeepAliveTimeout(int n) {
        this.connectionKeepAliveTimeout = n;
    }

    public void setMaxKeepAliveRequests(int n) {
        this.maxKeepAliveRequests = n;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setIsKeepAlive(boolean bl) {
        this.isKeepAlive = bl;
    }
}

