/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.CharBuffer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpInputStream
extends FilterInputStream {
    private static final int defaultBufferSize = 2048;
    private static TraceComponent tc = Tr.register((String)HttpInputStream.class.getName(), (String)"HTTP_Transport");
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    public HttpInputStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public HttpInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.buf = new byte[n];
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"size of input stream", (Object)new Integer(n));
        }
    }

    public HttpInputStream() {
        this(null);
    }

    public void init(InputStream inputStream) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init");
        }
        this.in = inputStream;
        this.pos = 0;
        this.markpos = -1;
        this.marklimit = 0;
    }

    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy");
        }
        this.in = null;
    }

    private boolean fill() throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fill");
        }
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                n = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, n);
                this.pos = n;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                n = this.pos * 2;
                if (n > this.marklimit) {
                    n = this.marklimit;
                }
                byte[] byArray = new byte[n];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
        this.count = this.pos;
        n = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fill", (Object)new Integer(n));
        }
        return n > 0;
    }

    public int read() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read");
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"read", (Object)new Integer(-1));
            }
            return -1;
        }
        int n = this.buf[this.pos++] & 0xFF;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)new Integer(n));
        }
        return n;
    }

    private int read1(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            if (n2 >= this.buf.length && this.markpos < 0) {
                return this.in.read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read");
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"read", (Object)new Integer(0));
            }
            return 0;
        }
        int n4 = this.read1(byArray, n, n2);
        if (n4 <= 0) {
            return n4;
        }
        while (n4 < n2 && this.in.available() > 0 && (n3 = this.read1(byArray, n + n4, n2 - n4)) > 0) {
            n4 += n3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)new Integer(n4));
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"skip", (Object)new Long(l));
        }
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.count - this.pos;
        if (l2 <= 0L) {
            if (this.markpos < 0) {
                return this.in.skip(l);
            }
            this.fill();
            l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        this.pos = (int)((long)this.pos + l3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"skip", (Object)new Long(l3));
        }
        return l3;
    }

    public int available() throws IOException {
        int n = this.count - this.pos + this.in.available();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"available", (Object)new Integer(n));
        }
        return n;
    }

    public void mark(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"mark", (Object)new Integer(n));
        }
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public void reset() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset");
        }
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close");
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    public void unread(int n) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unread", (Object)new Integer(n));
        }
        if (this.pos == 0) {
            throw new IOException("Buffer is full");
        }
        this.buf[--this.pos] = (byte)n;
    }

    public boolean readLine(CharBuffer charBuffer, int n, boolean bl) throws IOException, ArrayIndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readLine", (Object)new Object[]{new Integer(n), new Boolean(bl)});
        }
        int n2 = charBuffer.capacity();
        int n3 = charBuffer.length();
        char[] cArray = charBuffer.getValue();
        while (true) {
            int n4;
            if ((n4 = this.count - this.pos) > n2 - n3) {
                n4 = n2 - n3;
            }
            while (n4 > 0) {
                int n5;
                if ((n5 = this.buf[this.pos++] & 0xFF) == 10) {
                    if (n3 > 0 && cArray[n3 - 1] == '\r') {
                        charBuffer.setLength(n3 - 1);
                    } else {
                        charBuffer.setLength(n3);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"readLine", (Object)"true");
                    }
                    return true;
                }
                cArray[n3++] = (char)n5;
                --n4;
            }
            if (this.pos >= this.count && !this.fill()) {
                charBuffer.setLength(n3);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"readLine", (Object)new Integer(n3));
                }
                return n3 > 0;
            }
            if (n3 < n2) continue;
            charBuffer.setLength(n3 + 1);
            n2 = charBuffer.capacity();
            cArray = charBuffer.getValue();
        }
    }
}

