/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.ASSERT;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;

public class Uuid
implements Serializable {
    protected long low64Bits;
    protected static long logicalTime = 0L;
    protected int timeLow;
    protected short timeMid;
    protected short timeHigh;
    protected short clockSeq;
    protected byte[] node = new byte[6];
    protected static byte[] thisIpAddress = null;
    protected String uuidString = null;
    protected static byte[] badadd = new byte[]{11, 10, 13, 10, 13, 13};
    static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = -3465601508791529063L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uuid() {
        int n;
        Object object = Uuid.class;
        synchronized (object) {
            this.low64Bits = System.currentTimeMillis();
            if (logicalTime >= this.low64Bits) {
                this.low64Bits = ++logicalTime;
            } else {
                logicalTime = this.low64Bits;
            }
        }
        this.clockSeq = (short)this.hashCode();
        object = this.getIpAddress();
        for (n = 0; n < ((Object)object).length && n < 4; ++n) {
            this.node[n] = (byte)object[n];
        }
        while (n < 4) {
            this.node[n++] = 0;
        }
        this.node[4] = -86;
        this.node[5] = 119;
        this.timeLow = (int)this.low64Bits & 0xFFFFFFFF;
        this.timeMid = (short)(this.low64Bits >> 32 & 0xFFFFL);
        this.timeHigh = (short)(this.low64Bits >> 48 & 0xFFFFL);
        if (this.timeHigh == 0) {
            Random random = new Random(this.timeLow);
            int n2 = random.nextInt();
            this.timeHigh = (short)(this.timeHigh | n2 | 0xE000);
        }
        this.uuidString = Integer.toHexString(this.timeLow) + "-" + Uuid.toHexString(this.timeMid) + "-" + Uuid.toHexString(this.timeHigh) + "-" + Uuid.toHexString(this.clockSeq) + "-";
        for (n = 0; n < 6; ++n) {
            this.uuidString = this.uuidString + Uuid.toHexString(this.node[n]);
        }
    }

    public String toString() {
        return this.uuidString;
    }

    public boolean isEqual(Uuid uuid) {
        return uuid.toString().equals(this.uuidString);
    }

    private static String toHexString(short s) {
        char[] cArray = new char[]{hexChars[s >> 12 & 0xF], hexChars[s >> 8 & 0xF], hexChars[s >> 4 & 0xF], hexChars[s & 0xF]};
        return new String(cArray, 0, 4);
    }

    private static String toHexString(byte by) {
        char[] cArray = new char[]{hexChars[by >> 4 & 0xF], hexChars[by & 0xF]};
        return new String(cArray, 0, 2);
    }

    private byte[] getIpAddress() {
        if (thisIpAddress == null) {
            InetAddress inetAddress = null;
            try {
                try {
                    inetAddress = (InetAddress)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getLocalHost();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ejs.util.Uuid.getIpAddress", (String)"291", (Object)this);
                    throw (UnknownHostException)privilegedActionException.getException();
                }
                thisIpAddress = inetAddress.getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ejs.util.Uuid.getIpAddress", (String)"298", (Object)this);
                return badadd;
            }
        }
        return thisIpAddress;
    }

    public static void main(String[] stringArray) {
        Uuid uuid = new Uuid();
        if (stringArray.length > 0) {
            int n = Integer.parseInt(stringArray[0]);
            Uuid[] uuidArray = new Uuid[n];
            for (int i = 0; i < n; ++i) {
                uuidArray[i] = new Uuid();
                System.out.println("Uuid #" + (i + 1) + ": " + uuidArray[i].toString());
            }
            ASSERT.isTrue(uuid.isEqual(uuid));
            ASSERT.isFalse(uuid.isEqual(uuidArray[n - 1]));
        } else {
            System.out.println(uuid.toString());
        }
    }
}

