/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.DiskCache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.util.URLUtil;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.SmartSecurityDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;

public final class PersistenceServiceImpl
implements PersistenceService {
    private long _globalLimit = -1L;
    private long _appLimit = -1L;
    private long _size = -1L;
    private static PersistenceServiceImpl _sharedInstance = null;
    private final SmartSecurityDialog _securityDialog = new SmartSecurityDialog();
    private DiskCache _muffincache = null;

    private PersistenceServiceImpl() {
    }

    public static synchronized PersistenceServiceImpl getInstance() {
        PersistenceServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new PersistenceServiceImpl();
        }
        if (_sharedInstance != null) {
            if (PersistenceServiceImpl._sharedInstance._muffincache == null) {
                PersistenceServiceImpl._sharedInstance._muffincache = InstallCache.getMuffinCache();
            }
            PersistenceServiceImpl._sharedInstance._appLimit = ConfigProperties.getInstance().getMuffinSizeLimit();
        }
    }

    long getLength(URL uRL) throws MalformedURLException, IOException {
        if (this._muffincache == null) {
            return -1L;
        }
        this.checkAccess(uRL);
        return this._muffincache.getMuffinSize(uRL);
    }

    long getMaxLength(final URL uRL) throws MalformedURLException, IOException {
        if (this._muffincache == null) {
            return -1L;
        }
        this.checkAccess(uRL);
        Long l = null;
        try {
            l = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    long[] lArray = PersistenceServiceImpl.this._muffincache.getMuffinAttributes(uRL);
                    if (lArray == null) {
                        return new Long(-1L);
                    }
                    return new Long(lArray[1]);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return l;
    }

    long setMaxLength(final URL uRL, long l) throws MalformedURLException, IOException {
        long l2;
        block5: {
            l2 = 0L;
            if (this._muffincache == null) {
                return -1L;
            }
            this.checkAccess(uRL);
            l2 = this.checkSetMaxSize(uRL, l);
            if (l2 < 0L) {
                return -1L;
            }
            final long l3 = l2;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        PersistenceServiceImpl.this._muffincache.putMuffinAttributes(uRL, PersistenceServiceImpl.this.getTag(uRL), l3);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block5;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    private long checkSetMaxSize(final URL uRL, long l) throws IOException {
        long l2;
        URL[] uRLArray = null;
        try {
            uRLArray = (URL[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (PersistenceServiceImpl.this._muffincache == null) {
                        return new Long(-1L);
                    }
                    return PersistenceServiceImpl.this._muffincache.getAccessibleMuffins(uRL);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        long l3 = 0L;
        if (uRLArray != null) {
            int n = 0;
            while (n < uRLArray.length) {
                if (uRLArray[n] != null) {
                    final URL uRL2 = uRLArray[n];
                    Long l4 = null;
                    try {
                        l4 = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return new Long(PersistenceServiceImpl.this._muffincache.getMuffinSize(uRL2));
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    l3 += l4.longValue();
                }
                ++n;
            }
        }
        if ((l2 = l + l3) > this._appLimit) {
            return this.reconcileMaxSize(l, l3, this._appLimit);
        }
        return l;
    }

    private long reconcileMaxSize(long l, long l2, long l3) {
        long l4 = l + l2;
        boolean bl = CheckServicePermission.hasFileAccessPermissions();
        if (bl || this.askUser(l4, l3)) {
            this._appLimit = l4;
            return l;
        }
        return l3 - l2;
    }

    private URL[] getAccessibleMuffins(URL uRL) throws IOException {
        if (this._muffincache == null) {
            return null;
        }
        return this._muffincache.getAccessibleMuffins(uRL);
    }

    public long create(final URL uRL, long l) throws MalformedURLException, IOException {
        Long l2;
        block5: {
            if (this._muffincache == null) {
                return -1L;
            }
            this.checkAccess(uRL);
            l2 = null;
            long l3 = -1L;
            l3 = this.checkSetMaxSize(uRL, l);
            if (l3 < 0L) {
                return -1L;
            }
            final long l4 = l3;
            try {
                l2 = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        File file = PersistenceServiceImpl.this._muffincache.getTempCacheFile(uRL, null);
                        if (file == null) {
                            return new Long(-1L);
                        }
                        PersistenceServiceImpl.this._muffincache.insertMuffinEntry(uRL, file, 0, l4);
                        return new Long(l4);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block5;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    public FileContents get(URL uRL) throws MalformedURLException, IOException {
        if (this._muffincache == null) {
            return null;
        }
        this.checkAccess(uRL);
        File file = this._muffincache.getMuffinFileForURL(uRL);
        if (file == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return new FileContentsImpl(file, this, uRL, this.getMaxLength(uRL));
    }

    public void delete(final URL uRL) throws MalformedURLException, IOException {
        block4: {
            if (this._muffincache == null) {
                return;
            }
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        DiskCacheEntry diskCacheEntry = PersistenceServiceImpl.this._muffincache.getMuffinEntry('P', uRL);
                        if (diskCacheEntry == null) {
                            throw new FileNotFoundException(uRL.toString());
                        }
                        PersistenceServiceImpl.this._muffincache.removeMuffinEntry(diskCacheEntry);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
    }

    public String[] getNames(URL uRL) throws MalformedURLException, IOException {
        String[] stringArray;
        block4: {
            stringArray = null;
            if (this._muffincache == null) {
                return null;
            }
            final URL uRL2 = URLUtil.asPathURL(uRL);
            this.checkAccess(uRL2);
            try {
                stringArray = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        File file = PersistenceServiceImpl.this._muffincache.getMuffinFileForURL(uRL2);
                        if (!file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        File[] fileArray = file.listFiles();
                        Vector<String> vector = new Vector<String>();
                        int n = 0;
                        while (n < fileArray.length) {
                            if (PersistenceServiceImpl.this._muffincache.isMainMuffinFile(fileArray[n])) {
                                DiskCacheEntry diskCacheEntry = PersistenceServiceImpl.this._muffincache.getCacheEntryFromFile(fileArray[n]);
                                URL uRL = diskCacheEntry.getLocation();
                                File file2 = new File(uRL.getFile());
                                vector.addElement(file2.getName());
                            }
                            ++n;
                        }
                        return vector.toArray(new String[0]);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return stringArray;
    }

    public int getTag(final URL uRL) throws MalformedURLException, IOException {
        Integer n;
        block4: {
            n = null;
            if (this._muffincache == null) {
                return -1;
            }
            this.checkAccess(uRL);
            try {
                n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        long[] lArray = PersistenceServiceImpl.this._muffincache.getMuffinAttributes(uRL);
                        if (lArray == null) {
                            throw new MalformedURLException();
                        }
                        return new Integer((int)lArray[0]);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return n;
    }

    public void setTag(final URL uRL, final int n) throws MalformedURLException, IOException {
        block4: {
            if (this._muffincache == null) {
                return;
            }
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        PersistenceServiceImpl.this._muffincache.putMuffinAttributes(uRL, n, PersistenceServiceImpl.this.getMaxLength(uRL));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
    }

    private boolean askUser(final long l, final long l2) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = Resources.getString("APIImpl.persistence.message", new Long(l), new Long(l2));
                return new Boolean(PersistenceServiceImpl.this._securityDialog.showDialog(string));
            }
        });
        return bl;
    }

    private void checkAccess(URL uRL) throws MalformedURLException {
        URL uRL2;
        LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
        if (launchDesc != null && (uRL2 = launchDesc.getCodebase()) != null) {
            int n;
            String string;
            if (uRL == null || !uRL2.getHost().equals(uRL.getHost())) {
                this.throwAccessDenied(uRL);
            }
            if ((string = uRL.getFile()) == null) {
                this.throwAccessDenied(uRL);
            }
            if ((n = string.lastIndexOf(47)) == -1) {
                return;
            }
            if (!uRL2.getFile().startsWith(string.substring(0, n + 1))) {
                this.throwAccessDenied(uRL);
            }
        }
    }

    private void throwAccessDenied(URL uRL) throws MalformedURLException {
        throw new MalformedURLException(Resources.getString("APIImpl.persistence.accessdenied", uRL.toString()));
    }
}

