/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.prefs.JRESearcher;
import com.sun.javaws.ui.prefs.PrefsPanel;
import com.sun.javaws.ui.prefs.TableKeyActions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class JREPanel
extends PrefsPanel.PropertyPanel
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static Border badBorder = new LineBorder(Color.red);
    private JTable jresTable;
    private JTextField locationTF;
    private JRETableModel tableModel;
    private JButton findButton;
    private JButton removeButton;
    private JButton chooseButton;
    private int _nextAvailableJREIndex = 0;
    private HashSet _hiddenJres = new HashSet();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    protected void createPropertyControls() {
        Serializable serializable;
        this.tableModel = new JRETableModel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TitledBorder titledBorder = new TitledBorder(LineBorder.createGrayLineBorder(), Resources.getString("controlpanel.jre.title"), 1, 2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(titledBorder);
        this.jresTable = new JTable(this.tableModel);
        this.jresTable.getAccessibleContext().setAccessibleName(Resources.getString("controlpanel.jre.tableName"));
        this.jresTable.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.jre.tableDesc"));
        this.jresTable.getTableHeader().getAccessibleContext().setAccessibleName(Resources.getString("controlpanel.jre.tableName"));
        this.jresTable.getTableHeader().getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.jre.tableDesc"));
        Enumeration<TableColumn> enumeration = this.jresTable.getColumnModel().getColumns();
        JRETableCellRenderer jRETableCellRenderer = new JRETableCellRenderer();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            if (((TableColumn)serializable).getModelIndex() >= 4) continue;
            ((TableColumn)serializable).setCellRenderer(jRETableCellRenderer);
        }
        this.jresTable.setPreferredScrollableViewportSize(new Dimension(450, 150));
        this.jresTable.getSelectionModel().addListSelectionListener(this);
        this.jresTable.getColumnModel().getColumn(3).setCellRenderer(new JRETableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent && !JREPanel.this.tableModel.isPathValid(n)) {
                    ((JComponent)component).setBorder(badBorder);
                }
                return component;
            }
        });
        this.jresTable.getColumnModel().getColumn(3).setCellEditor(new PathEditor());
        this.jresTable.getColumnModel().getColumn(4).setCellRenderer(new EnabledCellRenderer());
        this.jresTable.getColumnModel().getColumn(4).setCellEditor(new EnabledCellEditor());
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JScrollPane(this.jresTable), gridBagConstraints);
        this.jresTable.registerKeyboardAction(TableKeyActions.decColumnAction, KeyStroke.getKeyStroke(114, 0), 0);
        this.jresTable.registerKeyboardAction(TableKeyActions.incColumnAction, KeyStroke.getKeyStroke(115, 0), 0);
        this.jresTable.getTableHeader().setReorderingAllowed(false);
        serializable = Box.createHorizontalBox();
        this.chooseButton = new JButton(Resources.getString("controlpanel.jre.choose"));
        this.chooseButton.setMnemonic(Resources.getVKCode("controlpanel.jre.chooseMnemonic"));
        this.chooseButton.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.jre.chooseDescr"));
        this.chooseButton.setRequestFocusEnabled(false);
        this.chooseButton.addActionListener(this);
        ((Container)serializable).add(this.chooseButton);
        ((Container)serializable).add(Box.createHorizontalGlue());
        JButton jButton = new JButton(Resources.getString("controlpanel.jre.find"));
        jButton.setRequestFocusEnabled(false);
        jButton.addActionListener(this);
        ((Container)serializable).add(jButton);
        ((Container)serializable).add(Box.createHorizontalStrut(5));
        this.findButton = jButton;
        this.findButton.setMnemonic(Resources.getVKCode("controlpanel.jre.findMnemonic"));
        this.findButton.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.jre.findDescr"));
        jButton = new JButton(Resources.getString("controlpanel.jre.add"));
        jButton.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.jre.addDescr"));
        jButton.setRequestFocusEnabled(false);
        jButton.addActionListener(this);
        jButton.setMnemonic(Resources.getVKCode("controlpanel.jre.addMnemonic"));
        ((Container)serializable).add(jButton);
        ((Container)serializable).add(Box.createHorizontalStrut(5));
        jButton = new JButton(Resources.getString("controlpanel.jre.remove"));
        jButton.setRequestFocusEnabled(false);
        ((Container)serializable).add(jButton);
        this.removeButton = jButton;
        this.removeButton.addActionListener(this);
        this.removeButton.setMnemonic(Resources.getVKCode("controlpanel.jre.removeMnemonic"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(Resources.getString("controlpanel.jre.removeDescr"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)serializable, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)jPanel, gridBagConstraints);
        this.updateRemoveButton();
        this.tableModel.addTableModelListener(this);
        this.revert();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        if (jComponent == this.removeButton) {
            this.tableModel.remove(this.jresTable.getSelectedRows());
            this.jresTable.clearSelection();
            int n = this.tableModel.getRowCount() - 1;
            this.jresTable.requestFocus();
            this.jresTable.setRowSelectionInterval(n, n);
        } else if (jComponent == this.findButton) {
            this.findJREs();
            this.findButton.requestFocus();
        } else if (jComponent == this.chooseButton) {
            int n = this.jresTable.getSelectedRow();
            if (n != -1) {
                this.changePath(n);
                this.chooseButton.requestFocus();
            }
        } else {
            this.tableModel.add(new ConfigProperties.JREInformation(null, null, null, null, 0, true, this.getNextAvailableJREIndex(), Globals.osName, Globals.osArch));
            int n = this.tableModel.getRowCount() - 1;
            this.jresTable.requestFocus();
            this.jresTable.setRowSelectionInterval(n, n);
        }
    }

    private int getNextAvailableJREIndex() {
        return this._nextAvailableJREIndex++;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateRemoveButton();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateRemoveButton();
    }

    public void apply() {
        if (this.jresTable.isEditing()) {
            this.jresTable.getCellEditor().stopCellEditing();
        }
        ConfigProperties configProperties = ConfigProperties.getInstance();
        ArrayList arrayList = configProperties.getJREInformationList();
        if (this.tableModel.getRowCount() > 0) {
            arrayList.clear();
            int n = 0;
            while (n < this.tableModel.getRowCount()) {
                arrayList.add(this.tableModel.getJRE(n));
                ++n;
            }
            Iterator iterator = this._hiddenJres.iterator();
            while (iterator.hasNext()) {
                ConfigProperties.JREInformation jREInformation = (ConfigProperties.JREInformation)iterator.next();
                arrayList.add(jREInformation);
            }
        }
    }

    public void revert() {
        this.jresTable.removeEditor();
        this.tableModel.refresh();
    }

    private void updateRemoveButton() {
        int n = this.jresTable.getSelectedRow();
        int n2 = this.jresTable.getRowCount();
        this.removeButton.setEnabled(n != -1 && n2 > 1 && n < n2 && this.tableModel.getJRE(n).getWhereSpecified() == 0);
        this.chooseButton.setEnabled(n != -1 && n2 > 1 && n < n2 && this.tableModel.getJRE(n).getWhereSpecified() == 0);
    }

    private void versionChanged(int n) {
    }

    private boolean isValidJREPath(String string) {
        if (string != null) {
            File file = new File(string);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    private void changePath(int n) {
        JFileChooser jFileChooser = new JFileChooser();
        File file = this.getFirstValidParent(n);
        if (file != null && file.exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.tableModel.setValueAt(jFileChooser.getSelectedFile().getPath(), n, 3);
        }
    }

    private void findJREs() {
        JFileChooser jFileChooser = new JFileChooser();
        File file = this.getFirstValidParent(this.jresTable.getSelectedRow());
        if (file != null && file.exists()) {
            jFileChooser.setSelectedFile(file);
        }
        jFileChooser.setDialogType(0);
        ConfigProperties.JREInformation[] jREInformationArray = new JRESearcher().search(this.getComponent(), Resources.getResources(), Resources.getString("controlpanel.findJREIntro"));
        if (jREInformationArray != null) {
            int n = 0;
            while (n < jREInformationArray.length) {
                this.tableModel.add(jREInformationArray[n]);
                ++n;
            }
        }
    }

    private File getFirstValidParent(int n) {
        String string;
        if (n != -1 && (string = this.tableModel.getJRE(n).getInstalledPath()) != null) {
            File file = new File(string);
            while (file != null && !file.exists()) {
                string = file.getParent();
                file = string != null ? new File(string) : null;
            }
            return file;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JRETableModel
    extends AbstractTableModel {
        private ArrayList _jres = new ArrayList();
        private ArrayList _validPaths = new ArrayList();
        private String[] _columnNames;

        JRETableModel() {
            this.refresh();
        }

        public void refresh() {
            this._jres.clear();
            this._validPaths.clear();
            JREPanel.this._hiddenJres.clear();
            ConfigProperties configProperties = ConfigProperties.getInstance();
            ArrayList arrayList = configProperties.getJREInformationList();
            int n = 0;
            while (n < arrayList.size()) {
                ConfigProperties.JREInformation jREInformation = (ConfigProperties.JREInformation)arrayList.get(n);
                if (jREInformation.getOsName() == null || jREInformation.getOsArch() == null || jREInformation.getOsName().equals(Globals.osName) && jREInformation.getOsArch().equals(Globals.osArch)) {
                    this.add(jREInformation.copy(), false, false);
                    if (jREInformation.getIndex() >= JREPanel.this._nextAvailableJREIndex) {
                        JREPanel.this._nextAvailableJREIndex = jREInformation.getIndex() + 1;
                    }
                } else {
                    JREPanel.this._hiddenJres.add(jREInformation.copy());
                }
                ++n;
            }
            this.fireTableDataChanged();
        }

        public void add(ConfigProperties.JREInformation jREInformation) {
            this.add(jREInformation, false, true);
        }

        void add(ConfigProperties.JREInformation jREInformation, boolean bl, boolean bl2) {
            this._jres.add(jREInformation);
            if (bl) {
                this._validPaths.add(Boolean.TRUE);
            } else {
                this._validPaths.add(null);
            }
            if (bl2) {
                this.fireTableRowsInserted(this._jres.size() - 1, this._jres.size() - 1);
            }
        }

        public int getRowCount() {
            return this._jres.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int n) {
            if (n < 4) {
                return class$java$lang$String == null ? (class$java$lang$String = JREPanel.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JREPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getJRE(n).getPlatformVersionId();
                }
                case 1: {
                    return this.getJRE(n).getProductVersionId();
                }
                case 2: {
                    return this.getJRE(n).getProductLocation();
                }
                case 3: {
                    return this.getJRE(n).getInstalledPath();
                }
            }
            return new Boolean(this.getJRE(n).isEnabled());
        }

        public boolean isPathValid(int n) {
            Boolean bl = (Boolean)this._validPaths.get(n);
            if (bl == null) {
                bl = JREPanel.this.isValidJREPath(this.getJRE(n).getInstalledPath()) ? Boolean.TRUE : Boolean.FALSE;
                this._validPaths.set(n, bl);
            }
            return Boolean.TRUE.equals(bl);
        }

        public String getColumnName(int n) {
            if (this._columnNames == null) {
                this._columnNames = new String[]{Resources.getString("controlpanel.jre.platformVersionTableColumnTitle"), Resources.getString("controlpanel.jre.productVersionTableColumnTitle"), Resources.getString("controlpanel.jre.productLocationTableColumnTitle"), Resources.getString("controlpanel.jre.pathTableColumnTitle"), Resources.getString("controlpanel.jre.enabledColumnTitle")};
            }
            return this._columnNames[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return this.getJRE(n).getWhereSpecified() == 0 || n2 == 4;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n >= this._jres.size()) {
                return;
            }
            ConfigProperties.JREInformation jREInformation = this.getJRE(n);
            switch (n2) {
                case 0: {
                    this._jres.set(n, new ConfigProperties.JREInformation((String)object, jREInformation.getProductVersionId(), jREInformation.getProductLocation(), jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    break;
                }
                case 1: {
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), (String)object, jREInformation.getProductLocation(), jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    JREPanel.this.versionChanged(n);
                    break;
                }
                case 2: {
                    URL uRL = jREInformation.getProductLocation();
                    try {
                        uRL = new URL((String)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), jREInformation.getProductVersionId(), uRL, jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    JREPanel.this.versionChanged(n);
                    break;
                }
                case 3: {
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), jREInformation.getProductVersionId(), jREInformation.getProductLocation(), (String)object, jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    this._validPaths.set(n, null);
                    break;
                }
                default: {
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), jREInformation.getProductVersionId(), jREInformation.getProductLocation(), jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), (Boolean)object, jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                }
            }
            this.fireTableRowsUpdated(n, n);
        }

        public void remove(int[] nArray) {
            if (nArray != null) {
                int n = this.getRowCount();
                int n2 = nArray.length - 1;
                while (n2 >= 0) {
                    if (nArray[n2] != -1 && nArray[n2] < n) {
                        this._jres.remove(nArray[n2]);
                        this._validPaths.remove(nArray[n2]);
                    }
                    --n2;
                }
            }
            this.fireTableDataChanged();
        }

        public ConfigProperties.JREInformation getJRE(int n) {
            return (ConfigProperties.JREInformation)this._jres.get(n);
        }
    }

    private class JRETableCellRenderer
    extends DefaultTableCellRenderer {
        private JRETableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof Component) {
                component.getAccessibleContext().setAccessibleName(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                component.getAccessibleContext().setAccessibleDescription(jTable.getModel().getColumnName(jTable.convertColumnIndexToModel(n2)) + " " + object);
                if (((JRETableModel)jTable.getModel()).getJRE(n).getWhereSpecified() != 0 && n2 < 4) {
                    component.setEnabled(false);
                } else {
                    component.setEnabled(true);
                }
            }
            return component;
        }
    }

    private class EnabledCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        protected Border focusBorder;
        protected Border noFocusBorder;

        public EnabledCellRenderer() {
            this.setOpaque(true);
            this.setBorderPainted(true);
            this.setHorizontalAlignment(0);
        }

        public void updateUI() {
            super.updateUI();
            this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            this.noFocusBorder = null;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null) {
                if (this.noFocusBorder == null) {
                    Insets insets = this.focusBorder.getBorderInsets(this);
                    this.noFocusBorder = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
                }
                if (bl2) {
                    this.setBorder(this.focusBorder);
                } else {
                    this.setBorder(this.noFocusBorder);
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setBackground(jTable.getBackground());
                    this.setForeground(jTable.getForeground());
                }
            }
            this.setSelected(Boolean.TRUE.equals(object));
            return this;
        }
    }

    private class EnabledCellEditor
    extends DefaultCellEditor {
        EnabledCellEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = new JCheckBox();
            ((JCheckBox)this.editorComponent).setOpaque(true);
            ((JCheckBox)this.editorComponent).setBorderPainted(true);
            ((JCheckBox)this.editorComponent).setHorizontalAlignment(0);
        }
    }

    private class PathEditor
    extends DefaultCellEditor
    implements DocumentListener {
        private int row;

        PathEditor() {
            super(new JTextField());
            ((JTextField)this.editorComponent).getDocument().addDocumentListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            this.updateBorder(n);
            return this.editorComponent;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateBorderFromEditor();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateBorderFromEditor();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateBorder(int n) {
            Border border = JREPanel.this.tableModel.isPathValid(n) ? LineBorder.createGrayLineBorder() : badBorder;
            this.editorComponent.setBorder(border);
        }

        private void updateBorderFromEditor() {
            Object object = this.getCellEditorValue();
            boolean bl = object instanceof String ? JREPanel.this.isValidJREPath((String)object) : false;
            if (bl) {
                this.editorComponent.setBorder(LineBorder.createGrayLineBorder());
            } else {
                this.editorComponent.setBorder(badBorder);
            }
        }
    }
}

