/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LaunchErrorDialog;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.security.CertificateDialog;
import com.sun.javaws.security.KeyStoreManager;
import com.sun.javaws.security.SigningInfo;
import com.sun.jnlp.JNLPClassLoader;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.PropertyPermission;

public class AppPolicy {
    private String _host = null;
    private HashSet _sessionCertificates = new HashSet();
    private File _extensionDir = null;
    private static AppPolicy _instance = null;

    public static AppPolicy getInstance() {
        return _instance;
    }

    public static AppPolicy createInstance(String string) {
        if (_instance == null) {
            _instance = new AppPolicy(string);
        }
        return _instance;
    }

    private AppPolicy(String string) {
        this._host = string;
        this._extensionDir = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext");
    }

    public void addPermissions(PermissionCollection permissionCollection, CodeSource codeSource) {
        int n;
        Object object;
        Object object2;
        LaunchDesc launchDesc;
        if (Globals.TraceSecurity) {
            Debug.println("Permission requested for: " + codeSource.getLocation());
        }
        URL uRL = codeSource.getLocation();
        Certificate[] certificateArray = codeSource.getCertificates();
        JARDesc jARDesc = JNLPClassLoader.getInstance().getJarDescFromFileURL(uRL);
        if (jARDesc == null) {
            return;
        }
        if (Globals.TraceSecurity) {
            launchDesc = null;
            Certificate[] certificateArray2 = null;
            try {
                String string = uRL.getFile();
                object2 = new File(string);
                object = InstallCache.getDiskCache().getCacheEntryFromFile((File)object2);
                if (object != null) {
                    certificateArray2 = ((DiskCacheEntry)object).getCertificateChain();
                }
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
            if (certificateArray == null) {
                Debug.println("No certificates in codesource");
            } else {
                Debug.println("Found certificate chain of length " + codeSource.getCertificates().length + " in codesource");
            }
            if (certificateArray2 == null) {
                Debug.println("No certificates in cache");
            } else {
                Debug.println("Found certificate chain of length " + certificateArray.length + " in cache");
            }
            if (certificateArray != null && codeSource.getCertificates() != null) {
                Debug.jawsAssert(certificateArray.length == certificateArray2.length, "Certificate length must be the same");
                int n2 = 0;
                while (n2 < certificateArray.length) {
                    if (!certificateArray[n2].equals(certificateArray2[n2])) {
                        Debug.fatal("Certificate chain does not match");
                    }
                    ++n2;
                }
            }
        }
        if ((n = (launchDesc = jARDesc.getParent().getParent()).getSecurityModel()) != 0 && this.grantUnrestrictedAccess(launchDesc, jARDesc.getLocation(), certificateArray)) {
            if (n == 1) {
                this.addAllPermissionsObject(permissionCollection);
            } else {
                this.addJ2EEApplicationClientPermissionsObject(permissionCollection);
            }
        } else {
            this.addSandboxPermissionsObject(permissionCollection, launchDesc.getLaunchType() == 2);
        }
        if (!launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            object2 = properties.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string = properties.getProperty((String)object);
                PropertyPermission propertyPermission = new PropertyPermission((String)object, "write");
                if (permissionCollection.implies(propertyPermission)) {
                    System.setProperty((String)object, string);
                    continue;
                }
                Debug.ignoredException(new AccessControlException("access denied " + propertyPermission, propertyPermission));
            }
            launchDesc.setPropsSet(true);
        }
    }

    private void setUnrestrictedProps(LaunchDesc launchDesc) {
        if (!launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                System.setProperty(string, properties.getProperty(string));
            }
            launchDesc.setPropsSet(true);
        }
    }

    public boolean grantUnrestrictedAccess(LaunchDesc launchDesc, URL uRL, Certificate[] certificateArray) {
        Certificate[] certificateArray2;
        String string = launchDesc.getInformation().getTitle();
        int n = launchDesc.getLaunchType();
        char c = n == 1 || n == 2 ? (char)'A' : 'E';
        URL uRL2 = launchDesc.getCanonicalHome();
        if (certificateArray == null || certificateArray.length == 0) {
            CodeSource codeSource = new CodeSource(uRL, certificateArray);
            LaunchErrorDialog.show(null, new UnsignedAccessViolationException(launchDesc, codeSource.getLocation(), false));
            Debug.shouldNotReachHere();
            return false;
        }
        if (launchDesc.getCertificateChain() != null) {
            if (!SigningInfo.equalChains(certificateArray, launchDesc.getCertificateChain())) {
                LaunchDescException launchDescException = new LaunchDescException(launchDesc, Resources.getString("launch.error.singlecertviolation"), null);
                LaunchErrorDialog.show(null, launchDescException);
                Debug.shouldNotReachHere();
                return false;
            }
            this.setUnrestrictedProps(launchDesc);
            return true;
        }
        if (this._sessionCertificates.contains(certificateArray[0])) {
            launchDesc.setCertificateChain(certificateArray);
            this.setUnrestrictedProps(launchDesc);
            return true;
        }
        try {
            certificateArray2 = InstallCache.getDiskCache().getCertificateChain(c, uRL2, null);
            if (certificateArray2 != null && certificateArray[0].equals(certificateArray2[0])) {
                this._sessionCertificates.add(certificateArray[0]);
                launchDesc.setCertificateChain(certificateArray);
                this.setUnrestrictedProps(launchDesc);
                return true;
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        certificateArray2 = KeyStoreManager.makeTrusted(certificateArray);
        boolean bl = CertificateDialog.verifyCertificate(null, string, certificateArray2, n);
        if (bl) {
            this._sessionCertificates.add(certificateArray[0]);
            launchDesc.setCertificateChain(certificateArray);
            try {
                InstallCache.getDiskCache().putCertificateChain(c, uRL2, null, certificateArray);
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
            this.setUnrestrictedProps(launchDesc);
        }
        return bl;
    }

    private void addAllPermissionsObject(PermissionCollection permissionCollection) {
        if (Globals.TraceSecurity) {
            Debug.println("adding all-permissions object");
        }
        permissionCollection.add(new AllPermission());
    }

    private void addJ2EEApplicationClientPermissionsObject(PermissionCollection permissionCollection) {
        if (Globals.TraceSecurity) {
            Debug.println("Creating J222-application-client-permisisons object");
        }
        permissionCollection.add(new AWTPermission("accessClipboard"));
        permissionCollection.add(new AWTPermission("accessEventQueue"));
        permissionCollection.add(new AWTPermission("showWindowWithoutWarningBanner"));
        permissionCollection.add(new RuntimePermission("exitVM"));
        permissionCollection.add(new RuntimePermission("loadLibrary"));
        permissionCollection.add(new RuntimePermission("queuePrintJob"));
        permissionCollection.add(new SocketPermission("*", "connect"));
        permissionCollection.add(new SocketPermission("localhost:1024-", "accept,listen"));
        permissionCollection.add(new FilePermission("*", "read,write"));
        permissionCollection.add(new PropertyPermission("*", "read"));
    }

    private void addSandboxPermissionsObject(PermissionCollection permissionCollection, boolean bl) {
        if (Globals.TraceSecurity) {
            Debug.println("Add sandbox permissions");
        }
        permissionCollection.add(new PropertyPermission("java.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor.url", "read"));
        permissionCollection.add(new PropertyPermission("java.class.version", "read"));
        permissionCollection.add(new PropertyPermission("os.name", "read"));
        permissionCollection.add(new PropertyPermission("os.arch", "read"));
        permissionCollection.add(new PropertyPermission("os.version", "read"));
        permissionCollection.add(new PropertyPermission("file.separator", "read"));
        permissionCollection.add(new PropertyPermission("path.separator", "read"));
        permissionCollection.add(new PropertyPermission("line.separator", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.name", "read"));
        permissionCollection.add(new PropertyPermission("javawebstart.version", "read"));
        permissionCollection.add(new RuntimePermission("exitVM"));
        permissionCollection.add(new RuntimePermission("stopThread"));
        String string = "Java " + (bl ? "Applet" : "Application") + " Window";
        System.setProperty("awt.appletWarning", string);
        permissionCollection.add(new SocketPermission("localhost:1024-", "listen"));
        permissionCollection.add(new SocketPermission(this._host, "connect, accept"));
        permissionCollection.add(new PropertyPermission("jnlp.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaws.*", "read,write"));
        Iterator iterator = ConfigProperties.getInstance().getSecurePropertyKeys();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                permissionCollection.add(new PropertyPermission(string2, "read,write"));
            }
        }
    }
}

