/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.ErrorCodeResponseException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.MultipleHostsException;
import com.sun.javaws.exceptions.NativeLibViolationException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class LaunchDownload {
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";

    static LaunchDesc getLaunchDescFromCache(LaunchDesc launchDesc) {
        if (launchDesc.getLocation() == null) {
            return launchDesc;
        }
        try {
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getLocation());
            if (diskCacheEntry == null) {
                return launchDesc;
            }
            if (Globals.TraceStartup) {
                Debug.println("Loaded descriptor from cache at: " + launchDesc.getLocation());
            }
            return LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
        }
        catch (JNLPException jNLPException) {
            Debug.ignoredException(jNLPException);
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return launchDesc;
    }

    static LaunchDesc getUpdatedLaunchDesc(LaunchDesc launchDesc) throws JNLPException, IOException {
        if (launchDesc.getLocation() == null) {
            return null;
        }
        boolean bl = DownloadProtocol.isLaunchFileUpdateAvailable(launchDesc.getLocation());
        if (!bl) {
            return null;
        }
        if (Globals.TraceStartup) {
            Debug.println("Downloading updated JNLP descriptor from: " + launchDesc.getLocation());
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getLaunchFile(launchDesc.getLocation(), false);
        return LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
    }

    public static boolean isInCache(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        try {
            DiskCacheEntry diskCacheEntry;
            if (launchDesc.getLocation() != null && (diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getLocation())) == null) {
                return false;
            }
            boolean bl = LaunchDownload.getCachedExtensions(launchDesc);
            if (!bl) {
                return false;
            }
            JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(false);
            int n = 0;
            while (n < jARDescArray.length) {
                int n2;
                int n3 = n2 = jARDescArray[n].isJavaFile() ? 0 : 1;
                if (!DownloadProtocol.isInCache(jARDescArray[n].getLocation(), jARDescArray[n].getVersion(), n2)) {
                    return false;
                }
                ++n;
            }
        }
        catch (JNLPException jNLPException) {
            Debug.ignoredException(jNLPException);
            return false;
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
            return false;
        }
        return true;
    }

    public static boolean isUpdateAvailable(LaunchDesc launchDesc) throws JNLPException {
        Object object;
        int n;
        Object object2;
        boolean bl;
        URL uRL = launchDesc.getLocation();
        if (uRL != null && (bl = DownloadProtocol.isLaunchFileUpdateAvailable(uRL))) {
            return true;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return false;
        }
        ExtensionDesc[] extensionDescArray = resourcesDesc.getExtensionDescs();
        int n2 = 0;
        while (n2 < extensionDescArray.length) {
            object2 = extensionDescArray[n2].getLocation();
            if (object2 != null && (n = (int)(DownloadProtocol.isUpdateAvailable((URL)object2, extensionDescArray[n2].getVersion(), 4) ? 1 : 0)) != 0) {
                return true;
            }
            ++n2;
        }
        object2 = resourcesDesc.getEagerOrAllJarDescs(true);
        n = 0;
        while (n < ((JARDesc[])object2).length) {
            int n3;
            object = object2[n].getLocation();
            String string = object2[n].getVersion();
            int n4 = n3 = object2[n].isJavaFile() ? 0 : 1;
            if (DownloadProtocol.isInCache((URL)object, string, n3) && DownloadProtocol.isUpdateAvailable((URL)object, string, n3)) {
                return true;
            }
            ++n;
        }
        object = launchDesc.getInformation().getIcons();
        if (object != null) {
            int n5 = 0;
            while (n5 < ((IconDesc[])object).length) {
                int n6;
                String string;
                URL uRL2 = object[n5].getLocation();
                if (DownloadProtocol.isInCache(uRL2, string = object[n5].getVersion(), n6 = 2) && DownloadProtocol.isUpdateAvailable(uRL2, string, n6)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    public static File[] getNativeDirectories(LaunchDesc launchDesc) {
        Object object;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return new File[0];
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < jARDescArray.length) {
            String string;
            DiskCacheEntry diskCacheEntry;
            if (jARDescArray[n].isNativeLib() && (diskCacheEntry = DownloadProtocol.getCachedVersion((URL)(object = jARDescArray[n].getLocation()), string = jARDescArray[n].getVersion(), 1)) != null) {
                arrayList.add(diskCacheEntry.getDirectory());
            }
            ++n;
        }
        object = new File[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    static void downloadExtensions(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, ArrayList arrayList) throws IOException, JNLPException {
        LaunchDownload.downloadExtensionsHelper(launchDesc, downloadProgress, n, false, arrayList);
    }

    private static boolean getCachedExtensions(LaunchDesc launchDesc) throws IOException, JNLPException {
        return LaunchDownload.downloadExtensionsHelper(launchDesc, null, 0, true, null);
    }

    private static boolean downloadExtensionsHelper(LaunchDesc launchDesc, DownloadProgress downloadProgress, int n, boolean bl, ArrayList arrayList) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        String string = ConfigProperties.getInstance().getKnownPlatforms();
        final ArrayList arrayList2 = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList2.add(extensionDesc);
            }
        });
        n += arrayList2.size();
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            int n3;
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList2.get(n2);
            String string2 = extensionDesc.getName();
            if (string2 == null && (n3 = (string2 = extensionDesc.getLocation().toString()).lastIndexOf(47)) > 0) {
                string2 = string2.substring(n3 + 1, string2.length());
            }
            --n;
            if (downloadProgress != null) {
                downloadProgress.extensionDownload(string2, n);
            }
            DiskCacheEntry diskCacheEntry = null;
            if (!bl) {
                diskCacheEntry = DownloadProtocol.getExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), string, false);
            } else {
                diskCacheEntry = DownloadProtocol.getCachedExtension(extensionDesc.getLocation(), extensionDesc.getVersion(), string);
                if (diskCacheEntry == null) {
                    return false;
                }
            }
            if (Globals.TraceDownload) {
                System.out.println("Downloaded extension: " + extensionDesc.getLocation() + ": " + diskCacheEntry.getFile());
            }
            LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
            boolean bl2 = false;
            if (launchDesc2.getLaunchType() == 3) {
                bl2 = true;
            } else if (launchDesc2.getLaunchType() == 4) {
                extensionDesc.setInstaller(true);
                LocalApplicationProperties localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(diskCacheEntry.getLocation(), diskCacheEntry.getVersionId(), launchDesc, false);
                boolean bl3 = bl2 = !localApplicationProperties.isLocallyInstalled();
                if (arrayList != null && (LaunchDownload.isUpdateAvailable(launchDesc2) || bl2)) {
                    arrayList.add(diskCacheEntry.getFile());
                }
                if (bl && bl2) {
                    return false;
                }
            } else {
                throw new MissingFieldException(launchDesc2.getSource(), "<component-desc>|<installer-desc>");
            }
            if (bl2) {
                extensionDesc.setExtensionDesc(launchDesc2);
                boolean bl4 = LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, n, bl, arrayList);
                if (!bl4) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static void downloadJRE(LaunchDesc launchDesc, DownloadProgress downloadProgress, ArrayList arrayList) throws JNLPException, IOException {
        boolean bl;
        JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
        String string = jREDesc.getVersion();
        URL uRL = jREDesc.getHref();
        boolean bl2 = bl = uRL == null;
        if (uRL == null) {
            uRL = ConfigProperties.getInstance().getJREInstallURL();
        }
        if (downloadProgress != null) {
            downloadProgress.jreDownload(string, uRL);
        }
        String string2 = ConfigProperties.getInstance().getKnownPlatforms();
        DiskCacheEntry diskCacheEntry = null;
        try {
            diskCacheEntry = DownloadProtocol.getJRE(uRL, string, bl, string2);
        }
        catch (ErrorCodeResponseException errorCodeResponseException) {
            errorCodeResponseException.setJreDownload(true);
            throw errorCodeResponseException;
        }
        LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
        if (launchDesc2.getLaunchType() != 4) {
            throw new MissingFieldException(launchDesc2.getSource(), "<installer-desc>");
        }
        if (arrayList != null) {
            arrayList.add(diskCacheEntry.getFile());
        }
        jREDesc.setExtensionDesc(launchDesc2);
        LaunchDownload.downloadExtensionsHelper(launchDesc2, downloadProgress, 0, false, arrayList);
    }

    public static void downloadResource(LaunchDesc launchDesc, URL uRL, String string, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadParts(LaunchDesc launchDesc, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadExtensionPart(LaunchDesc launchDesc, URL uRL, String string, String[] stringArray, DownloadProgress downloadProgress, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, downloadProgress, bl);
    }

    public static void downloadEagerorAll(LaunchDesc launchDesc, boolean bl, DownloadProgress downloadProgress, boolean bl2) throws IOException, JNLPException {
        JARDesc[] jARDescArray;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray2 = resourcesDesc.getEagerOrAllJarDescs(bl);
        if (!bl && (jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true)).length != jARDescArray2.length) {
            int n;
            JARDesc[] jARDescArray3;
            HashSet<JARDesc> hashSet = new HashSet<JARDesc>(Arrays.asList(jARDescArray2));
            int n2 = 0;
            int n3 = 0;
            while (n3 < jARDescArray.length) {
                jARDescArray3 = jARDescArray[n3].getLocation();
                String string = jARDescArray[n3].getVersion();
                int n4 = n = jARDescArray[n3].isJavaFile() ? 0 : 1;
                if (!hashSet.contains(jARDescArray[n3]) && DownloadProtocol.isInCache((URL)jARDescArray3, string, n)) {
                    ++n2;
                } else {
                    jARDescArray[n3] = null;
                }
                ++n3;
            }
            if (n2 > 0) {
                jARDescArray3 = new JARDesc[jARDescArray2.length + n2];
                System.arraycopy(jARDescArray2, 0, jARDescArray3, 0, jARDescArray2.length);
                int n5 = jARDescArray2.length;
                n = 0;
                while (n < jARDescArray.length) {
                    if (jARDescArray[n] != null) {
                        jARDescArray3[n5++] = jARDescArray[n];
                    }
                    ++n;
                }
                jARDescArray2 = jARDescArray3;
            }
        }
        LaunchDownload.downloadJarFiles(jARDescArray2, downloadProgress, bl2);
    }

    private static void downloadJarFiles(JARDesc[] jARDescArray, DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        int n;
        Object object;
        if (jARDescArray == null) {
            return;
        }
        if (Globals.TraceDownload) {
            Debug.println("Contacting server for JAR file sizes");
        }
        long l = 0L;
        int n2 = 0;
        while (n2 < jARDescArray.length && l != -1L) {
            try {
                object = jARDescArray[n2];
                n = ((JARDesc)object).isNativeLib() ? 1 : 0;
                long l2 = ((JARDesc)object).getSize();
                if (l2 == 0L) {
                    l2 = DownloadProtocol.getDownloadSize(jARDescArray[n2].getLocation(), jARDescArray[n2].getVersion(), n);
                }
                if (Globals.TraceDownload) {
                    Debug.println("Size of " + jARDescArray[n2].getLocation() + ": " + l2);
                }
                l = l2 == -1L ? -1L : (l += l2);
            }
            catch (JNLPException jNLPException) {
                if (downloadProgress != null) {
                    downloadProgress.downloadFailed(jARDescArray[n2].getLocation(), jARDescArray[n2].getVersion());
                }
                throw jNLPException;
            }
            ++n2;
        }
        if (Globals.TraceDownload) {
            Debug.println("Total size to download: " + l);
        }
        if (l == 0L) {
            return;
        }
        object = new DownloadCallbackHelper(downloadProgress, l);
        n = 0;
        while (n < jARDescArray.length) {
            JARDesc jARDesc = jARDescArray[n];
            try {
                int n3 = jARDesc.isNativeLib() ? 1 : 0;
                DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDescArray[n].getLocation(), jARDescArray[n].getVersion(), n3, bl, (DownloadProtocol.DownloadDelegate)object);
                if (Globals.TraceDownload) {
                    System.out.println("Downloaded " + jARDescArray[n].getLocation() + ": " + diskCacheEntry);
                }
                if (diskCacheEntry == null) {
                    throw new FailedDownloadingResourceException(null, jARDescArray[n].getLocation(), jARDescArray[n].getVersion(), null);
                }
            }
            catch (JNLPException jNLPException) {
                if (downloadProgress != null) {
                    downloadProgress.downloadFailed(jARDesc.getLocation(), jARDesc.getVersion());
                }
                throw jNLPException;
            }
            ++n;
        }
    }

    static void checkJNLPSecurity(LaunchDesc launchDesc) throws MultipleHostsException, NativeLibViolationException {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(true);
        if (jARDesc == null) {
            return;
        }
        LaunchDownload.checkJNLPSecurityHelper(launchDesc, jARDesc.getLocation().getHost(), blArray2, blArray);
        if (blArray2[0]) {
            throw new MultipleHostsException();
        }
        if (blArray[0]) {
            throw new NativeLibViolationException();
        }
    }

    private static void checkJNLPSecurityHelper(LaunchDesc launchDesc, final String string, final boolean[] blArray, final boolean[] blArray2) {
        if (launchDesc.getSecurityModel() != 0) {
            return;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                String string2 = jARDesc.getLocation().getHost();
                blArray[0] = blArray[0] || !string.equals(string2);
                blArray2[0] = blArray2[0] || jARDesc.isNativeLib();
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                LaunchDesc launchDesc;
                if (!blArray[0] && !blArray2[0] && (launchDesc = extensionDesc.getExtensionDesc()) != null && launchDesc.getSecurityModel() == 0) {
                    String string2 = extensionDesc.getLocation().getHost();
                    boolean bl = blArray[0] = blArray[0] || !string.equals(string2);
                    if (!blArray[0]) {
                        LaunchDownload.checkJNLPSecurityHelper(launchDesc, string, blArray, blArray2);
                    }
                }
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }
        });
    }

    public static long getCachedSize(LaunchDesc launchDesc) {
        long l = 0L;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return l;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        int n = 0;
        while (n < jARDescArray.length) {
            boolean bl = jARDescArray[n].isNativeLib();
            l += DownloadProtocol.getCachedSize(jARDescArray[n].getLocation(), jARDescArray[n].getVersion(), 0);
            ++n;
        }
        return l;
    }

    static String getMainClassName(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException, LaunchDescException {
        Object object;
        AppletDesc appletDesc;
        InstallerDesc installerDesc;
        String string = null;
        ApplicationDesc applicationDesc = launchDesc.getApplicationDescriptor();
        if (applicationDesc != null) {
            string = applicationDesc.getMainClass();
        }
        if ((installerDesc = launchDesc.getInstallerDescriptor()) != null) {
            string = installerDesc.getMainClass();
        }
        if ((appletDesc = launchDesc.getAppletDescriptor()) != null) {
            string = appletDesc.getAppletClass();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDesc.getLocation(), jARDesc.getVersion(), 0, true, null);
        JarFile jarFile = new JarFile(diskCacheEntry.getFile());
        if (string == null && launchDesc.getLaunchType() != 2) {
            object = jarFile.getManifest();
            String string2 = string = object != null ? ((Manifest)object).getMainAttributes().getValue("Main-Class") : null;
        }
        if (string == null) {
            throw new LaunchDescException(launchDesc, Resources.getString("launch.error.nomainclassspec"), null);
        }
        object = string.replace('.', '/') + ".class";
        if (jarFile.getEntry((String)object) == null) {
            throw new LaunchDescException(launchDesc, Resources.getString("launch.error.nomainclass", string, jARDesc.getLocation().toString()), null);
        }
        return string;
    }

    static void checkSignedLaunchDesc(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        int n = 0;
        while (n < arrayList.size()) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(n);
            LaunchDownload.checkSignedLaunchDescHelper(launchDesc2);
            ++n;
        }
    }

    static void checkSignedResources(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        int n = 0;
        while (n < arrayList.size()) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(n);
            LaunchDownload.checkSignedResourcesHelper(launchDesc2);
            ++n;
        }
    }

    private static void addExtensions(final ArrayList arrayList, LaunchDesc launchDesc) {
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitJREDesc(JREDesc jREDesc) {
                }

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        LaunchDownload.addExtensions(arrayList, extensionDesc.getExtensionDesc());
                    }
                }
            });
        }
    }

    private static void checkSignedLaunchDescHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        boolean bl = launchDesc.isApplicationDescriptor();
        byte[] byArray = null;
        try {
            byArray = LaunchDownload.getSignedJNLPFile(launchDesc, bl);
            if (byArray != null) {
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray);
                if (Globals.TraceStartup) {
                    Debug.println("Signed JNLP file: ");
                    Debug.println(launchDesc2.toString());
                }
                launchDesc.checkSigning(launchDesc2);
                byArray = null;
            }
        }
        catch (LaunchDescException launchDescException) {
            launchDescException.setIsSignedLaunchDesc();
            throw launchDescException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (JNLPException jNLPException) {
            throw jNLPException;
        }
    }

    private static void checkSignedResourcesHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        boolean bl;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        boolean bl2 = true;
        Certificate[] certificateArray = null;
        int n = 0;
        URL uRL = null;
        int n2 = 0;
        while (n2 < jARDescArray.length) {
            JARDesc jARDesc = jARDescArray[n2];
            int n3 = jARDesc.isJavaFile() ? 0 : 1;
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedVersion(jARDesc.getLocation(), jARDesc.getVersion(), n3);
            if (diskCacheEntry != null) {
                ++n;
                Certificate[] certificateArray2 = diskCacheEntry.getCertificateChain();
                if (certificateArray2 == null) {
                    bl2 = false;
                    uRL = jARDesc.getLocation();
                }
                if (certificateArray == null) {
                    certificateArray = certificateArray2;
                } else if (certificateArray2 != null && !SigningInfo.equalChains(certificateArray, certificateArray2)) {
                    throw new LaunchDescException(launchDesc, Resources.getString("launch.error.singlecertviolation"), null);
                }
            }
            ++n2;
        }
        boolean bl3 = bl = launchDesc.getSecurityModel() != 0;
        if (bl) {
            if (!bl2) {
                throw new UnsignedAccessViolationException(launchDesc, uRL, true);
            }
            if (n > 0) {
                AppPolicy appPolicy = AppPolicy.getInstance();
                appPolicy.grantUnrestrictedAccess(launchDesc, launchDesc.getCanonicalHome(), certificateArray);
            }
        }
    }

    private static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException {
        Object object;
        Object object2;
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(jARDesc.getLocation(), jARDesc.getVersion(), 0, true, null);
        JarFile jarFile = new JarFile(diskCacheEntry.getFile());
        Object object3 = jarFile.getJarEntry(SIGNED_JNLP_ENTRY);
        if (object3 == null) {
            object2 = jarFile.entries();
            while (object2.hasMoreElements() && object3 == null) {
                object = (JarEntry)object2.nextElement();
                if (!((ZipEntry)object).getName().equalsIgnoreCase(SIGNED_JNLP_ENTRY)) continue;
                object3 = object;
            }
        }
        if (object3 == null) {
            if (jarFile != null) {
                jarFile.close();
            }
            return null;
        }
        object2 = new byte[(int)((ZipEntry)object3).getSize()];
        object = new DataInputStream(jarFile.getInputStream((ZipEntry)object3));
        ((DataInputStream)object).readFully((byte[])object2, 0, (int)((ZipEntry)object3).getSize());
        ((FilterInputStream)object).close();
        jarFile.close();
        return object2;
    }

    private static class DownloadCallbackHelper
    implements DownloadProtocol.DownloadDelegate {
        DownloadProgress _downloadProgress;
        long _totalSize;
        long _downloadedSoFar;
        long _currentTotal;

        public DownloadCallbackHelper(DownloadProgress downloadProgress, long l) {
            this._downloadProgress = downloadProgress;
            this._totalSize = l;
            this._downloadedSoFar = 0L;
        }

        public void downloading(URL uRL, String string, int n, int n2, boolean bl) {
            int n3 = -1;
            if (this._totalSize != -1L) {
                double d = bl ? 0.8 : 0.9;
                double d2 = (double)this._downloadedSoFar + d * (double)n;
                n3 = this.getPercent(d2);
                this._currentTotal = n2;
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.progress(uRL, string, this._downloadedSoFar + (long)n, this._totalSize, n3);
            }
        }

        public void patching(URL uRL, String string, int n) {
            int n2 = -1;
            if (this._totalSize != -1L) {
                double d = (double)this._downloadedSoFar + (double)this._currentTotal * (0.8 + (double)n / 1000.0);
                n2 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.patching(uRL, string, n, n2);
            }
        }

        public void validating(URL uRL, int n, int n2) {
            int n3 = -1;
            if (this._totalSize != -1L && n2 != 0) {
                double d = (double)this._downloadedSoFar + 0.9 * (double)this._currentTotal + 0.1 * (double)this._currentTotal * ((double)n / (double)n2);
                n3 = this.getPercent(d);
            }
            if (this._downloadProgress != null) {
                this._downloadProgress.validating(uRL, null, n, n2, n3);
            }
            if (n == n2) {
                this._downloadedSoFar += this._currentTotal;
            }
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._downloadProgress != null) {
                this._downloadProgress.downloadFailed(uRL, string);
            }
        }

        private int getPercent(double d) {
            if (d > (double)this._totalSize) {
                this._totalSize = -1L;
                return -1;
            }
            double d2 = d * 100.0 / (double)this._totalSize;
            return (int)(d2 + 0.5);
        }
    }

    public static interface DownloadProgress {
        public void jreDownload(String var1, URL var2);

        public void extensionDownload(String var1, int var2);

        public void progress(URL var1, String var2, long var3, long var5, int var7);

        public void validating(URL var1, String var2, long var3, long var5, int var7);

        public void patching(URL var1, String var2, int var3, int var4);

        public void downloadFailed(URL var1, String var2);
    }
}

