/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class IcoEncoder {
    private OutputStream outputS;
    private static byte ICON_SIZE = (byte)32;
    private static byte NUM_COLORS = 0;
    private static int BYTE_SIZE = 8;
    private Image awtImage;

    public IcoEncoder(OutputStream outputStream, Image image) {
        this.outputS = outputStream;
        this.awtImage = image;
    }

    private void createBitmap() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 32;
        int n6 = 32;
        int n7 = 0;
        int[] nArray = new int[n5 * n6];
        byte[] byArray = new byte[n5 * n6 * 3];
        byte[] byArray2 = new byte[n5 * n6 * 3];
        byte[] byArray3 = new byte[n5 * 4];
        byte[] byArray4 = new byte[n5 * 4];
        PixelGrabber pixelGrabber = new PixelGrabber(this.awtImage.getScaledInstance(32, 32, 1), 0, 0, n5, n6, nArray, 0, n5);
        try {
            if (pixelGrabber.grabPixels()) {
                if (Globals.TraceIcoCreation) {
                    Debug.println("pixels grabbed successfully");
                }
            } else if (Globals.TraceIcoCreation) {
                Debug.println("cannot grab pixels!");
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n5 * n6) {
            n4 = nArray[n12] >> 24 & 0xFF;
            n3 = nArray[n12] >> 16 & 0xFF;
            n2 = nArray[n12] >> 8 & 0xFF;
            n = nArray[n12] & 0xFF;
            if (Globals.TraceIcoCreation) {
                if (n4 != 0) {
                    Debug.print(" 1");
                } else {
                    Debug.print(" " + n4);
                }
                if (++n11 == 32) {
                    Debug.println(" ");
                    n11 = 0;
                }
            }
            if (n4 == 0) {
                n8 = (byte)(n8 | 128 >> n10);
            }
            if (++n10 == 8) {
                byArray3[n9++] = n8;
                n8 = 0;
                n10 = 0;
            }
            byArray[n7++] = (byte)n;
            byArray[n7++] = (byte)n2;
            byArray[n7++] = (byte)n3;
            ++n12;
        }
        if (Globals.TraceIcoCreation) {
            n4 = 0;
            Debug.println("andPxiels bitmap");
            n3 = 0;
            while (n3 < 128) {
                n2 = 0;
                while (n2 < 8) {
                    if ((byArray3[n3] & 128 >> n2) != 0) {
                        Debug.print(" 1");
                    } else {
                        Debug.print(" 0");
                    }
                    n2 = (byte)(n2 + 1);
                }
                if (++n4 == 4) {
                    Debug.println(" ");
                    n4 = 0;
                }
                ++n3;
            }
        }
        n2 = 0;
        while (n2 < n6) {
            n3 = n2 * n5 * 3;
            n4 = (n6 - n2 - 1) * n5 * 3;
            n = 0;
            while (n < n5 * 3) {
                byArray2[n3 + n] = byArray[n4 + n];
                ++n;
            }
            n3 = n2 * (n5 / 8);
            n4 = (n6 - n2 - 1) * (n5 / 8);
            int n13 = 0;
            while (n13 < n5 / 8) {
                byArray4[n3 + n13] = byArray3[n4 + n13];
                ++n13;
            }
            ++n2;
        }
        this.outputS.write(byArray2);
        this.outputS.write(byArray4);
    }

    public void encode() {
        this.writeIcoHeader();
        this.writeIconDirEntry();
        try {
            this.writeInfoHeader(40, 24);
            this.createBitmap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.writeDWord(n);
        this.writeDWord(32);
        this.writeDWord(64);
        this.writeWord(1);
        this.writeWord(n2);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
        this.writeDWord(0);
    }

    private void writeIconDirEntry() {
        try {
            int n = ICON_SIZE;
            this.outputS.write(n);
            this.outputS.write(n);
            n = NUM_COLORS;
            this.outputS.write(n);
            n = 0;
            this.outputS.write(n);
            n = 1;
            this.writeWord(n);
            n = 24;
            this.writeWord(n);
            int n2 = 3240;
            this.writeDWord(n2);
            int n3 = 22;
            this.writeDWord(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeIcoHeader() {
        try {
            int n = 0;
            this.writeWord(n);
            n = 1;
            this.writeWord(n);
            this.writeWord(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeWord(int n) throws IOException {
        this.outputS.write(n & 0xFF);
        this.outputS.write((n & 0xFF00) >> 8);
    }

    public void writeDWord(int n) throws IOException {
        this.outputS.write(n & 0xFF);
        this.outputS.write((n & 0xFF00) >> 8);
        this.outputS.write((n & 0xFF0000) >> 16);
        this.outputS.write((n & 0xFF000000) >> 24);
    }
}

