/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.resource;

import com.ibm.etools.environment.common.Choice;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.StatusMonitor;
import com.ibm.etools.environment.resource.FileResourceOutputStream;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.webservice.context.ResourceContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public final class ResourceUtils {
    private static final String pluginId_ = "com.ibm.etools.environment.core";
    private static ResourceBundle resource_ = ResourceBundle.getBundle("com.ibm.etools.environment.environment");
    private static IWorkspace workspace_ = null;
    private static IWorkspaceRoot root_ = null;

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public static Choice[] getThreeStateFileOptions() {
        Vector<Choice> choices = new Vector<Choice>();
        choices.add(new Choice(2, 'Y', ResourceUtils.getMessage("YES_LABEL")));
        choices.add(new Choice(4, 'A', ResourceUtils.getMessage("YES_TO_ALL_LABEL")));
        choices.add(new Choice(1, 'C', ResourceUtils.getMessage("CANCEL_LABEL")));
        return choices.toArray(new Choice[choices.size()]);
    }

    public static IResource findResource(String absolutePathname) {
        if (absolutePathname == null) {
            return null;
        }
        return ResourceUtils.findResource((IPath)new Path(absolutePathname));
    }

    public static IResource findResource(IPath absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        return ResourceUtils.getWorkspaceRoot().findMember(absolutePath);
    }

    public static IFile createFile(ResourceContext resourceContext, IPath absolutePath, InputStream inputStream, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException, ResourceException {
        if (!absolutePath.isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_PATH_NOT_ABSOLUTE", new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 1) {
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_PATH_EMPTY", new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 2) {
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_PATH_NOT_FOLDER", new Object[]{absolutePath.toString()}), null));
        }
        IContainer parent = ResourceUtils.makeFolderPath(resourceContext, absolutePath.removeLastSegments(1), progressMonitor, statusMonitor);
        String fileName = absolutePath.lastSegment();
        return ResourceUtils.makeFile(resourceContext, parent, fileName, inputStream, progressMonitor, statusMonitor);
    }

    public static IFile createFile(ResourceContext resourceContext, IProject project, IPath relativePath, InputStream inputStream, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException, ResourceException {
        IPath absolutePath = project.getFullPath().append(relativePath);
        return ResourceUtils.createFile(resourceContext, absolutePath, inputStream, progressMonitor, statusMonitor);
    }

    public static OutputStream newFileOutputStream(ResourceContext context, IPath file, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException {
        return new FileResourceOutputStream(context, file, progressMonitor, statusMonitor);
    }

    private static IContainer makeFolderPath(ResourceContext resourceContext, IPath absolutePath, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException {
        if (absolutePath.segmentCount() <= 1) {
            return ResourceUtils.getWorkspaceRoot().getProject(absolutePath.segment(0));
        }
        IContainer parent = ResourceUtils.makeFolderPath(resourceContext, absolutePath.removeLastSegments(1), progressMonitor, statusMonitor);
        String folderName = absolutePath.lastSegment();
        return ResourceUtils.makeFolder(resourceContext, parent, folderName, progressMonitor, statusMonitor);
    }

    private static IFolder makeFolder(ResourceContext resourceContext, IContainer parent, String folderName, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException {
        IResource child = parent.findMember(folderName);
        if (child == null) {
            Choice result;
            if (!resourceContext.isCreateFoldersEnabled() && (result = statusMonitor.reportStatus(new SimpleStatus(pluginId_, ResourceUtils.getMessage("MSG_ERROR_FOLDER_CREATION_DISABLED", new Object[]{parent.getFullPath().toString(), folderName}), 2, null), ResourceUtils.getThreeStateFileOptions())) != null) {
                if (result.getId() == 1) {
                    return null;
                }
                if (result.getId() == 4) {
                    resourceContext.setCreateFoldersEnabled(true);
                }
            }
            IFolder folder = parent.getFolder((IPath)new Path(folderName));
            folder.create(true, true, null);
            return folder;
        }
        if (child.getType() == 2) {
            return (IFolder)child;
        }
        throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_RESOURCE_NOT_FOLDER", new Object[]{parent.getFullPath().append(folderName).toString()}), null));
    }

    private static IFile makeFile(ResourceContext resourceContext, IContainer parent, String fileName, InputStream inputStream, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException, ResourceException {
        IResource child = parent.findMember(fileName);
        if (child != null) {
            if (child.getType() == 1) {
                Choice result;
                if (!resourceContext.isOverwriteFilesEnabled()) {
                    result = statusMonitor.reportStatus(new SimpleStatus(pluginId_, ResourceUtils.getMessage("MSG_WARN_FILE_OVERWRITE_DISABLED", new Object[]{parent.getFullPath().toString(), fileName}), 2, null), ResourceUtils.getThreeStateFileOptions());
                    if (result == null || result.getId() == 1) {
                        throw new ResourceException(new SimpleStatus(pluginId_, "ABORT", 8), null);
                    }
                    if (result.getId() == 4) {
                        resourceContext.setOverwriteFilesEnabled(true);
                    }
                }
                if (child.isReadOnly()) {
                    if (!resourceContext.isCheckoutFilesEnabled() && (result = statusMonitor.reportStatus(new SimpleStatus(pluginId_, ResourceUtils.getMessage("MSG_ERROR_FILE_CHECKOUT_DISABLED", new Object[]{parent.getFullPath().toString(), fileName}), 2, null), ResourceUtils.getThreeStateFileOptions())) != null) {
                        if (result.getId() == 1) {
                            return null;
                        }
                        if (result.getId() == 4) {
                            resourceContext.setCheckoutFilesEnabled(true);
                        }
                    }
                    IFile[] files = new IFile[]{(IFile)child};
                    IStatus status = ResourceUtils.getWorkspace().validateEdit(files, null);
                    SimpleStatus ss = new SimpleStatus(status.getPlugin(), status.getMessage(), status.getSeverity(), status.getException());
                    if (!statusMonitor.reportStatus(ss)) {
                        return null;
                    }
                }
                IFile file = parent.getFile((IPath)new Path(fileName));
                file.setContents(inputStream, true, true, null);
                return file;
            }
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_RESOURCE_NOT_FILE", new Object[]{parent.getFullPath().append(fileName)}), null));
        }
        IFile file = parent.getFile((IPath)new Path(fileName));
        file.create(inputStream, true, null);
        return file;
    }

    private static final String getMessage(String messageId, String parm1) {
        return ResourceUtils.getMessage(messageId, new String[]{parm1});
    }

    private static final String getMessage(String messageId, Object[] parms) {
        String message = ResourceUtils.getMessage(messageId);
        return MessageFormat.format(message, parms);
    }

    private static final String getMessage(String key) {
        return resource_.getString(key);
    }
}

