/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.console;

import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.resource.AbstractResourceManager;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.URLFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;

public class ConsoleResourceManager
extends AbstractResourceManager {
    private ResourceBundle resource = ResourceBundle.getBundle("com.ibm.etools.environment.environment");

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createFile(InputStream source, URL url) throws ResourceException {
        OutputStream destination = null;
        try {
            try {
                byte[] buffer = new byte[1024];
                int n = source.read(buffer);
                destination = this.getOutputStream(url);
                while (n >= 0) {
                    destination.write(buffer, 0, n);
                    n = source.read(buffer);
                }
            }
            catch (IOException e) {
                throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_CREATE_FILE_IOEXCEPTION"), 4, e), url);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (destination != null) {
                    destination.close();
                }
                source.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_CREATE_FILE_IOEXCEPTION"), 4, e), url);
            }
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IOException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_CREATE_FILE_IOEXCEPTION"), 4, e), url);
        }
        if (destination != null) {
            destination.close();
        }
        source.close();
    }

    public void createFolders(URL url) throws ResourceException {
        try {
            new File(url.getFile()).mkdirs();
        }
        catch (SecurityException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_CREATE_FOLDERS_SECURITY_EXCEPTION"), 4, e), url);
        }
    }

    public void rename(URL currentURL, URL newURL) throws ResourceException {
        File newFile = new File(newURL.getFile());
        new File(currentURL.getFile()).renameTo(newFile);
    }

    public void delete(URL url) throws ResourceException {
        new File(url.getFile()).delete();
    }

    public void touchFile(URL url) throws ResourceException {
        try {
            new File(url.getFile()).createNewFile();
        }
        catch (IOException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_TOUCHFILE_IOEXCEPTION"), 4, e), url);
        }
    }

    public void copy(URL currentURL, URL newURL) throws ResourceException {
        if (this.kind(newURL) == 2) {
            String name = new File(currentURL.getFile()).getName();
            newURL = this.appends(newURL, name);
        }
        this.createFile(this.getInputStream(currentURL), newURL);
    }

    public boolean exists(URL url) throws ResourceException {
        return new File(url.getFile()).exists();
    }

    public byte kind(URL url) throws ResourceException {
        File file = new File(url.getFile());
        if (file.isFile()) {
            return 1;
        }
        if (file.isDirectory()) {
            return 2;
        }
        return 0;
    }

    public boolean isReadonly(URL url) throws ResourceException {
        return !new File(url.getFile()).canWrite();
    }

    public InputStream getInputStream(URL url) throws ResourceException {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_INPUTSTREAM_IOEXCEPTION"), 4, e), url);
        }
    }

    public OutputStream getOutputStream(URL url) throws ResourceException {
        try {
            File file = new File(url.getPath());
            File parent = new File(file.getParent());
            parent.mkdirs();
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_OUTPUTSTREAM_IOEXCEPTION"), 4, e), url);
        }
    }

    public PrintWriter getPrintWriter(URL url) throws ResourceException {
        try {
            File file = new File(url.getFile());
            File parent = new File(file.getParent());
            parent.mkdirs();
            return new PrintWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_PRINTWRITER_IOEXCEPTION"), 4, e), url);
        }
    }

    public char getSeparatorChar() {
        return File.separatorChar;
    }

    public URL[] getChildren(URL url, URLFilter urlFilter) throws ResourceException {
        File file = new File(url.getFile());
        try {
            String[] fileList = file.list();
            ArrayList<URL> urlList = new ArrayList<URL>();
            if (fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    File f = new File(file, fileList[i]);
                    URL newURL = f.toURL();
                    if (urlFilter == null) {
                        urlList.add(newURL);
                    } else if (urlFilter.accept(newURL)) {
                        urlList.add(newURL);
                    }
                    ++i;
                }
            }
            return urlList.toArray(new URL[urlList.size()]);
        }
        catch (SecurityException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_GETCHILDREN_SECURITY_EXCEPTION"), 4, e), url);
        }
        catch (MalformedURLException e) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_GETCHILDREN_MALFORMEDURLEXCEPTION"), 4, e), url);
        }
    }

    public Iterator getChildrenIterator(URL url, URLFilter urlFilter) throws ResourceException {
        return null;
    }

    private String getMessage(String messageId, String parm1) {
        String message = this.resource.getString(messageId);
        return MessageFormat.format(message, parm1);
    }

    public String getMessage(String key) {
        return this.resource.getString(key);
    }
}

