/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class StringUtils {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final byte STATE_WS = 0;
    private static final byte STATE_NWS = 1;
    private static final char[] URI_SYMBOLS = new char[]{'-', '~', '#', '/', '.'};
    private static final char UNDERSCORE = '_';

    private StringUtils() {
    }

    public static String[] splitter(String text, int max_length) {
        Vector<String> return_text = new Vector<String>(20);
        int index = 0;
        while (index < text.length()) {
            String str = text.substring(index, Math.min(max_length + index, text.length()));
            int space_index = str.lastIndexOf(" ");
            if (index + str.length() < text.length() && text.charAt(index + str.length() - 1) != ' ' && text.charAt(index + str.length()) != ' ' && space_index != -1) {
                return_text.addElement(str.substring(0, space_index));
                index += space_index + 1;
                continue;
            }
            return_text.addElement(str.trim());
            index += str.length();
        }
        String[] return_str = new String[return_text.size()];
        index = 0;
        while (index < return_text.size()) {
            return_str[index] = (String)return_text.elementAt(index);
            ++index;
        }
        return return_str;
    }

    public static String repeat(char the_char, int count) {
        StringBuffer buf = new StringBuffer(count);
        int index = 0;
        while (index < count) {
            buf.append(the_char);
            ++index;
        }
        return buf.toString();
    }

    public static String flattenArguments(String[] arguments) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < arguments.length) {
            if (i > 0) {
                buf.append(' ');
            }
            boolean whitespace = false;
            char[] chars = arguments[i].toCharArray();
            int j = 0;
            while (!whitespace && j < chars.length) {
                if (Character.isWhitespace(chars[j])) {
                    whitespace = true;
                }
                ++j;
            }
            if (whitespace) {
                buf.append('\"');
            }
            j = 0;
            while (j < chars.length) {
                if (chars[j] == '\"') {
                    buf.append('\\');
                }
                buf.append(chars[j]);
                ++j;
            }
            if (whitespace) {
                buf.append('\"');
            }
            ++i;
        }
        return buf.toString();
    }

    public static Enumeration parseFilenamesFromStream(InputStream input) throws IOException {
        Vector<String> filenames = new Vector<String>(64, 64);
        StringBuffer buffer = null;
        int state = 0;
        int ic = input.read();
        while (ic >= 0) {
            char c = (char)ic;
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) break;
                    buffer = new StringBuffer();
                    buffer.append(c);
                    state = 1;
                    break;
                }
                case 1: {
                    if (!Character.isWhitespace(c)) {
                        buffer.append(c);
                        break;
                    }
                    String filename = buffer.toString();
                    filenames.add(filename);
                    buffer = null;
                    state = 0;
                    break;
                }
            }
            ic = input.read();
        }
        return filenames.elements();
    }

    public static boolean isPrimitiveType(String typeName) {
        return typeName.equalsIgnoreCase("boolean") || typeName.equalsIgnoreCase("byte") || typeName.equalsIgnoreCase("double") || typeName.equalsIgnoreCase("float") || typeName.equalsIgnoreCase("int") || typeName.equalsIgnoreCase("long") || typeName.equalsIgnoreCase("short") || typeName.equalsIgnoreCase("char");
    }

    public static String URI2ClassName(String uri) {
        String className = uri;
        int i = 0;
        while (i < URI_SYMBOLS.length) {
            className = className.replace(URI_SYMBOLS[i], '_');
            ++i;
        }
        return className;
    }

    private static boolean isDelimiter(char character) {
        return "-.:_\u00b7\u0387\u06dd\u06de".indexOf(character) != -1;
    }
}

