/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.command;

import com.ibm.etools.environment.command.AbstractCommand;
import com.ibm.etools.environment.command.Command;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.Status;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class MultiCommand
extends AbstractCommand {
    protected String name = null;
    protected String description = null;
    private List commands_ = new LinkedList();
    private Command[] commandsArray_ = null;

    public MultiCommand() {
    }

    public MultiCommand(String name, String description) {
        super(name, description);
    }

    public MultiCommand(String name, String description, Command[] commands) {
        super(name, description);
        this.commands_.addAll(Arrays.asList(commands));
    }

    public void add(Command command) {
        this.commandsArray_ = null;
        this.commands_.add(command);
    }

    public String getName() {
        return this.name != null ? this.name : (this.commands_.size() > 0 ? ((Command)this.commands_.get(0)).getName() : null);
    }

    public String getDescription() {
        return this.description != null ? this.description : (this.commands_.size() > 0 ? ((Command)this.commands_.get(0)).getDescription() : null);
    }

    public Status execute(Environment environment) {
        Status status = null;
        Command[] commands = this.commandsArray();
        int i = 0;
        while (i < commands.length) {
            status = commands[i].execute(environment);
            if (status != null && status.matches(4)) {
                --i;
                while (i >= 0) {
                    commands[i].undo(environment);
                    --i;
                }
                return status;
            }
            ++i;
        }
        return status;
    }

    public Status undo(Environment environment) {
        Status status = null;
        ListIterator i = this.commands_.listIterator();
        while (i.hasPrevious()) {
            status = ((Command)i.previous()).undo(environment);
        }
        return status;
    }

    public boolean isUndoable() {
        ListIterator i = this.commands_.listIterator();
        while (i.hasPrevious()) {
            if (((Command)i.previous()).isUndoable()) continue;
            return false;
        }
        return true;
    }

    public Status redo(Environment environment) {
        Status status = null;
        Command[] commands = this.commandsArray();
        int i = 0;
        while (i < commands.length) {
            status = commands[i].redo(environment);
            if (status != null && status.matches(4)) {
                --i;
                while (i >= 0) {
                    commands[i].undo(environment);
                    --i;
                }
                return status;
            }
            ++i;
        }
        return status;
    }

    private Command[] commandsArray() {
        if (this.commandsArray_ == null) {
            this.commandsArray_ = this.commands_.toArray(new Command[0]);
        }
        return this.commandsArray_;
    }
}

