/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.stat;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLSessionContext;

public class SSLStatsModule {
    protected static final TraceComponent tc = Tr.register((Class)SSLStatsModule.class, (String)"SSLChannelStats", (String)"com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    protected static long scanInterval = 30000L;
    private static final int MAX_SKIPS = 10;
    private static UpdateTimer timer = null;
    private long cacheIdCounter;
    private int cacheIdSkips = 0;
    private String name;
    private SSLSessionContext sslcontext = null;

    public SSLStatsModule(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SSL channel [" + string + "] creating module: " + this));
        }
        if (null == timer) {
            this.createTimer();
        }
        this.name = string;
        this.cacheIdCounter = 0L;
    }

    private synchronized void createTimer() {
        if (null == timer) {
            timer = new UpdateTimer();
        }
    }

    public void setContext(SSLSessionContext sSLSessionContext) {
        this.sslcontext = sSLSessionContext;
    }

    public void start() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Starting module: " + this));
        }
        timer.addModule(this);
    }

    public void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Stopping module: " + this));
        }
        timer.removeModule(this);
    }

    protected void countCacheIds() {
        boolean bl;
        if (null == this.sslcontext) {
            this.cacheIdCounter = 0L;
            return;
        }
        long l = 0L;
        Enumeration<byte[]> enumeration = this.sslcontext.getIds();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++l;
        }
        boolean bl2 = bl = l != this.cacheIdCounter;
        if (bl) {
            this.cacheIdCounter = l;
            this.cacheIdSkips = 0;
        } else if (10 <= ++this.cacheIdSkips) {
            bl = true;
            this.cacheIdSkips = 0;
        }
        if (bl && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Channel [" + this.name + "] has " + this.getCacheIdCount() + " ids."));
        }
    }

    public long getCacheIdCount() {
        return this.cacheIdCounter;
    }

    private class UpdateTimer
    implements AlarmListener {
        private Alarm alarmTask;
        private List moduleList;

        protected UpdateTimer() {
            block4: {
                this.alarmTask = null;
                this.moduleList = new ArrayList();
                String string = System.getProperty("SSL_STATS_INTERVAL");
                if (null != string) {
                    try {
                        scanInterval = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug((TraceComponent)tc, (String)("SSL_STATS_INTERVAL value of [" + string + "] is unusable"));
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created UpdateTimer: " + this));
                Tr.debug((TraceComponent)tc, (String)("Stats scan interval is " + scanInterval));
            }
        }

        private void start() {
            if (null == this.alarmTask) {
                this.alarmTask = AlarmManager.createDeferrable((long)scanInterval, (AlarmListener)this, null);
            }
        }

        private void stop() {
            if (null != this.alarmTask) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Trying to stop alarm task: " + this.alarmTask));
                }
                this.alarmTask.cancel();
                this.alarmTask = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addModule(SSLStatsModule sSLStatsModule) {
            List list = this.moduleList;
            synchronized (list) {
                this.moduleList.add(sSLStatsModule);
                if (1 == this.moduleList.size()) {
                    this.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeModule(SSLStatsModule sSLStatsModule) {
            List list = this.moduleList;
            synchronized (list) {
                this.moduleList.remove(sSLStatsModule);
                SSLStatsModule.this.setContext(null);
                if (0 == this.moduleList.size()) {
                    this.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            List list = this.moduleList;
            synchronized (list) {
                this.alarmTask = null;
                if (0 < this.moduleList.size()) {
                    Iterator iterator = this.moduleList.iterator();
                    while (iterator.hasNext()) {
                        SSLStatsModule sSLStatsModule = (SSLStatsModule)iterator.next();
                        sSLStatsModule.countCacheIds();
                    }
                    this.start();
                }
            }
        }
    }
}

