/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

class X509KeyManagerWrapper
implements X509KeyManager {
    private static final TraceComponent TC = Tr.register((Class)X509KeyManagerWrapper.class, (String)"ObjectGrid", null);
    private String ivAlias = null;
    private X509KeyManager ivKm = null;

    public X509KeyManagerWrapper(X509KeyManager x509KeyManager, String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)"X509KeyManagerWrapper", (Object)new Object[]{x509KeyManager, string});
        }
        this.ivKm = x509KeyManager;
        this.ivAlias = string;
        if (TC.isEntryEnabled()) {
            Tr.exit((TraceComponent)TC, (String)"X509KeyManagerWrapper", (Object)this);
        }
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.ivKm.getClientAliases(string, principalArray);
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseClientAlias(stringArray[0], principalArray);
    }

    public String chooseClientAlias(String string, Principal[] principalArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)"chooseClientAlias", (Object)new Object[]{string, principalArray, this});
        }
        if (this.ivAlias != null && !this.ivAlias.equals("")) {
            String[] stringArray = this.ivKm.getClientAliases(string, principalArray);
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.ivAlias.equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    if (TC.isEntryEnabled()) {
                        Tr.exit((TraceComponent)TC, (String)"chooseClientAlias", (Object)this.ivAlias);
                    }
                    return this.ivAlias.toLowerCase();
                }
            }
            if (TC.isEntryEnabled()) {
                Tr.exit((TraceComponent)TC, (String)"chooseClientAlias", (Object)("cannot found the alias, return default alias :" + this.ivAlias));
            }
            return this.ivAlias;
        }
        String string2 = this.ivKm.chooseClientAlias(new String[]{string}, principalArray, null);
        if (TC.isEntryEnabled()) {
            Tr.exit((TraceComponent)TC, (String)"chooseClientAlias", (Object)string2);
        }
        return string2 == null ? null : string2.toLowerCase();
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)"getServerAliases", (Object)new Object[]{string, principalArray, this});
        }
        return this.ivKm.getServerAliases(string, principalArray);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseServerAlias(string, principalArray);
    }

    public String chooseServerAlias(String string, Principal[] principalArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)"chooseServerAlias", (Object)new Object[]{string, principalArray, this});
        }
        if (this.ivAlias != null && !this.ivAlias.equals("")) {
            String[] stringArray = this.ivKm.getServerAliases(string, principalArray);
            if (stringArray != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.ivAlias.equalsIgnoreCase(stringArray[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    if (TC.isEntryEnabled()) {
                        Tr.exit((TraceComponent)TC, (String)"chooseServerAlias", (Object)this.ivAlias);
                    }
                    return this.ivAlias.toLowerCase();
                }
            }
            if (TC.isEntryEnabled()) {
                Tr.exit((TraceComponent)TC, (String)"chooseServerAlias", (Object)("cannot found the alias, return default alias :" + this.ivAlias));
            }
            return this.ivAlias;
        }
        String string2 = this.ivKm.chooseServerAlias(string, principalArray, null);
        return string2.toLowerCase();
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)"getCertificateChain", (Object)new Object[]{string, this});
        }
        return this.ivKm.getCertificateChain(string);
    }

    public PrivateKey getPrivateKey(String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)"getPrivateKey", (Object)new Object[]{string, this});
        }
        return this.ivKm.getPrivateKey(string);
    }
}

