/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLOutboundChannel;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ssl.channel.impl.SSLChannelFactory;
import com.ibm.ws.ssl.channel.impl.SSLOutboundChannelDefinition;
import com.ibm.ws.ssl.channel.impl.WSSSLChannel;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class WSSSLChannelFactory
extends SSLChannelFactory
implements WSChannelFactory {
    private static final TraceComponent tc = Tr.register((Class)WSSSLChannelFactory.class, (String)"SSLChannel", (String)"com.ibm.ws.ssl.channel.resources.sslchannelmessages");

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        return new WSSSLChannel(channelData);
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return new SSLOutboundChannelDefinition(map);
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        return null;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createChannelConfigurationMap", (Object)transportChannel);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        EList eList = transportChannel.getProperties();
        if (transportChannel instanceof SSLInboundChannel || transportChannel instanceof SSLOutboundChannel) {
            try {
                object2 = transportChannel.eClass().getEStructuralFeature("sslConfigAlias");
                object = transportChannel.eGet((EStructuralFeature)object2);
                if (object != null) {
                    hashMap.put("alias", object);
                }
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"unable.to.read.config", (Object)exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SSL Property alias=" + hashMap.get("alias")));
        }
        if (null != eList) {
            object2 = eList.iterator();
            while (object2.hasNext()) {
                object = (Property)object2.next();
                hashMap.put(object.getName(), object.getValue());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Custom SSL Property " + object.getName() + " = " + object.getValue()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createChannelConfigurationMap", hashMap);
        }
        return hashMap;
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }
}

