/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.jsse2.SSLContext;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeIOCallback;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import javax.net.ssl.SSLException;

public class SSLUtils {
    protected static final TraceComponent tc = Tr.register((Class)SSLUtils.class, (String)"SSLChannel", (String)"com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.imp.SSLUtils";
    private static WsByteBufferPoolManager byteBufferManager = WsByteBufferPoolManagerImpl.getRef();

    public static void shutDownSSLEngine(ProtoSSLEngine protoSSLEngine, WsByteBuffer wsByteBuffer, TCPWriteRequestContext tCPWriteRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutDownSSLEngine");
        }
        if (!protoSSLEngine.isInboundDone()) {
            protoSSLEngine.closeInbound();
            SSLUtils.flushCloseDown(protoSSLEngine, wsByteBuffer, tCPWriteRequestContext);
        }
        if (!protoSSLEngine.isOutboundDone()) {
            protoSSLEngine.closeOutbound();
            SSLUtils.flushCloseDown(protoSSLEngine, wsByteBuffer, tCPWriteRequestContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutDownSSLEngine");
        }
    }

    private static void flushCloseDown(ProtoSSLEngine protoSSLEngine, WsByteBuffer wsByteBuffer, TCPWriteRequestContext tCPWriteRequestContext) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("flushCloseDown, engine=" + protoSSLEngine.hashCode()));
            }
            ProtoSSLEngineResult protoSSLEngineResult = null;
            ProtoSSLEngineResult.Status status = null;
            wsByteBuffer.clear();
            try {
                do {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("before wrap: " + SSLUtils.getBufferTraceInfo(wsByteBuffer)));
                    }
                    protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer.getWrappedByteBuffer());
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("after wrap: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tresult=" + protoSSLEngineResult));
                    }
                    tCPWriteRequestContext.setBuffer(wsByteBuffer);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("write bytes: " + wsByteBuffer.remaining()));
                    }
                    tCPWriteRequestContext.write(wsByteBuffer.remaining(), 0);
                } while ((status = protoSSLEngineResult.getStatus()) != ProtoSSLEngineResult.Status.CLOSED);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)("Exception caught closing down, " + exception));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushCloseDown");
        }
    }

    public static ByteBuffer[] getWrappedByteBuffers(WsByteBuffer[] wsByteBufferArray) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[wsByteBufferArray.length];
        boolean bl = false;
        int n = 0;
        for (n = 0; n < wsByteBufferArray.length; ++n) {
            if (wsByteBufferArray[n] == null) {
                bl = true;
                break;
            }
            byteBufferArray[n] = wsByteBufferArray[n].getWrappedByteBuffer();
        }
        if (bl) {
            ByteBuffer[] byteBufferArray2 = byteBufferArray;
            byteBufferArray = new ByteBuffer[n];
            for (int i = 0; i < n; ++i) {
                byteBufferArray[i] = byteBufferArray2[i];
            }
        }
        return byteBufferArray;
    }

    public static void limitToCapacity(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].limit(wsByteBufferArray[i].capacity());
            }
        }
    }

    public static void positionToLimit(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].position(wsByteBufferArray[i].limit());
            }
        }
    }

    public static void flipBuffersToMark(WsByteBuffer[] wsByteBufferArray, int n, int n2) {
        WsByteBuffer wsByteBuffer = null;
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                wsByteBuffer = wsByteBufferArray[i];
                if (wsByteBuffer == null) continue;
                if (i == n2 && n != 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("mark is " + n));
                    }
                    wsByteBuffer.limit(wsByteBuffer.position());
                    wsByteBuffer.position(n);
                    continue;
                }
                wsByteBuffer.flip();
            }
        }
    }

    public static void copyBuffer(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2) {
        SSLUtils.copyBuffer(wsByteBuffer, wsByteBuffer2, wsByteBuffer.remaining());
    }

    public static void copyBuffer(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"copyBuffer 1");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("length: " + n + "\n" + "src: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\n" + "dst: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2)));
        }
        if (wsByteBuffer2.remaining() < n || wsByteBuffer.remaining() < n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not enough space to copy buffers.  Length=" + n + "\r\nsrc=" + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\ndst=" + SSLUtils.getBufferTraceInfo(wsByteBuffer2)));
            }
            RuntimeException runtimeException = new RuntimeException("Attempt to copy source buffer to inadequate destination buffer");
            FFDCFilter.processException((Throwable)runtimeException, (String)CLASS_NAME, (String)"762", (Object)wsByteBuffer);
            throw runtimeException;
        }
        if (wsByteBuffer.hasArray()) {
            int n2 = wsByteBuffer.position() + n;
            wsByteBuffer2.put(wsByteBuffer.array(), wsByteBuffer.arrayOffset() + wsByteBuffer.position(), n);
            wsByteBuffer.position(n2);
        } else {
            byte[] byArray = new byte[n];
            wsByteBuffer.get(byArray, 0, n);
            wsByteBuffer2.put(byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyBuffer 1");
        }
    }

    public static WsByteBuffer allocateByteBuffer(int n, boolean bl) {
        WsByteBuffer wsByteBuffer = null;
        wsByteBuffer = bl ? byteBufferManager.allocateDirect(n) : byteBufferManager.allocate(n);
        wsByteBuffer.limit(wsByteBuffer.capacity());
        return wsByteBuffer;
    }

    public static String getBufferTraceInfo(WsByteBuffer[] wsByteBufferArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                stringBuffer.append("\r\n\tBuffer [");
                stringBuffer.append(i);
                stringBuffer.append("]: ");
                stringBuffer.append(SSLUtils.getBufferTraceInfo(wsByteBufferArray[i]));
            }
        } else {
            stringBuffer.append("Null buffer array");
        }
        return stringBuffer.toString();
    }

    public static String getBufferTraceInfo(WsByteBuffer wsByteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        if (wsByteBuffer != null) {
            stringBuffer.append("hc=");
            stringBuffer.append(wsByteBuffer.hashCode());
            stringBuffer.append(" pos=");
            stringBuffer.append(wsByteBuffer.position());
            stringBuffer.append(" lim=");
            stringBuffer.append(wsByteBuffer.limit());
            stringBuffer.append(" cap=");
            stringBuffer.append(wsByteBuffer.capacity());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public static String showBufferContents(WsByteBuffer[] wsByteBufferArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                stringBuffer.append("Buffer [");
                stringBuffer.append(i);
                stringBuffer.append("]: ");
                stringBuffer.append(WsByteBufferUtils.asString(wsByteBufferArray[i]));
                stringBuffer.append("\r\n");
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public static WsByteBuffer[] allocateByteBuffers(int n, long l, boolean bl, boolean bl2) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"allocateByteBuffers");
        }
        WsByteBuffer wsByteBuffer = SSLUtils.allocateByteBuffer(n, bl);
        if (bl2) {
            wsByteBuffer.limit(n);
        }
        int n2 = wsByteBuffer.limit();
        int n3 = (int)(l / (long)n2);
        if (l % (long)n2 > 0L) {
            ++n3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("allocate: requestSize=" + n + ", actualSize=" + n2 + ", totSize=" + l + ", numBufs=" + n3));
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n3];
        wsByteBufferArray[0] = wsByteBuffer;
        for (int i = 1; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i] = SSLUtils.allocateByteBuffer(n, bl);
            if (!bl2) continue;
            wsByteBuffer.limit(n);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allocateByteBuffers");
        }
        return wsByteBufferArray;
    }

    public static boolean anyPositionsNonZero(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null || wsByteBufferArray[i].position() == 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ProtoSSLEngineResult handleHandshake(SSLConnectionLink sSLConnectionLink, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4, ProtoSSLEngineResult protoSSLEngineResult, SSLHandshakeCompletedCallback sSLHandshakeCompletedCallback, boolean bl) throws IOException, ReadOnlyBufferException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleHandshake, engine=" + sSLConnectionLink.getSSLEngine().hashCode()));
        }
        Runnable runnable = null;
        ProtoSSLEngine protoSSLEngine = sSLConnectionLink.getSSLEngine();
        TCPReadRequestContext tCPReadRequestContext = sSLConnectionLink.getDeviceReadInterface();
        TCPWriteRequestContext tCPWriteRequestContext = sSLConnectionLink.getDeviceWriteInterface();
        int n = 0;
        int n2 = 0;
        ProtoSSLEngineResult.Status status = null;
        status = protoSSLEngineResult == null ? ProtoSSLEngineResult.Status.HS_NEED_WRAP : protoSSLEngineResult.getStatus();
        ProtoSSLEngineResult.Status status2 = status;
        if (bl && protoSSLEngineResult != null && protoSSLEngineResult.getStatus() == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"From callback, former status BUFFER_UNDERFLOW.");
            }
            wsByteBuffer.limit(wsByteBuffer.position());
            wsByteBuffer.reset();
        }
        while (protoSSLEngine.isHandshaking() || status != ProtoSSLEngineResult.Status.HS_FINISHED && status != ProtoSSLEngineResult.Status.OK) {
            VirtualConnection virtualConnection;
            Object object;
            ++n2;
            if (status == ProtoSSLEngineResult.Status.HS_FINISHED) break;
            if (status == ProtoSSLEngineResult.Status.HS_NEED_WRAP) {
                block52: {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("before wrap: \r\n\tencryptedAppBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer4)));
                    }
                    protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer4.getWrappedByteBuffer());
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("after wrap: \r\n\tencryptedAppBuffer: pos=" + SSLUtils.getBufferTraceInfo(wsByteBuffer4) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced()));
                    }
                    status = protoSSLEngineResult.getStatus();
                    n = protoSSLEngineResult.outBytesProduced();
                    if (n > 0) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Write bytes: " + n));
                        }
                        tCPWriteRequestContext.setBuffer(wsByteBuffer4);
                        if (sSLHandshakeCompletedCallback != null) {
                            object = new SSLHandshakeIOCallback(sSLConnectionLink, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, protoSSLEngineResult, sSLHandshakeCompletedCallback);
                            virtualConnection = tCPWriteRequestContext.write(n, (TCPWriteCompletedCallback)object, false, 0);
                            if (virtualConnection != null) {
                                wsByteBuffer4.clear();
                                break block52;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Write is not done.  Callback will be used.");
                                }
                                protoSSLEngineResult = null;
                                break;
                            }
                        }
                        tCPWriteRequestContext.write(n, 0);
                        wsByteBuffer4.clear();
                    } else {
                        wsByteBuffer4.clear();
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Status after HS_NEED_WRAP section: " + status));
                }
            }
            while (status == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                runnable = protoSSLEngine.getDelegatedTask();
                if (runnable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Run task");
                    }
                    runnable.run();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("After task: sslEngine.isHandshaking=" + protoSSLEngine.isHandshaking()));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No task, setting status to HS_NEED_WRAP");
                }
                status = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
            }
            if (status == ProtoSSLEngineResult.Status.HS_NEED_UNWRAP || status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                block53: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Need more network data, do a read, netbuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer)));
                    }
                    if (wsByteBuffer.remaining() == wsByteBuffer.capacity() && status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        object = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
                        SSLUtils.copyBuffer(wsByteBuffer, (WsByteBuffer)object);
                        object.flip();
                        wsByteBuffer.release();
                        wsByteBuffer = object;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Had to grow the netBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer)));
                        }
                    }
                    if (wsByteBuffer.remaining() == 0 && n2 != 1 || wsByteBuffer.remaining() == wsByteBuffer.capacity() || status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW && (status2 != status || n2 != 1)) {
                        tCPReadRequestContext.setBuffer(wsByteBuffer);
                        if (wsByteBuffer.remaining() == 0 || wsByteBuffer.remaining() == wsByteBuffer.capacity()) {
                            wsByteBuffer.clear();
                            wsByteBuffer.mark();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Nothing was in the buffer.  Cleared netbuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer)));
                            }
                        } else {
                            wsByteBuffer.mark();
                            wsByteBuffer.position(wsByteBuffer.limit());
                            wsByteBuffer.limit(wsByteBuffer.capacity());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Data in netbuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer)));
                            }
                        }
                        if (sSLHandshakeCompletedCallback != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Do async read");
                            }
                            if ((virtualConnection = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)(object = new SSLHandshakeIOCallback(sSLConnectionLink, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, protoSSLEngineResult, sSLHandshakeCompletedCallback)), false, 0)) != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Read already done.  No callback necessary.");
                                }
                                wsByteBuffer.limit(wsByteBuffer.position());
                                wsByteBuffer.reset();
                                break block53;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Read is not done.  Callback will be used.");
                                }
                                protoSSLEngineResult = null;
                                break;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Do sync read");
                        }
                        long l = 0L;
                        while (l == 0L) {
                            l = tCPReadRequestContext.read(1L, 0);
                            if (!tc.isEventEnabled()) continue;
                            Tr.event((TraceComponent)tc, (String)("Read bytes: " + l));
                        }
                        wsByteBuffer.limit(wsByteBuffer.position());
                        wsByteBuffer.reset();
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Data already in networkBuffer to be read.");
                        }
                        if (wsByteBuffer.remaining() == 0 && n2 == 1) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Callback came back with data that needs to be flipped.");
                            }
                            wsByteBuffer.flip();
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("netBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer)));
                        }
                    }
                }
                if (0 != wsByteBuffer.position() && wsByteBuffer.limit() == wsByteBuffer.capacity() && n2 == 1) {
                    wsByteBuffer.limit(wsByteBuffer.position());
                    wsByteBuffer.reset();
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before unwrap: \r\n\tnetBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tdecryptedNetBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2)));
                }
                protoSSLEngineResult = protoSSLEngine.unwrap(wsByteBuffer.getWrappedByteBuffer(), wsByteBuffer2.getWrappedByteBuffer());
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after unwrap: \r\n\tnetBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\n\tdecryptedNetBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced()));
                }
                if (wsByteBuffer.remaining() == 0) {
                    wsByteBuffer.clear();
                }
                status = protoSSLEngineResult.getStatus();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Status after HS_NEED_UNWRAP section: " + status));
                }
            }
            if (status == ProtoSSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER_OVERFLOW occured during handshake: " + status));
                }
                throw new SSLException("BUFFER_OVERFLOW occured during handshake: " + status);
            }
            if (status != ProtoSSLEngineResult.Status.CLOSED) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Handshake terminated SSL engine: " + status));
            }
            throw new SSLException("Handshake terminated SSL engine: " + status);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("after handshake loop, result=" + protoSSLEngineResult + ", fromCallback=" + bl + ", engine=" + protoSSLEngine.hashCode() + "\r\n" + "after unwrap:\r\nnetBuf.pos: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\ndecryptedNetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer2)));
        }
        if (bl && protoSSLEngineResult != null) {
            sSLHandshakeCompletedCallback.complete(protoSSLEngineResult);
            protoSSLEngineResult = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleHandshake");
        }
        return protoSSLEngineResult;
    }

    public static void handleHandshake(ProtoSSLEngine protoSSLEngine, ProtoSSLEngine protoSSLEngine2) throws SSLException {
        WsByteBuffer wsByteBuffer;
        WsByteBuffer wsByteBuffer2;
        WsByteBuffer wsByteBuffer3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleHandshake");
        }
        if (protoSSLEngine == null || protoSSLEngine2 == null) {
            throw new SSLException("Null engine found: engine1=" + protoSSLEngine + ", engine2=" + protoSSLEngine2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parameters: engine1=" + protoSSLEngine.hashCode() + ", engine2=" + protoSSLEngine2.hashCode()));
        }
        WsByteBuffer wsByteBuffer4 = wsByteBuffer3 = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
        WsByteBuffer wsByteBuffer5 = wsByteBuffer2 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), false);
        WsByteBuffer wsByteBuffer6 = wsByteBuffer = SSLUtils.allocateByteBuffer(protoSSLEngine.getPacketBufferSize(), false);
        Runnable runnable = null;
        ProtoSSLEngine protoSSLEngine3 = null;
        ProtoSSLEngineResult.Status status = null;
        ProtoSSLEngineResult.Status status2 = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
        ProtoSSLEngineResult.Status status3 = ProtoSSLEngineResult.Status.HS_NEED_UNWRAP;
        protoSSLEngine.beginHandshake();
        protoSSLEngine2.beginHandshake();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current engine= " + protoSSLEngine.hashCode() + ", status=" + status2));
        }
        while (protoSSLEngine.isHandshaking() || protoSSLEngine2.isHandshaking() || status2 != ProtoSSLEngineResult.Status.HS_FINISHED || status3 != ProtoSSLEngineResult.Status.HS_FINISHED) {
            ProtoSSLEngineResult protoSSLEngineResult;
            if (status2 == ProtoSSLEngineResult.Status.HS_NEED_WRAP && wsByteBuffer6.limit() == wsByteBuffer6.capacity()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before wrap: encryptedAppBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer6)));
                }
                protoSSLEngineResult = protoSSLEngine.wrap(null, wsByteBuffer6.getWrappedByteBuffer());
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after wrap: encryptedAppBuffer: pos=" + SSLUtils.getBufferTraceInfo(wsByteBuffer6) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced()));
                }
                status2 = protoSSLEngineResult.getStatus();
            } else if ((status2 == ProtoSSLEngineResult.Status.HS_FINISHED || status2 == ProtoSSLEngineResult.Status.HS_NEED_UNWRAP) && wsByteBuffer4.limit() != wsByteBuffer4.capacity()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before unwrap: \r\n\tnetBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer4) + "\r\n\tdecryptedNetBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer5)));
                }
                protoSSLEngineResult = protoSSLEngine.unwrap(wsByteBuffer4.getWrappedByteBuffer(), wsByteBuffer5.getWrappedByteBuffer());
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after unwrap: \r\n\tnetBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer4) + "\r\n\tdecryptedNetBuffer: pos=" + SSLUtils.getBufferTraceInfo(wsByteBuffer5) + "\r\n\tstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced()));
                }
                status2 = protoSSLEngineResult.getStatus();
                if (wsByteBuffer4.remaining() == 0) {
                    wsByteBuffer4.clear();
                }
            } else if (status2 != ProtoSSLEngineResult.Status.HS_NEED_UNWRAP && status2 != ProtoSSLEngineResult.Status.HS_NEED_WRAP && status2 != ProtoSSLEngineResult.Status.HS_FINISHED && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected status: " + status2));
                throw new SSLException("Unexpected status: " + status2);
            }
            if (status2 == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                while (status2 == ProtoSSLEngineResult.Status.HS_NEED_TASK) {
                    runnable = protoSSLEngine.getDelegatedTask();
                    if (runnable != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Run task");
                        }
                        runnable.run();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("After task: sslEngine.isHandshaking=" + protoSSLEngine.isHandshaking()));
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No task, setting status to HS_NEED_WRAP");
                    }
                    status2 = ProtoSSLEngineResult.Status.HS_NEED_WRAP;
                }
                if (status2 == ProtoSSLEngineResult.Status.HS_NEED_WRAP) continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Switching engines");
            }
            wsByteBuffer4 = wsByteBuffer6;
            protoSSLEngine3 = protoSSLEngine;
            protoSSLEngine = protoSSLEngine2;
            protoSSLEngine2 = protoSSLEngine3;
            status = status2;
            status2 = status3;
            status3 = status;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("current engine= " + protoSSLEngine.hashCode() + ", status=" + status2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleHandshake");
        }
    }

    public static ProtoSSLEngine getSSLEngine(SSLContext sSLContext, FlowType flowType, SSLChannelData sSLChannelData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLEngine");
        }
        ProtoSSLEngine protoSSLEngine = sSLContext.createProtoSSLEngine();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("created ssl engine, hc=" + protoSSLEngine.hashCode()));
        }
        protoSSLEngine.setEnabledCipherSuites(sSLChannelData.getEnabledCipherSuites());
        protoSSLEngine.beginHandshake();
        if (flowType == FlowType.INBOUND) {
            protoSSLEngine.setNeedClientAuth(sSLChannelData.getClientAuthentication());
            protoSSLEngine.setUseClientMode(false);
        } else {
            protoSSLEngine.setUseClientMode(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLEngine");
        }
        return protoSSLEngine;
    }

    public static int[] adjustBuffersForJSSE(WsByteBuffer[] wsByteBufferArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"adjustBuffersForJSSE");
        }
        int[] nArray = null;
        int n2 = 0;
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            if ((n2 += wsByteBufferArray[i].remaining()) > n) {
                int n3 = wsByteBufferArray[i].limit();
                nArray = new int[]{i, n3};
                int n4 = n2 - n;
                wsByteBufferArray[i].limit(n3 - n4);
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("adjusted limit of buffer [" + i + "] from " + n3 + " to " + wsByteBufferArray[i].limit()));
                break;
            }
            if (n2 == n) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"adjustBuffersForJSSE");
        }
        return nArray;
    }

    public static void resetBuffersAfterJSSE(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        WsByteBuffer wsByteBuffer;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetBuffersAfterJSSE");
        }
        if (nArray == null) {
            return;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (wsByteBufferArray.length > n && (wsByteBuffer = wsByteBufferArray[n]) != null && wsByteBuffer.capacity() >= n2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("reseting limit of buffer [" + n + "] from " + wsByteBuffer.limit() + " to " + n2));
            }
            wsByteBuffer.limit(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)SSLUtils.getBufferTraceInfo(wsByteBuffer));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetBuffersAfterJSSE");
        }
    }

    public static void getBufferLimits(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBufferLimits");
        }
        if (wsByteBufferArray != null && nArray != null) {
            for (int i = 0; i < wsByteBufferArray.length && i < nArray.length; ++i) {
                if (wsByteBufferArray[i] != null) {
                    nArray[i] = wsByteBufferArray[i].limit();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Saved buffer[" + i + "] limit of " + nArray[i]));
                    continue;
                }
                nArray[i] = 0;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Saved null buffer[" + i + "] limit of " + nArray[i]));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Null buffers or null limits passed in, so nothing changed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBufferLimits");
        }
    }

    public static void setBufferLimits(WsByteBuffer[] wsByteBufferArray, int[] nArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBufferLimits");
        }
        if (wsByteBufferArray != null && nArray != null) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < wsByteBufferArray.length && i < nArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                n = wsByteBufferArray[i].capacity();
                n2 = nArray[i];
                if (wsByteBufferArray[i].limit() == n2) continue;
                if (n >= n2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Buffer [" + i + "] being updated from " + wsByteBufferArray[i].limit() + " to " + n2));
                    }
                    wsByteBufferArray[i].limit(n2);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Buffer [" + i + "] has capacity " + n + " less than passed in limit " + n2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBufferLimits");
        }
    }
}

