/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse.KeyManagerFactoryParametersSpec;
import com.ibm.jsse2.IBMJSSEProvider2;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.jsse2.SSLContext;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.SSLConfig;
import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLDiscriminatorState;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.ws.ssl.channel.impl.X509KeyManagerWrapper;
import com.ibm.ws.ssl.channel.stat.SSLStatsModule;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.OutboundChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class SSLChannel
implements InboundChannel,
OutboundChannel,
Discriminator {
    protected static final TraceComponent tc = Tr.register((Class)SSLChannel.class, (String)"SSLChannel", (String)"com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLChannel";
    public static final String SSL_DISCRIMINATOR_STATE = "SSLDiscState";
    private static final SSLConfig serverSSL = new SSLConfig(SSLConfig.getDefaultServerConfig(), "");
    protected DiscriminationProcess discProcess = null;
    protected SSLChannelData sslConfig = null;
    protected SSLContext sslContext = null;
    protected SSLSessionContext sessionContext = null;
    private SSLStatsModule statsModule = null;
    protected KeyStore keyStore = null;
    protected KeyManagerFactory keyManagerFactory = null;
    protected KeyStore trustStore = null;
    protected TrustManagerFactory trustManagerFactory = null;
    protected boolean delayInitialization = false;
    private boolean isInitialized = false;
    protected boolean XD = false;

    public SSLChannel(ChannelData channelData) {
        this.sslConfig = new SSLChannelData(channelData);
    }

    public void setXD(boolean bl) {
        this.XD = bl;
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.discProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess discriminationProcess) {
        this.discProcess = discriminationProcess;
    }

    public Class getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    public Class getDeviceAddress() {
        return TCPConnectRequestContext.class;
    }

    public Class[] getApplicationAddress() {
        return new Class[]{TCPConnectRequestContext.class};
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (!this.isInitialized) {
            try {
                this.delayedInit();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception caught while getting SSL connection link: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)CLASS_NAME, (String)"148", (Object)this, (Object[])new Object[]{virtualConnection});
                throw new RuntimeException(exception);
            }
        }
        SSLConnectionLink sSLConnectionLink = new SSLConnectionLink(this);
        sSLConnectionLink.init(virtualConnection);
        return sSLConnectionLink;
    }

    public void start() throws ChannelException {
    }

    public void stop(long l) throws ChannelException {
        if (0L == l && this.getConfig().areStatsEnabled() && null != this.statsModule) {
            this.statsModule.stop();
        }
    }

    public void init() throws ChannelException {
        if (!this.delayInitialization) {
            this.delayedInit();
        }
    }

    public synchronized void delayedInit() throws ChannelException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delayedInit");
        }
        if (this.isInitialized) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Providers in security:");
            object = Security.getProviders();
            for (int i = 0; i < ((Provider[])object).length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("\t" + object[i].getName()));
            }
        }
        this.sslConfig.readProperties();
        if (null == Security.getProvider("IBMJSSE2")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Provider IBMJSSE2 needs tp be added to Security.");
            }
            object = new AddProviderAction();
            AccessController.doPrivileged(object);
        }
        if (this.sslConfig.getCryptoEnabled() || this.sslConfig.getTokenLibraryFile() != null) {
            this.enableHardwareProvider();
        }
        if (this.getConfig().areStatsEnabled()) {
            this.statsModule = new SSLStatsModule(this.getConfig().getExternalName());
        }
        this.createSSLContext();
        this.isInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delayedInit");
        }
    }

    protected void enableHardwareProvider() throws ChannelException {
        throw new ChannelException("Hardware crypto is not supported");
    }

    public void createSSLContext() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSSLContext");
        }
        try {
            String string = this.sslConfig.getContextProvider();
            String string2 = this.sslConfig.getTrustStoreProvider();
            String string3 = this.sslConfig.getTrustStore();
            String string4 = this.sslConfig.getTrustStorePassword();
            String string5 = this.sslConfig.getKeyStore();
            String string6 = this.sslConfig.getKeyStorePassword();
            String string7 = this.sslConfig.getTokenLibraryFile();
            char[] cArray = null;
            boolean bl = false;
            this.sslContext = string == null ? SSLContext.getInstance((String)this.sslConfig.getProtocol()) : SSLContext.getInstance((String)this.sslConfig.getProtocol(), (String)string);
            if (string3 != null && string4 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using trust store: " + string3));
                }
                this.trustStore = this.getKeyStore(this.sslConfig.getTrustStoreType(), string2, string3, string4);
            } else if (string7 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No trust store specified, but found hardware crypto");
                }
                this.trustStore = this.getKeyStore("PKCS11IMPLKS", null, null, "");
                bl = true;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No trust store specified and no hardware crypto defined");
                }
                if (this.sslConfig.isInbound() && !this.sslConfig.getClientAuthentication()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trust store permitted to be null since this is inbound and client auth is false");
                    }
                } else {
                    throw new ChannelException("Invalid trust file name of null");
                }
            }
            this.trustManagerFactory = string != null ? TrustManagerFactory.getInstance(this.sslConfig.getTrustManager(), string) : TrustManagerFactory.getInstance(this.sslConfig.getTrustManager());
            this.trustManagerFactory.init(this.trustStore);
            if (string5 != null && string6 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using software keystore: " + string5));
                }
                if (this.sslConfig.getKeyStoreType().equals(this.sslConfig.getTrustStoreType()) && this.sslConfig.getKeyStoreProvider().equals(this.sslConfig.getTrustStoreProvider()) && string5.equals(string3) && this.sslConfig.getKeyStorePassword().equals(this.sslConfig.getTrustStorePassword())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reusing key store from Trust Manager");
                    }
                    this.keyStore = this.trustStore;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating new key store for Key Manager");
                    }
                    this.keyStore = this.getKeyStore(this.sslConfig.getKeyStoreType(), this.sslConfig.getKeyStoreProvider(), string5, this.sslConfig.getKeyStorePassword());
                }
                if (string6 != null) {
                    cArray = string6.toCharArray();
                }
            } else if (string7 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No key store specified, but found hardware crypto");
                }
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reusing key store from Trust Manager");
                    }
                    this.keyStore = this.trustStore;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating new key store for Key Manager");
                    }
                    this.keyStore = this.getKeyStore("PKCS11IMPLKS", null, null, "");
                }
                cArray = "".toCharArray();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No key store specified and no hardware crypto defined");
                }
                throw new ChannelException("No key store specified and no hardware crypto defined");
            }
            this.keyManagerFactory = string == null ? KeyManagerFactory.getInstance(this.sslConfig.getKeyManager()) : KeyManagerFactory.getInstance(this.sslConfig.getKeyManager(), string);
            try {
                if (!this.isZOS()) {
                    this.keyManagerFactory.init(this.keyStore, cArray);
                } else if (this.sslConfig.getCryptoEnabled()) {
                    KeyManagerFactoryParametersSpec keyManagerFactoryParametersSpec = new KeyManagerFactoryParametersSpec(this.keyStore, cArray, "IBMJCE4758");
                    this.keyManagerFactory.init((ManagerFactoryParameters)keyManagerFactoryParametersSpec);
                } else {
                    this.keyManagerFactory.init(this.keyStore, cArray);
                }
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new UnrecoverableKeyException(unrecoverableKeyException.getMessage() + ": invalid password for file '" + string5 + "'");
            }
            this.initSSLContext();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught during init, " + exception));
            }
            FFDCFilter.processException((Throwable)exception, (String)CLASS_NAME, (String)"168", (Object)this);
            throw new ChannelException((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSSLContext");
        }
    }

    private KeyStore getKeyStore(String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyStore");
        }
        KeyStore keyStore = null;
        String string5 = null;
        boolean bl = true;
        int n = 0;
        ArrayList arrayList = new ArrayList();
        while (bl) {
            if (string2 == null) {
                keyStore = KeyStore.getInstance(string);
                string5 = serverSSL.getKeyStoreProvider();
            } else {
                keyStore = KeyStore.getInstance(string, string2);
                string5 = string2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"keyStoreProvider: ", (Object)string5);
            }
            char[] cArray = null;
            if (string4 != null) {
                cArray = string4.toCharArray();
            }
            try {
                if (null == string3) {
                    keyStore.load(null, cArray);
                    bl = false;
                    continue;
                }
                InputStream inputStream = this.openKeyStore(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getKeyStore created a new inputStream: " + string3));
                }
                keyStore.load(inputStream, cArray);
                bl = false;
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equalsIgnoreCase("Invalid keystore format") || iOException.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (n == 0) {
                        Tr.warning((TraceComponent)tc, (String)"security.ssl.config.initialization.warning.invalidkeystoretype");
                        arrayList = serverSSL.getValidKeyStoreTypes(string5);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Valid keyStore list: " + arrayList.toString()));
                    }
                    if (n >= arrayList.size()) {
                        throw iOException;
                    }
                    string = (String)arrayList.get(n++);
                    continue;
                }
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKeyStore");
        }
        return keyStore;
    }

    protected InputStream openKeyStore(String string) throws MalformedURLException, IOException {
        try {
            OpenKeyStoreAction openKeyStoreAction = new OpenKeyStoreAction(string);
            return (InputStream)AccessController.doPrivileged(openKeyStoreAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)privilegedActionException, (String)CLASS_NAME, (String)"631", (Object)this, (Object[])new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object)new Object[]{exception});
            }
            if (exception instanceof MalformedURLException) {
                throw (MalformedURLException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    protected void initSSLContext() throws Exception {
        KeyManager[] keyManagerArray = this.keyManagerFactory.getKeyManagers();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of key managers: " + keyManagerArray.length));
        }
        KeyManager[] keyManagerArray2 = new KeyManager[keyManagerArray.length];
        for (int i = 0; i < keyManagerArray.length; ++i) {
            if (keyManagerArray[i] instanceof X509KeyManager) {
                keyManagerArray2[i] = new X509KeyManagerWrapper((X509KeyManager)keyManagerArray[i], (String)this.sslConfig.getProperties().get("com.ibm.ssl.keyStoreServerAlias"));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("convert " + keyManagerArray[i] + " to " + keyManagerArray2[i]));
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Keep " + keyManagerArray[i] + " as it is"));
            }
            keyManagerArray2[i] = keyManagerArray[i];
        }
        this.sslContext.init(keyManagerArray2, this.trustManagerFactory.getTrustManagers(), null);
    }

    public void destroy() throws ChannelException {
        this.discProcess = null;
        this.sslConfig = null;
        this.sslContext = null;
    }

    public String getName() {
        return this.sslConfig.getName();
    }

    public Class getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public Class getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public void update(ChannelData channelData) {
        this.sslConfig.updateChannelData((com.ibm.websphere.channel.framework.ChannelData)channelData);
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"discriminate");
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received null discrim data.  Returning NO from discriminator.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"discriminate");
            }
            return 0;
        }
        WsByteBuffer wsByteBuffer = ((WsByteBuffer[])object)[0];
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("netBuffer: " + SSLUtils.getBufferTraceInfo(wsByteBuffer)));
        }
        if (0 == wsByteBuffer.position()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received empty discrim data.  Returning MAYBE from discriminator.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"discriminate");
            }
            return -1;
        }
        if (!this.isInitialized) {
            try {
                this.delayedInit();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception caught while getting SSL connection link: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)CLASS_NAME, (String)"148", (Object)this, (Object[])new Object[]{virtualConnection});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"discriminate");
                }
                return 0;
            }
        }
        int n = wsByteBuffer.position();
        int n2 = wsByteBuffer.limit();
        WsByteBuffer wsByteBuffer2 = null;
        Map map = virtualConnection.getStateMap();
        ProtoSSLEngine protoSSLEngine = null;
        ProtoSSLEngineResult protoSSLEngineResult = null;
        ProtoSSLEngineResult.Status status = null;
        int n3 = 1;
        SSLDiscriminatorState sSLDiscriminatorState = null;
        wsByteBuffer.flip();
        sSLDiscriminatorState = (SSLDiscriminatorState)map.get(SSL_DISCRIMINATOR_STATE);
        if (sSLDiscriminatorState == null) {
            protoSSLEngine = SSLUtils.getSSLEngine(this.sslContext, FlowType.INBOUND, this.sslConfig);
            wsByteBuffer2 = SSLUtils.allocateByteBuffer(protoSSLEngine.getApplicationBufferSize(), this.sslConfig.getDecryptBuffersDirect());
        } else {
            protoSSLEngine = sSLDiscriminatorState.getEngine();
            wsByteBuffer2 = sSLDiscriminatorState.getDecryptedNetBuffer();
        }
        try {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("before unwrap: netBuf.pos: " + wsByteBuffer.position() + " netBuf.lim=" + wsByteBuffer.limit() + " decNetBuf.pos=" + wsByteBuffer2.position() + " decNetBuf.lim=" + wsByteBuffer2.limit()));
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{wsByteBuffer};
            int[] nArray = SSLUtils.adjustBuffersForJSSE(wsByteBufferArray, protoSSLEngine.getPacketBufferSize());
            protoSSLEngineResult = protoSSLEngine.unwrap(wsByteBuffer.getWrappedByteBuffer(), wsByteBuffer2.getWrappedByteBuffer());
            if (nArray != null) {
                SSLUtils.resetBuffersAfterJSSE(wsByteBufferArray, nArray);
            }
            status = protoSSLEngineResult.getStatus();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("after unwrap: netBuf.pos=" + wsByteBuffer.position() + " netBuf.lim=" + wsByteBuffer.limit() + " decNetBuf.pos=" + wsByteBuffer2.position() + " decNetBuf.lim=" + wsByteBuffer2.limit() + "\nstatus=" + status + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced()));
            }
            if (status == ProtoSSLEngineResult.Status.BUFFER_UNDERFLOW) {
                n3 = -1;
            } else {
                n3 = 1;
                if (wsByteBuffer.remaining() == 0) {
                    wsByteBuffer.clear();
                }
            }
        }
        catch (SSLException sSLException) {
            n3 = 0;
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            n3 = 0;
        }
        switch (n3) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discriminator returning YES");
                }
                if (sSLDiscriminatorState == null) {
                    sSLDiscriminatorState = new SSLDiscriminatorState();
                }
                sSLDiscriminatorState.updateState(protoSSLEngine, protoSSLEngineResult, wsByteBuffer2, wsByteBuffer.position(), wsByteBuffer.limit());
                map.put(SSL_DISCRIMINATOR_STATE, sSLDiscriminatorState);
                break;
            }
            case 0: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discriminator returning NO");
                }
                if (sSLDiscriminatorState != null) {
                    map.remove(SSL_DISCRIMINATOR_STATE);
                    this.closeEngine(sSLDiscriminatorState.getEngine());
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Releasing decryptedNetworkBuffer");
                }
                wsByteBuffer2.release();
                wsByteBuffer2 = null;
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discriminator returning MAYBE");
                }
                if (sSLDiscriminatorState != null) break;
                sSLDiscriminatorState = new SSLDiscriminatorState();
                sSLDiscriminatorState.updateState(protoSSLEngine, protoSSLEngineResult, wsByteBuffer2, wsByteBuffer.position(), wsByteBuffer.limit());
                map.put(SSL_DISCRIMINATOR_STATE, sSLDiscriminatorState);
            }
        }
        wsByteBuffer.limit(n2);
        wsByteBuffer.position(n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"discriminate");
        }
        return n3;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanUpState");
        }
        Map map = virtualConnection.getStateMap();
        SSLDiscriminatorState sSLDiscriminatorState = (SSLDiscriminatorState)map.remove(SSL_DISCRIMINATOR_STATE);
        this.closeEngine(sSLDiscriminatorState.getEngine());
        WsByteBuffer wsByteBuffer = sSLDiscriminatorState.getDecryptedNetBuffer();
        if (wsByteBuffer != null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Releasing decryptedNetworkBuffer");
            }
            wsByteBuffer.release();
            wsByteBuffer = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanUpState");
        }
    }

    protected void onHandshakeFinish(ProtoSSLEngine protoSSLEngine) {
        if (null != this.sessionContext) {
            return;
        }
        SSLSessionContext sSLSessionContext = null;
        try {
            final ProtoSSLEngine protoSSLEngine2 = protoSSLEngine;
            sSLSessionContext = (SSLSessionContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return protoSSLEngine2.getSession().getSessionContext();
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ssl.channel.impl.SSLChannel.onHandshakeFinish", (String)"814");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception querying sessioncontext; " + exception));
            }
            return;
        }
        if (null == sSLSessionContext) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Null SSL context on engine: " + protoSSLEngine));
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Channel [" + this + "] saving context: " + sSLSessionContext));
        }
        this.sessionContext = sSLSessionContext;
        sSLSessionContext.setSessionCacheSize(this.getConfig().getSSLSessionCacheSize());
        sSLSessionContext.setSessionTimeout(this.getConfig().getSSLSessionTimeout());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Session cache size set to " + sSLSessionContext.getSessionCacheSize()));
            Tr.debug((TraceComponent)tc, (String)("Session timeout set to " + sSLSessionContext.getSessionTimeout()));
        }
        if (this.getConfig().areStatsEnabled() && null != this.statsModule) {
            this.statsModule.setContext(this.sessionContext);
            this.statsModule.start();
        }
    }

    private void closeEngine(ProtoSSLEngine protoSSLEngine) {
        if (null != protoSSLEngine) {
            if (!protoSSLEngine.isInboundDone()) {
                protoSSLEngine.closeInbound();
            }
            if (!protoSSLEngine.isOutboundDone()) {
                protoSSLEngine.closeOutbound();
            }
        }
    }

    public Class getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.sslConfig.getWeight();
    }

    public SSLChannelData getConfig() {
        return this.sslConfig;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    protected boolean isZOS() {
        return false;
    }

    class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String string) {
            this.file = string;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"OpenKeyStoreAction.run");
            }
            InputStream inputStream = null;
            URL uRL = null;
            File file = new File(this.file);
            if (file.exists() && file.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            uRL = !file.exists() ? new URL(this.file) : new URL("file:" + file.getCanonicalPath());
            inputStream = uRL.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"OpenKeyStoreAction.run");
            }
            return inputStream;
        }
    }

    class AddProviderAction
    implements PrivilegedAction {
        public Object run() {
            Security.addProvider((Provider)new IBMJSSEProvider2());
            return null;
        }
    }
}

