/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import java.util.HashMap;
import java.util.Properties;

public class DistributedObjectCacheFactory {
    private static TraceComponent tc = Trace.register(DistributedObjectCacheFactory.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public static final String KEY_CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String KEY_DISABLE_DEPENDENCY_ID = "com.ibm.ws.cache.CacheConfig.disableDependencyId";
    public static final String KEY_DISABLE_TEMPLATES_SUPPORT = "com.ibm.ws.cache.CacheConfig.disableTemplatesSupport";
    public static final String KEY_ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String KEY_ENABLE_NIO_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableNioSupport";
    public static final String KEY_DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String KEY_USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String KEY_FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    public static final String KEY_ENABLE_CACHE_REPLICATION = "com.ibm.ws.cache.CacheConfig.enableCacheReplication";
    public static final String KEY_REPLICATION_DOMAIN = "com.ibm.ws.cache.CacheConfig.replicationDomain";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private static HashMap distributedMaps = new HashMap();
    private static final String FACTORY_PREFIX = "ws/";

    private DistributedObjectCacheFactory() {
    }

    public static DistributedObjectCache getMap(String string) {
        return DistributedObjectCacheFactory.getMap(string, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistributedObjectCache getMap(String string, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMap() name: (" + string + ") properties:" + properties));
        }
        if (string == null || string.trim().length() == 0) {
            throw new IllegalStateException("Map name can not be null or empty");
        }
        if (ServerCache.cacheUnit == null) {
            throw new IllegalStateException("Dynamic Cache Service has not been started.");
        }
        String string2 = string;
        if (!string.equalsIgnoreCase("default") && !string.equalsIgnoreCase("baseCache")) {
            string = FACTORY_PREFIX + string.trim();
        }
        DistributedObjectCache distributedObjectCache = null;
        HashMap hashMap = distributedMaps;
        synchronized (hashMap) {
            distributedObjectCache = (DistributedObjectCache)distributedMaps.get(string);
            if (distributedObjectCache == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Existing DistributedObjectCache not found for " + string));
                }
                distributedObjectCache = DistributedObjectCacheFactory.createDistributedObjectCache(string, string2, properties);
                distributedMaps.put(string, distributedObjectCache);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Existing DistributedObjectCache found for " + string + " " + distributedObjectCache));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMap() map:" + distributedObjectCache));
        }
        return distributedObjectCache;
    }

    private static DistributedObjectCache createDistributedObjectCache(String string, String string2, Properties properties) {
        Object object;
        Cache cache;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createDistributedObjectCache() name: " + string + " properties:" + properties));
        }
        if ((cache = ServerCache.getCache(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Existing Cache not found for " + string));
            }
            object = (CacheConfig)ServerCache.cacheUnit.getCacheConfig().clone();
            properties.put("com.ibm.ws.cache.CacheConfig.cacheName", string);
            properties.put("com.ibm.ws.cache.CacheConfig.cacheNameNonPrefixed", string2);
            ((CacheConfig)object).overrideCacheConfig(properties);
            ServerCache.cacheService.addCacheInstanceConfig((CacheConfig)object);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Existing Cache found for " + string + " " + cache));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DistributedMap " + string + " created from cache instance " + cache));
        }
        object = (DistributedObjectCache)ServerCache.cacheService.createCacheInstance(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDistributedObjectCache() map:" + object));
        }
        return object;
    }
}

