/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.stat;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.ArrayList;
import java.util.HashMap;

public class CacheStatsModule
implements StatisticActionListener,
CachePerf {
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    private static final String templateCount0 = "/com/ibm/websphere/pmi/xml/cacheModule_root.xml";
    private static final String templateCount2 = "/com/ibm/websphere/pmi/xml/cacheModule_servlet.xml";
    private static final String templateCount15 = "/com/ibm/websphere/pmi/xml/cacheModule_template.xml";
    private static final String templateCount18 = "/com/ibm/websphere/pmi/xml/cacheModule_object.xml";
    public static final int TYPE_SERVLET = 1;
    public static final int TYPE_OBJECT = 2;
    private static StatsGroup _cacheRootStatsGroup;
    private static StatsGroup _cacheServletTypeStatsGroup;
    private static StatsGroup _cacheObjectTypeStatsGroup;
    private StatsGroup _cacheTemplateStatsGroup;
    private StatsInstance _statsInstance = null;
    private String _sCacheGroupName;
    private String _sCacheName;
    private int _iCacheType;
    private SPICountStatistic _maxInMemoryCacheEntryCount = null;
    private SPICountStatistic _inMemoryCacheEntryCount = null;
    private SPICountStatistic _hitsInMemoryCount = null;
    private SPICountStatistic _hitsOnDiskCount = null;
    private SPICountStatistic _explicitInvalidationCount = null;
    private SPICountStatistic _lruInvalidationCount = null;
    private SPICountStatistic _timeoutInvalidationCount = null;
    private SPICountStatistic _inMemoryAndDiskCacheEntryCount = null;
    private SPICountStatistic _remoteHitCount = null;
    private SPICountStatistic _missCount = null;
    private SPICountStatistic _clientRequestCount = null;
    private SPICountStatistic _distributedRequestCount = null;
    private SPICountStatistic _explicitMemoryInvalidationCount = null;
    private SPICountStatistic _explicitDiskInvalidationCount = null;
    private SPICountStatistic _localExplicitInvalidationCount = null;
    private SPICountStatistic _remoteExplicitInvalidationCount = null;
    private SPICountStatistic _remoteCreationCount = null;
    HashMap templatesPassed = new HashMap();
    ArrayList templatesFailed = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    private CacheStatsModule() {
    }

    public CacheStatsModule(String string, String string2) throws StatsFactoryException {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 cacheGroupName=" + string + " cacheName=" + string2));
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        this._sCacheGroupName = string;
        this._sCacheName = string2;
        if (_cacheRootStatsGroup == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 Creating cacheModule group for cacheName=" + this._sCacheName));
            }
            _cacheRootStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule", (String)templateCount0, null);
            if (!$assertionsDisabled && _cacheRootStatsGroup == null) {
                throw new AssertionError();
            }
        }
        if (string.equals("cacheModule.servlet")) {
            this._iCacheType = 1;
            if (_cacheServletTypeStatsGroup == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 Creating servlet cache group for cacheName=" + this._sCacheName));
                }
                _cacheServletTypeStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule.servlet", (String)templateCount2, (StatsGroup)_cacheRootStatsGroup, null);
                if (!$assertionsDisabled && _cacheServletTypeStatsGroup == null) {
                    throw new AssertionError();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 Creating statistic for " + this._sCacheName + " instance (servlet cache)"));
            }
            this._statsInstance = StatsFactory.createStatsInstance((String)string2, (StatsGroup)_cacheServletTypeStatsGroup, null, (StatisticActionListener)this);
        } else if (string.equals("cacheModule.object")) {
            this._iCacheType = 2;
            if (_cacheObjectTypeStatsGroup == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 Creating object cache group for cacheName=" + this._sCacheName));
                }
                _cacheObjectTypeStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule.object", (String)templateCount18, (StatsGroup)_cacheRootStatsGroup, null);
                if (!$assertionsDisabled && _cacheObjectTypeStatsGroup == null) {
                    throw new AssertionError();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 Creating statistic for " + this._sCacheName + " instance (object cache)"));
            }
            this._statsInstance = StatsFactory.createStatsInstance((String)string2, (StatsGroup)_cacheObjectTypeStatsGroup, null, (StatisticActionListener)this);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown cache group name=" + string));
        }
        if (!$assertionsDisabled && this._statsInstance == null) {
            throw new AssertionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 _statsInstance=" + this._statsInstance + " for cacheName=" + this._sCacheName));
        }
    }

    public CacheStatsModule(String string, String string2, StatsGroup statsGroup) throws StatsFactoryException {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("CacheStatsModule() CTOR #2 cacheName=" + string), (Object)(" template=" + string2));
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && statsGroup == null) {
            throw new AssertionError();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #2 Creating statistic for template=" + string2 + " instance" + " cacheName=" + string));
        }
        this._statsInstance = StatsFactory.createStatsInstance((String)string2, (StatsGroup)statsGroup, null, (StatisticActionListener)this);
        if (!$assertionsDisabled && this._statsInstance == null) {
            throw new AssertionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("CacheStatsModule() CTOR #2 _statsInstance=" + this._statsInstance + " for cacheName=" + string));
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        switch (sPIStatistic.getId()) {
            case 1: {
                this._maxInMemoryCacheEntryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this._inMemoryCacheEntryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 21: {
                this._hitsInMemoryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 22: {
                this._hitsOnDiskCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 23: {
                this._explicitInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 24: {
                this._lruInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 25: {
                this._timeoutInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 26: {
                this._inMemoryAndDiskCacheEntryCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 27: {
                this._remoteHitCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 28: {
                this._missCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 29: {
                this._clientRequestCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 30: {
                this._distributedRequestCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 31: {
                this._explicitMemoryInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 32: {
                this._explicitDiskInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 34: {
                this._localExplicitInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 35: {
                this._remoteExplicitInvalidationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 36: {
                this._remoteCreationCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("statisticCreated() Error - Unknown stats Id for cacheModule cacheName=" + this._sCacheName + " dataID=" + sPIStatistic.getId()));
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public void updateStatisticOnRequest(int n) {
    }

    public boolean isPMIEnabled() {
        boolean bl = false;
        int[] nArray = null;
        if (_cacheServletTypeStatsGroup != null && (nArray = ((PmiAbstractModule)_cacheServletTypeStatsGroup).getEnabled()).length > 0) {
            bl = true;
        }
        if (!bl && _cacheObjectTypeStatsGroup != null && (nArray = ((PmiAbstractModule)_cacheObjectTypeStatsGroup).getEnabled()).length > 0) {
            bl = true;
        }
        return bl;
    }

    public void updateCacheSizes(long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateCacheSizes() cacheName=" + this._sCacheName + " max=" + l + " current=" + l2));
        }
        if (this._maxInMemoryCacheEntryCount != null) {
            this._maxInMemoryCacheEntryCount.setCount(l);
        }
        if (this._inMemoryCacheEntryCount != null) {
            this._inMemoryCacheEntryCount.setCount(l2);
        }
    }

    public void onCacheHit(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onCacheHit() cacheName=" + this._sCacheName + " template=" + string + " locality=" + n));
        }
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        switch (n) {
            case 2: {
                if (cacheStatsModule._remoteHitCount == null) break;
                cacheStatsModule._remoteHitCount.increment();
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.increment();
                cacheStatsModule._remoteCreationCount.increment();
                break;
            }
            case 1: {
                if (cacheStatsModule._hitsInMemoryCount == null) break;
                cacheStatsModule._hitsInMemoryCount.increment();
                break;
            }
            case 3: {
                if (cacheStatsModule._hitsOnDiskCount == null) break;
                cacheStatsModule._hitsOnDiskCount.increment();
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("onCacheHit() Error - Unrecognized locality " + n + " cacheName=" + this._sCacheName));
            }
        }
    }

    public void onCacheMiss(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onCacheMiss() cacheName=" + this._sCacheName + " template=" + string + " locality=" + n));
        }
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (cacheStatsModule._missCount != null) {
            cacheStatsModule._missCount.increment();
        }
    }

    public void onEntryCreation(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onEntryCreation() cacheName=" + this._sCacheName + " template=" + string + " source=" + n));
        }
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (n == 2 && cacheStatsModule._remoteCreationCount != null) {
            cacheStatsModule._remoteCreationCount.increment();
        }
        if (cacheStatsModule._inMemoryAndDiskCacheEntryCount != null) {
            cacheStatsModule._inMemoryAndDiskCacheEntryCount.increment();
        }
    }

    public void onRequest(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onRequest() cacheName=" + this._sCacheName + " template=" + string + " source=" + n));
        }
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        if (n == 5) {
            if (cacheStatsModule._clientRequestCount != null) {
                cacheStatsModule._clientRequestCount.increment();
            }
        } else if (n == 2 && cacheStatsModule._distributedRequestCount != null) {
            cacheStatsModule._distributedRequestCount.increment();
        }
    }

    public void batchOnInvalidate(String string, int n, int n2, int n3, int n4) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("batchOnInvalidate() cacheName=" + this._sCacheName + " template=" + string + " cause=" + n + " locality=" + n2 + " source=" + n3 + " delete=" + n4));
        }
        CacheStatsModule cacheStatsModule = null;
        cacheStatsModule = this.getCSM(string);
        if (cacheStatsModule == null) {
            return;
        }
        switch (n) {
            case 1: {
                if (cacheStatsModule._explicitInvalidationCount != null) {
                    cacheStatsModule._explicitInvalidationCount.increment((long)n4);
                }
                switch (n2) {
                    case 1: {
                        if (cacheStatsModule._explicitMemoryInvalidationCount != null) {
                            cacheStatsModule._explicitMemoryInvalidationCount.increment((long)n4);
                        }
                        if (cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                        cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement((long)n4);
                        break;
                    }
                    case 3: {
                        if (cacheStatsModule._explicitDiskInvalidationCount != null) {
                            cacheStatsModule._explicitDiskInvalidationCount.increment((long)n4);
                        }
                        if (cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                        cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement((long)n4);
                    }
                }
                switch (n3) {
                    case 5: {
                        if (cacheStatsModule._localExplicitInvalidationCount == null) break;
                        cacheStatsModule._localExplicitInvalidationCount.increment((long)n4);
                        break;
                    }
                    case 2: {
                        if (cacheStatsModule._remoteExplicitInvalidationCount == null) break;
                        cacheStatsModule._remoteExplicitInvalidationCount.increment((long)n4);
                    }
                }
                break;
            }
            case 2: {
                if (cacheStatsModule._lruInvalidationCount != null) {
                    cacheStatsModule._lruInvalidationCount.increment((long)n4);
                }
                if (n2 == 3 || cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement((long)n4);
                break;
            }
            case 3: {
                if (cacheStatsModule._timeoutInvalidationCount != null) {
                    cacheStatsModule._timeoutInvalidationCount.increment((long)n4);
                }
                if (cacheStatsModule._inMemoryAndDiskCacheEntryCount == null) break;
                cacheStatsModule._inMemoryAndDiskCacheEntryCount.decrement((long)n4);
            }
        }
    }

    public void onInvalidate(String string, int n, int n2, int n3) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onInvalidate() cacheName=" + this._sCacheName + " template=" + string + " cause=" + n + " locality=" + n2 + " source=" + n3));
        }
        this.batchOnInvalidate(string, n, n2, n3, 1);
    }

    private synchronized CacheStatsModule createTemplateModule(String string) {
        CacheStatsModule cacheStatsModule = (CacheStatsModule)this.templatesPassed.get(string);
        if (cacheStatsModule == null && !this.templatesFailed.contains(string)) {
            try {
                if (this._cacheTemplateStatsGroup == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createTemplateModule() Creating template group for cacheName=" + this._sCacheName));
                    }
                    this._cacheTemplateStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule.template", (String)templateCount15, (StatsInstance)this._statsInstance, null);
                    if (!$assertionsDisabled && this._cacheTemplateStatsGroup == null) {
                        throw new AssertionError();
                    }
                }
                cacheStatsModule = new CacheStatsModule(this._sCacheName, string, this._cacheTemplateStatsGroup);
                this.templatesPassed.put(string, cacheStatsModule);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.stat.CacheStatsModule", "572", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createTemplateModule() Exception while creating template - cacheName=" + this._sCacheName + " template=" + string + ": " + ExceptionUtility.getStackTrace(throwable)));
                }
                this.templatesFailed.add(string);
                cacheStatsModule = null;
            }
        }
        return cacheStatsModule;
    }

    private CacheStatsModule getCSM(String string) {
        CacheStatsModule cacheStatsModule = null;
        if (this._iCacheType == 1) {
            if (string != null && !string.equals("") && (cacheStatsModule = (CacheStatsModule)this.templatesPassed.get(string)) == null) {
                cacheStatsModule = this.createTemplateModule(string);
            }
        } else {
            cacheStatsModule = this;
        }
        return cacheStatsModule;
    }

    static {
        $assertionsDisabled = !CacheStatsModule.class.desiredAssertionStatus();
        tc = Trace.register(CacheStatsModule.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
    }
}

