/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.ExternalCacheServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentComposerMemento;

public class JSPCache {
    private Cache cache = null;
    private RemoteServices remoteServices = null;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private ExternalCacheServices externalCacheServices = null;
    private int defaultPriority = CacheEntry.DEFAULT_PRIORITY;
    private static TraceComponent tc = Trace.register(JSPCache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    public void setRemoteServices(RemoteServices remoteServices) {
        this.remoteServices = remoteServices;
    }

    public void setExternalCacheServices(ExternalCacheServices externalCacheServices) {
        this.externalCacheServices = externalCacheServices;
    }

    public void setDefaultPriority(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("defaultPriority must be nonnegative");
        }
        this.defaultPriority = n;
    }

    public void start() {
        if (this.cache == null || this.batchUpdateDaemon == null || this.remoteServices == null) {
            throw new IllegalStateException("cache, batchUpdateDaemon, and remoteServices must all be set before start()");
        }
    }

    public void setExternalCacheFragment(String string, ExternalCacheFragment externalCacheFragment) {
        this.remoteServices.setExternalCacheFragment(string, externalCacheFragment);
    }

    public void setValue(EntryInfo entryInfo, FragmentComposerMemento fragmentComposerMemento, ExternalCacheFragment externalCacheFragment) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setValue");
        }
        fragmentComposerMemento.setExternalCacheFragment(externalCacheFragment);
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        this.cache.setValue(entryInfo, fragmentComposerMemento);
        if (externalCacheFragment != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding ECF to BatchUpdateDaemon");
            }
            this.batchUpdateDaemon.pushExternalCacheFragment(externalCacheFragment, this.cache);
        }
        fragmentComposerMemento.setExternalCacheFragment(null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setValue");
        }
    }

    public void itsUncacheable(String string) {
    }

    public CacheEntry getEntry(String string) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.getEntry(string);
        if (cacheEntry != null) {
            if (cacheEntry.getId() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getEntry(String): ce.getId is null, returning null.");
                }
                cacheEntry = null;
            } else if (!cacheEntry.getId().equals(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getEntry(String): ce.getId:" + cacheEntry.getId() + " does not equal id:" + string + ", returning null."));
                }
                cacheEntry = null;
            }
        }
        return cacheEntry;
    }

    public CacheEntry getEntry(EntryInfo entryInfo) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.getEntry(entryInfo);
        if (cacheEntry != null) {
            if (cacheEntry.getId() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getEntry(EntryInfo): ce.getId is null, returning null.");
                }
                cacheEntry = null;
            } else if (!cacheEntry.getId().equals(entryInfo.getId())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getEntry(EntryInfo): ce.getId:" + cacheEntry.getId() + " does not equal entryInfo.getId:" + entryInfo.getId() + ", returning null."));
                }
                cacheEntry = null;
            }
        }
        return cacheEntry;
    }

    public boolean isValid(String string) {
        return this.cache.isValid(string);
    }

    public Object getValue(EntryInfo entryInfo, boolean bl) {
        return this.cache.getValue(entryInfo, bl);
    }

    public void invalidateById(String string, boolean bl) {
        this.cache.invalidateById(string, bl);
    }

    public void invalidateByTemplate(String string, boolean bl) {
        this.cache.invalidateByTemplate(string, bl);
    }

    public boolean shouldPull(int n, String string) {
        return this.cache.shouldPull(n, string);
    }

    public void preInvoke(String string, CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        this.externalCacheServices.preInvoke(string, cacheProxyRequest, cacheProxyResponse);
    }

    public void postInvoke(String string, CacheProxyRequest cacheProxyRequest, CacheProxyResponse cacheProxyResponse) {
        this.externalCacheServices.postInvoke(string, cacheProxyRequest, cacheProxyResponse);
    }
}

