/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIInvalidatorControllerProxy;
import com.ibm.ws.cache.esi.ESIInvalidatorControllerProxyImpl;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import com.ibm.ws.cache.servlet.ESIInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;

public class ESIOutputStream
extends DataOutputStream {
    private static final TraceComponent tc = Tr.register((Class)ESIOutputStream.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final boolean isZOS = ESIInvalidatorHelper.isZOS;
    private ByteArrayOutputStream bos = null;
    private ORB orb = null;
    private static ESIInvalidatorControllerProxy proxyReference = null;
    private static String response = null;
    private static boolean proxyIsUp = false;

    public ESIOutputStream(OutputStream outputStream) throws IOException {
        super(isZOS ? new ByteArrayOutputStream() : outputStream);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor");
        }
        if (isZOS) {
            this.bos = (ByteArrayOutputStream)this.out;
            this.contactProxy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    protected String contactProxy() throws IOException {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"contactProxy()");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"contactProxy() : creating ESI proxy reference");
                }
                this.orb = ESIInvalidatorHelper.ph.getGlobalORB();
                if (this.orb == null) {
                    throw new IOException("ORB is null - ESI proxy reference not created");
                }
                proxyReference = (ESIInvalidatorControllerProxy)this.orb.resolve_initial_references(ESIInvalidatorControllerProxyImpl.getId());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"contactProxy() : Successfully created ESI proxy reference");
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("contactProxy() : error contacting proxy : " + throwable.getMessage()));
                }
                throw new IOException(throwable.getMessage());
            }
            if (proxyReference == null) {
                throw new IOException("contactProxy() : CR reference is null, ESI proxy deactivated.");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"contactProxy() : contacting CR proxy");
                }
                response = proxyReference.flow(new Integer(7).toString() + new Integer(ESIInvalidatorHelper.cacheInterval).toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("contactProxy() : CR contacted : " + new String(response)));
                }
                if (response.equals("ok")) {
                    proxyIsUp = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"contactProxy() : proxy contacted");
                    }
                    break block17;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("contactProxy() : error contacting proxy : " + response));
                }
                throw new IOException("contactProxy() : ESI proxy contact failed.");
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("contactProxy() : error contacting proxy : " + throwable.getMessage()));
                }
                throw new IOException(throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("contactProxy() " + response));
        }
        return response;
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("flush() " + proxyIsUp));
        }
        if (!isZOS) {
            this.out.flush();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flush()");
            }
            return;
        }
        if (!proxyIsUp) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flush() : proxy is inactive");
            }
            throw new IOException("flush() : ESI proxy is inactive.");
        }
        if (this.bos != null) {
            String string = new String(this.bos.toByteArray()).trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("flush() command : " + string));
            }
            try {
                proxyReference.send(string);
            }
            catch (Throwable throwable) {
                this.isProxyDown(throwable);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("flush() : error driving proxy : " + throwable.getMessage()));
                }
                throw new IOException(throwable.getMessage());
            }
            finally {
                this.bos.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush()");
        }
    }

    public ESIInputStream flushWithResponse() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("flushWithResponse() " + proxyIsUp));
        }
        if (!isZOS) {
            this.out.flush();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flushWithResponse()");
            }
            return null;
        }
        if (!proxyIsUp) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushWithResponse() : proxy is inactive");
            }
            throw new IOException("flushWithResponse() : ESI proxy is inactive.");
        }
        String string = null;
        if (this.bos != null) {
            string = new String(this.bos.toByteArray()).trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("flushWithResponse() command : " + string));
            }
            try {
                response = proxyReference.flow(string);
            }
            catch (Throwable throwable) {
                this.isProxyDown(throwable);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("flushWithResponse() : error driving proxy : " + throwable.getMessage()));
                }
                throw new IOException(throwable.getMessage());
            }
            finally {
                this.bos.reset();
            }
        }
        if (response == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushWithResponse() : null response from proxy");
            }
            throw new IOException("flushWithResponse() : null response received.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("flushWithResponse() " + response.length()));
        }
        return new ESIInputStream(response.getBytes());
    }

    private void isProxyDown(Throwable throwable) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isProxyDown() " + throwable));
        }
        if (throwable instanceof RemoteException && (string = ((RemoteException)throwable).getMessage()).equals("down")) {
            proxyIsUp = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isProxyDown() : proxy up : " + proxyIsUp));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isProxyDown()");
        }
    }
}

