/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.DynamicContentProvider;
import com.ibm.websphere.servlet.cache.ServletCacheResponse;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.servlet.CacheProxyOutputStream;
import com.ibm.ws.cache.servlet.CacheProxyWriter;
import com.ibm.ws.cache.servlet.ESISupport;
import com.ibm.ws.cache.servlet.FragmentComposer;
import com.ibm.ws.io.WSByteArrayOutputStream;
import com.ibm.ws.io.WSCharArrayWriter;
import com.ibm.ws.webcontainer.srt.IExtendedResponse;
import com.ibm.ws.webcontainer.srt.IResponseOutput;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CacheProxyResponse
extends HttpServletResponseWrapper
implements IResponseOutput,
ServletCacheResponse {
    private static TraceComponent tc = Trace.register(CacheProxyResponse.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private FragmentComposer fragmentComposer = null;
    boolean _gotWriter = false;
    boolean _gotOutputStream = false;
    private boolean composerActive = true;
    private boolean containsESIContent = false;
    boolean bufferOutput = false;
    CacheProxyWriter bufferedWriter = null;
    CacheProxyOutputStream bufferedOutputStream = null;
    CacheProxyWriter writer = null;
    CacheProxyOutputStream outputStream = null;
    boolean doneFlushBuffer = false;

    public CacheProxyResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void finished() {
        this.fragmentComposer = null;
        this.bufferedWriter = null;
        this.bufferedOutputStream = null;
        this.composerActive = false;
    }

    public Vector[] getHeaderTable() {
        return ((IExtendedResponse)this.getResponse()).getHeaderTable();
    }

    protected void setBufferingOutput(boolean bl) {
        this.bufferOutput = bl;
        if (!this.bufferOutput) {
            this.bufferedWriter = null;
            this.bufferedOutputStream = null;
        }
    }

    protected boolean isBufferingOutput() {
        return this.bufferOutput;
    }

    protected void flushOutput() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("flushOutput(), bufferedWriter is " + this.bufferedWriter + ", bufferedOutputStream is " + (Object)((Object)this.bufferedOutputStream)));
        }
        if (this.bufferedWriter != null && this.bufferedOutputStream != null) {
            throw new IllegalStateException("cannot buffer both text and bytes");
        }
        if (this.bufferedWriter != null) {
            WSCharArrayWriter wSCharArrayWriter = (WSCharArrayWriter)this.bufferedWriter.getWriter();
            wSCharArrayWriter.writeTo((Writer)this.getResponse().getWriter());
            wSCharArrayWriter.reset();
            this.bufferedWriter = null;
        } else if (this.bufferedOutputStream != null) {
            WSByteArrayOutputStream wSByteArrayOutputStream = (WSByteArrayOutputStream)this.bufferedOutputStream.getOutputStream();
            wSByteArrayOutputStream.writeTo((OutputStream)this.getResponse().getOutputStream());
            wSByteArrayOutputStream.reset();
            this.bufferedOutputStream = null;
        }
        this.bufferOutput = false;
    }

    public void setFragmentComposer(FragmentComposer fragmentComposer) {
        this.fragmentComposer = fragmentComposer;
    }

    public FragmentComposer getFragmentComposer() {
        return this.fragmentComposer;
    }

    public void setComposerActive(boolean bl) {
        this.composerActive = bl;
    }

    public boolean getComposerActive() {
        return this.composerActive;
    }

    public void flushBuffer() throws IOException {
        this.doneFlushBuffer = true;
        if (!this.bufferOutput) {
            if (this.getResponse() instanceof IResponseOutput) {
                ((IResponseOutput)this.getResponse()).flushBuffer(true);
            } else {
                this.getResponse().flushBuffer();
            }
        }
    }

    public void flushBuffer(boolean bl) throws IOException {
        this.doneFlushBuffer = true;
        if (!this.bufferOutput) {
            if (this.getResponse() instanceof IResponseOutput) {
                ((IResponseOutput)this.getResponse()).flushBuffer(bl);
            } else {
                this.getResponse().flushBuffer();
            }
        }
    }

    public boolean isCommitted() {
        boolean bl = false;
        CacheProxyResponse cacheProxyResponse = this;
        while (cacheProxyResponse instanceof HttpServletResponseWrapper) {
            if (cacheProxyResponse instanceof CacheProxyResponse) {
                CacheProxyResponse cacheProxyResponse2 = cacheProxyResponse;
                if (cacheProxyResponse2.writer != null && cacheProxyResponse2.writer.writerFlushed || cacheProxyResponse2.outputStream != null && cacheProxyResponse2.outputStream.outputStreamFlushed) {
                    bl = true;
                    break;
                }
            }
            cacheProxyResponse = (HttpServletResponse)((HttpServletResponseWrapper)cacheProxyResponse).getResponse();
        }
        if (!bl) {
            return this.getResponse().isCommitted();
        }
        return bl;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this._gotOutputStream = true;
        this.outputStream = (CacheProxyOutputStream)this.fragmentComposer.getOutputStream();
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        this._gotWriter = true;
        if (this.fragmentComposer == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("fragmentComposer is null: " + this));
        }
        this.writer = (CacheProxyWriter)this.fragmentComposer.getPrintWriter();
        return this.writer;
    }

    public ServletOutputStream getBufferedOutputStream() throws IOException {
        if (!this.bufferOutput) {
            throw new IllegalStateException("shouldn't call getBufferedOutputStream() when not buffering output");
        }
        this.getResponse().getOutputStream();
        if (this.bufferedOutputStream == null) {
            this.bufferedOutputStream = new CacheProxyOutputStream((OutputStream)new WSByteArrayOutputStream());
        }
        return this.bufferedOutputStream;
    }

    public PrintWriter getBufferedWriter() throws IOException {
        if (!this.bufferOutput) {
            throw new IllegalStateException("shouldn't call getBufferedWriter() when not buffering output");
        }
        this.getResponse().getWriter();
        if (this.bufferedWriter == null) {
            this.bufferedWriter = new CacheProxyWriter((Writer)new WSCharArrayWriter());
        }
        return this.bufferedWriter;
    }

    public void resetBuffer() {
        if (this.composerActive) {
            this.fragmentComposer.resetBuffer();
        }
        super.resetBuffer();
        if (this.bufferedOutputStream != null) {
            ((WSByteArrayOutputStream)this.bufferedOutputStream.getOutputStream()).reset();
        }
        if (this.bufferedWriter != null) {
            ((WSCharArrayWriter)this.bufferedWriter.getWriter()).reset();
        }
    }

    public void reset() {
        this.resetBuffer();
        super.reset();
    }

    public boolean getContainsESIContent() {
        return this.containsESIContent;
    }

    public void setContainsESIContent(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setContainsESIContent(" + bl + "), containsESIContent is " + this.containsESIContent + ", parent is " + this.fragmentComposer.getParent()));
        }
        if (this.containsESIContent == bl) {
            return;
        }
        this.containsESIContent = bl;
        FragmentComposer fragmentComposer = this.fragmentComposer.getParent();
        if (fragmentComposer != null) {
            fragmentComposer.getResponse().setContainsESIContent(this.containsESIContent);
        }
    }

    public void setBufferSize(int n) {
        if (this.composerActive) {
            this.fragmentComposer.setBufferSize(n);
        }
        super.setBufferSize(n);
    }

    public int getBufferSize() {
        if (this.composerActive) {
            return this.fragmentComposer.getBufferSize();
        }
        return super.getBufferSize();
    }

    public void _include(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        ((SRTServletRequest)httpServletRequest).getWebAppDispatcherContext()._include(string, httpServletRequest);
    }

    public void _forward(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        ((SRTServletRequest)httpServletRequest).getWebAppDispatcherContext()._forward(string, httpServletRequest);
    }

    public void callPage(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        this._forward(string, httpServletRequest);
    }

    public void setHeader(String string, String string2) {
        if (this.composerActive) {
            this.fragmentComposer.setHeader(string, string2, true);
        }
        super.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) {
        if (this.composerActive) {
            this.fragmentComposer.setHeader(string, string2, false);
        }
        super.addHeader(string, string2);
    }

    public void addCookie(Cookie cookie) {
        if (this.composerActive) {
            this.fragmentComposer.addCookie(cookie);
        }
        super.addCookie(cookie);
    }

    public void addDynamicContentProvider(DynamicContentProvider dynamicContentProvider) throws IOException {
        if (this.composerActive) {
            this.fragmentComposer.addDynamicContentProvider(dynamicContentProvider);
        }
    }

    public void setDateHeader(String string, long l) {
        if (this.composerActive) {
            this.fragmentComposer.setDateHeader(string, l, true);
        }
        super.setDateHeader(string, l);
    }

    public void addDateHeader(String string, long l) {
        if (this.composerActive) {
            this.fragmentComposer.setDateHeader(string, l, false);
        }
        super.addDateHeader(string, l);
    }

    public void setIntHeader(String string, int n) {
        if (this.composerActive) {
            this.fragmentComposer.setIntHeader(string, n, true);
        }
        super.setIntHeader(string, n);
    }

    public void addIntHeader(String string, int n) {
        if (this.composerActive) {
            this.fragmentComposer.setIntHeader(string, n, false);
        }
        super.addIntHeader(string, n);
    }

    public void setStatus(int n) {
        if (this.composerActive) {
            this.fragmentComposer.setStatus(n);
        }
        super.setStatus(n);
    }

    public void setStatus(int n, String string) {
        if (this.composerActive) {
            this.fragmentComposer.setStatus(n, string);
        }
        super.setStatus(n, string);
    }

    public void setContentLength(int n) {
        if (this.composerActive) {
            this.fragmentComposer.setContentLength(n);
        }
        super.setContentLength(n);
    }

    public void setContentType(String string) {
        super.setContentType(string);
        if (this.composerActive) {
            this.fragmentComposer.setContentType(string);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.composerActive) {
            this.fragmentComposer.setLocale(locale);
        }
    }

    public void sendRedirect(String string) throws IOException {
        ESISupport.handleESIPostProcessing(this, this.fragmentComposer.getFragmentInfo());
        if (this.composerActive) {
            this.fragmentComposer.sendRedirect(string);
        }
        super.sendRedirect(string);
    }

    public void setDoNotConsume(boolean bl) {
        if (this.composerActive) {
            this.fragmentComposer.setDoNotConsume(bl);
        }
    }

    public boolean writerObtained() {
        return this._gotWriter;
    }

    public boolean outputStreamObtained() {
        return this._gotOutputStream;
    }
}

