/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.persistent.htod;

import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.FileManagerException;
import java.io.EOFException;
import java.io.IOException;

class HashHeader {
    int magic;
    int currentTablePtr = 0;
    private int num_objects = -1;
    int loadFactor = 75;
    long rehashInProgress = 0L;
    long disklocation = -1L;
    int currentRehashIndex = -1;
    int[] tablesize;
    long[] tableLocation;
    private boolean dirty = false;
    private FileManager filemgr = null;
    private long headerLoc = 0L;
    private long currentOffset = 4L;
    private long countOffset = 8L;
    private long loadfOffset = 12L;
    private long rehashOffset = 16L;
    private long table1Offset = 24L;
    private long table2Offset = 36L;
    private final int headerSize = 48;

    HashHeader(FileManager fileManager, int n, int n2, int n3) throws IOException, EOFException, FileManagerException {
        this.filemgr = fileManager;
        this.magic = n;
        this.loadFactor = n2;
        this.disklocation = this.filemgr.allocate(48);
        this.currentOffset += this.disklocation;
        this.countOffset += this.disklocation;
        this.loadfOffset += this.disklocation;
        this.rehashOffset += this.disklocation;
        this.table1Offset += this.disklocation;
        this.table2Offset += this.disklocation;
        this.currentTablePtr = 0;
        this.tablesize = new int[2];
        this.tableLocation = new long[2];
        this.tablesize[0] = n3;
        this.tablesize[1] = 0;
        this.tableLocation[0] = this.filemgr.allocateAndClear(this.tablesize[0] * 8);
        this.tableLocation[1] = 0L;
        this.write();
    }

    HashHeader(FileManager fileManager, long l) throws IOException {
        this.filemgr = fileManager;
        this.disklocation = l;
        this.read();
    }

    public int num_objects() {
        return this.num_objects;
    }

    public void set_num_objects(int n) {
        this.num_objects = n;
    }

    public void updateRehashIndex(int n) {
        this.currentRehashIndex = n;
    }

    public int getHtIndex(int n, int n2) {
        if (this.tablesize[n2] == 0) {
            return 0;
        }
        return (n & Integer.MAX_VALUE) % this.tablesize[n2];
    }

    public long calcOffset(int n, int n2) {
        if (this.tableLocation[n2] == 0L) {
            return 0L;
        }
        return this.tableLocation[n2] + (long)(n * 8);
    }

    void read() throws IOException {
        this.currentOffset += this.disklocation;
        this.countOffset += this.disklocation;
        this.loadfOffset += this.disklocation;
        this.rehashOffset += this.disklocation;
        this.table1Offset += this.disklocation;
        this.table2Offset += this.disklocation;
        this.filemgr.seek(this.disklocation);
        this.magic = this.filemgr.readInt();
        this.currentTablePtr = this.filemgr.readInt();
        this.num_objects = this.filemgr.readInt();
        this.loadFactor = this.filemgr.readInt();
        this.rehashInProgress = this.filemgr.readLong();
        this.tablesize = new int[2];
        this.tableLocation = new long[2];
        this.tablesize[0] = this.filemgr.readInt();
        this.tableLocation[0] = this.filemgr.readLong();
        this.tablesize[1] = this.filemgr.readInt();
        this.tableLocation[1] = this.filemgr.readLong();
    }

    void write() throws IOException {
        if (!this.filemgr.isReadOnly()) {
            this.filemgr.seek(this.disklocation);
            this.filemgr.writeInt(this.magic);
            this.filemgr.writeInt(this.currentTablePtr);
            this.filemgr.writeInt(this.num_objects);
            this.filemgr.writeInt(this.loadFactor);
            this.filemgr.writeLong(this.rehashInProgress);
            this.filemgr.writeInt(this.tablesize[0]);
            this.filemgr.writeLong(this.tableLocation[0]);
            this.filemgr.writeInt(this.tablesize[1]);
            this.filemgr.writeLong(this.tableLocation[1]);
            this.dirty = false;
        } else {
            System.out.println("Hashtable opened RO, skipping header update");
        }
    }

    int currentTableId() {
        return this.currentTablePtr;
    }

    int alternateTableId() {
        if (this.currentTablePtr == 0) {
            return 1;
        }
        return 0;
    }

    int getTableidForNewEntry() {
        if (this.rehashInProgress == 1L) {
            return this.alternateTableId();
        }
        return this.currentTableId();
    }

    long currentTable() {
        return this.tableLocation[this.currentTablePtr];
    }

    int tablesize() {
        return this.tablesize[this.currentTablePtr];
    }

    int tablesize(int n) {
        return this.tablesize[n];
    }

    long alternateTable() {
        if (this.currentTablePtr == 0) {
            return this.tableLocation[1];
        }
        return this.tableLocation[0];
    }

    int alternateSize() {
        if (this.currentTablePtr == 0) {
            return this.tablesize[1];
        }
        return this.tablesize[0];
    }

    void writeCount() throws IOException {
        if (this.dirty) {
            return;
        }
        if (!this.filemgr.isReadOnly()) {
            this.filemgr.seek(this.countOffset);
            this.filemgr.writeInt(0);
            this.dirty = true;
        }
    }

    void incrementObjectCount() throws IOException {
        if (this.num_objects < 0) {
            this.num_objects = 0;
        }
        ++this.num_objects;
        this.writeCount();
    }

    void decrementObjectCount() throws IOException {
        --this.num_objects;
        this.writeCount();
    }

    void setRehashFlag(long l) throws IOException, EOFException {
        this.rehashInProgress = l;
        this.filemgr.seek(this.rehashOffset);
        this.filemgr.writeLong(l);
    }

    void initNewTable(int n, long l) throws IOException {
        if (this.currentTablePtr == 0) {
            this.filemgr.seek(this.table2Offset);
            this.filemgr.writeInt(n);
            this.filemgr.writeLong(l);
            this.tablesize[1] = n;
            this.tableLocation[1] = l;
        } else {
            this.filemgr.seek(this.table1Offset);
            this.filemgr.writeInt(n);
            this.filemgr.writeLong(l);
            this.tablesize[0] = n;
            this.tableLocation[0] = l;
        }
    }

    void swapTables() throws IOException, ClassNotFoundException, FileManagerException {
        long l = 0L;
        this.rehashInProgress = 0L;
        this.currentRehashIndex = -1;
        if (this.currentTablePtr == 0) {
            l = this.tableLocation[0];
            this.currentTablePtr = 1;
            this.tableLocation[0] = 0L;
            this.tablesize[0] = 0;
            this.write();
        } else {
            l = this.tableLocation[1];
            this.currentTablePtr = 0;
            this.tableLocation[1] = 0L;
            this.tablesize[1] = 0;
            this.write();
        }
        this.filemgr.deallocate(l);
    }
}

