/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.persistent.filemgr;

import com.ibm.ws.cache.persistent.filemgr.Constants;
import com.ibm.ws.cache.persistent.filemgr.FileManager;
import com.ibm.ws.cache.persistent.filemgr.Instrumentation;
import com.ibm.ws.cache.persistent.filemgr.PhysicalFileInterface;
import com.ibm.ws.cache.persistent.util.ProfTimer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedAction;
import java.util.Vector;

public class MultivolumeRAFWrapper
implements PhysicalFileInterface,
Constants,
Instrumentation {
    private Vector physical = new Vector();
    private FileManager logical;
    String base_filename;
    String mode;
    long seek;
    long volume;
    long offset;
    static ProfTimer proftimer = new ProfTimer();

    public MultivolumeRAFWrapper(String string, String string2, FileManager fileManager) throws IOException {
        this.logical = fileManager;
        this.base_filename = string;
        this.mode = string2;
        boolean bl = false;
        boolean bl2 = false;
        File file = new File(this.base_filename).getAbsoluteFile();
        this.base_filename = file.toString();
        File file2 = file.getParentFile();
        File[] fileArray = file2.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (fileArray[i].isDirectory()) continue;
            String string3 = fileArray[i].getPath();
            int n2 = string3.lastIndexOf(".");
            String string4 = string3.substring(n2 + 1);
            try {
                int n3 = Integer.parseInt(string4);
                this.getVolume(n3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.physical.size() == 0) {
            this.getVolume(0L);
        }
    }

    public String filename() {
        return this.base_filename;
    }

    public long cachesize() {
        return 0L;
    }

    public boolean multivolume() {
        return true;
    }

    public int pagesize() {
        return 0;
    }

    public int num_volumes() {
        return this.physical.size();
    }

    public boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public void setCachePolicy(int n) throws IOException {
    }

    public void update_read_time(long l) {
        this.logical.update_read_time(l);
    }

    public void update_write_time(long l) {
        this.logical.update_write_time(l);
    }

    public void increment_read_count() {
        this.logical.increment_read_count();
    }

    public void increment_write_count() {
        this.logical.increment_write_count();
    }

    public long length() throws IOException {
        int n = this.physical.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.physical.get(i);
            if (randomAccessFile == null) continue;
            n2 = (int)((long)n2 + randomAccessFile.length());
        }
        return n2;
    }

    public void close() throws IOException {
        int n = this.physical.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.physical.get(i);
            if (randomAccessFile == null) continue;
            randomAccessFile.close();
            this.physical.set(i, null);
        }
    }

    public void flush() throws IOException {
    }

    public void seek(long l) throws IOException {
        if (this.seek != l) {
            this.seek = l;
            this.volume = this.seek / 0x40000000L;
            this.offset = this.seek % 0x40000000L;
            final RandomAccessFile randomAccessFile = this.getVolume(this.volume);
            final MultivolumeRAFWrapper multivolumeRAFWrapper = this;
            IOException iOException = (IOException)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        randomAccessFile.seek(MultivolumeRAFWrapper.this.offset);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", "234", multivolumeRAFWrapper);
                        return iOException;
                    }
                    return null;
                }
            });
        }
    }

    private void incrementSeekBy(long l) throws IOException {
        long l2 = this.offset + l;
        if (l2 >= 0x40000000L) {
            this.seek(this.seek + l);
        } else {
            this.offset = l2;
            this.seek = this.volume * 0x40000000L + this.offset;
        }
    }

    void makeVolume(long l) throws IOException {
        String string = this.base_filename + "." + l;
        File file = new File(string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, this.mode);
        if ((long)this.physical.size() < l + 1L) {
            this.physical.setSize((int)l + 1);
        }
        this.physical.set((int)l, randomAccessFile);
    }

    RandomAccessFile getVolume(long l) throws IOException {
        RandomAccessFile randomAccessFile;
        if ((long)this.physical.size() <= l) {
            this.makeVolume(l);
        }
        if ((randomAccessFile = (RandomAccessFile)this.physical.get((int)l)) == null) {
            this.makeVolume(l);
            randomAccessFile = (RandomAccessFile)this.physical.get((int)l);
        }
        return randomAccessFile;
    }

    public int read() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int n = this.getVolume(this.volume).read();
        this.incrementSeekBy(1L);
        this.update_read_time(proftimer.elapsed());
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int n = this.internalRead(byArray, 0, byArray.length);
        this.update_read_time(proftimer.elapsed());
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int n3 = this.internalRead(byArray, n, n2);
        this.update_read_time(proftimer.elapsed());
        return n3;
    }

    protected int internalRead(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        long l = 0x40000000L - this.offset;
        int n4 = (int)Math.min(l, (long)n2);
        int n5 = 0;
        while (n4 > 0) {
            n5 += this.getVolume(this.volume).read(byArray, n3, n4);
            n3 += n4;
            this.incrementSeekBy(n4);
            l = 0x40000000L - this.offset;
            n4 = (int)Math.min(l, (long)(n2 -= n4));
        }
        return n5;
    }

    public int readInt() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int n = 4;
        int n2 = 0;
        if (this.offset + (long)n <= 0x40000000L) {
            n2 = this.getVolume(this.volume).readInt();
            this.incrementSeekBy(n);
        } else {
            n2 = (int)this.readIntOverVolume(n);
        }
        this.update_read_time(proftimer.elapsed());
        return n2;
    }

    public long readLong() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int n = 8;
        long l = 0L;
        if (this.offset + (long)n <= 0x40000000L) {
            l = this.getVolume(this.volume).readLong();
            this.incrementSeekBy(n);
        } else {
            l = this.readIntOverVolume(n);
        }
        this.update_read_time(proftimer.elapsed());
        return l;
    }

    public short readShort() throws IOException {
        this.increment_read_count();
        proftimer.reset();
        int n = 2;
        short s = 0;
        if (this.offset + (long)n <= 0x40000000L) {
            s = this.getVolume(this.volume).readShort();
            this.incrementSeekBy(n);
        } else {
            s = (short)this.readIntOverVolume(n);
        }
        this.update_read_time(proftimer.elapsed());
        return s;
    }

    protected long readIntOverVolume(int n) throws IOException {
        long l = 0L;
        long l2 = 0x40000000L - this.offset;
        byte[] byArray = new byte[n];
        this.internalRead(byArray, 0, n);
        int n2 = (n - 1) * 8;
        for (int i = 0; i < n; ++i) {
            l |= (long)(byArray[i] << n2);
            ++n2;
        }
        return l;
    }

    public void write(byte[] byArray) throws IOException {
        proftimer.reset();
        this.internalWrite(byArray, 0, byArray.length);
        this.increment_write_count();
        this.update_write_time(proftimer.elapsed());
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        proftimer.reset();
        this.internalWrite(byArray, 0, n2);
        this.increment_write_count();
        this.update_write_time(proftimer.elapsed());
    }

    protected void internalWrite(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        long l = 0x40000000L - this.offset;
        int n4 = (int)Math.min(l, (long)n2);
        while (n4 > 0) {
            final MultivolumeRAFWrapper multivolumeRAFWrapper = this;
            final byte[] byArray2 = byArray;
            final int n5 = n3;
            final int n6 = n4;
            IOException iOException = (IOException)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        multivolumeRAFWrapper.getVolume(MultivolumeRAFWrapper.this.volume).write(byArray2, n5, n6);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", "463", multivolumeRAFWrapper);
                        return iOException;
                    }
                    return null;
                }
            });
            if (iOException != null) {
                throw iOException;
            }
            n3 += n4;
            this.incrementSeekBy(n4);
            l = 0x40000000L - this.offset;
            n4 = (int)Math.min(l, (long)(n2 -= n4));
        }
    }

    public void write(int n) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        final MultivolumeRAFWrapper multivolumeRAFWrapper = this;
        final int n2 = n;
        IOException iOException = (IOException)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    multivolumeRAFWrapper.getVolume(multivolumeRAFWrapper.volume).write(n2);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", "499", multivolumeRAFWrapper);
                    return iOException;
                }
                return null;
            }
        });
        if (iOException != null) {
            throw iOException;
        }
        this.incrementSeekBy(1L);
        this.update_write_time(proftimer.elapsed());
    }

    public void writeInt(int n) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        int n2 = 4;
        if (this.offset + (long)n2 <= 0x40000000L) {
            final MultivolumeRAFWrapper multivolumeRAFWrapper = this;
            final int n3 = n;
            IOException iOException = (IOException)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        multivolumeRAFWrapper.getVolume(multivolumeRAFWrapper.volume).writeInt(n3);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", "499", multivolumeRAFWrapper);
                        return iOException;
                    }
                    return null;
                }
            });
            this.incrementSeekBy(n2);
        } else {
            this.writeIntOverVolume(n, n2);
        }
        this.update_write_time(proftimer.elapsed());
    }

    public void writeLong(long l) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        int n = 8;
        if (this.offset + (long)n <= 0x40000000L) {
            final MultivolumeRAFWrapper multivolumeRAFWrapper = this;
            final long l2 = l;
            IOException iOException = (IOException)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        multivolumeRAFWrapper.getVolume(multivolumeRAFWrapper.volume).writeLong(l2);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", "545", multivolumeRAFWrapper);
                        return iOException;
                    }
                    return null;
                }
            });
            if (iOException != null) {
                throw iOException;
            }
            this.incrementSeekBy(n);
        } else {
            this.writeIntOverVolume(l, n);
        }
        this.update_write_time(proftimer.elapsed());
    }

    public void writeShort(short s) throws IOException {
        this.increment_write_count();
        proftimer.reset();
        int n = 2;
        if (this.offset + (long)n <= 0x40000000L) {
            final MultivolumeRAFWrapper multivolumeRAFWrapper = this;
            final short s2 = s;
            IOException iOException = (IOException)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        multivolumeRAFWrapper.getVolume(multivolumeRAFWrapper.volume).writeShort(s2);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.cache.persistent.filemgr.MultivolumeRAFWrapper", "545", multivolumeRAFWrapper);
                        return iOException;
                    }
                    return null;
                }
            });
            if (iOException != null) {
                throw iOException;
            }
            this.incrementSeekBy(n);
        } else {
            this.writeIntOverVolume(s, n);
        }
        this.update_write_time(proftimer.elapsed());
    }

    protected void writeIntOverVolume(long l, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = (n - 1) * 8;
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)((l & (long)(255 << n2)) >> n2);
            n2 -= 8;
        }
        this.internalWrite(byArray, 0, n);
    }
}

