/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.esi.ESIInterceptInputStream;
import com.ibm.ws.cache.esi.ESIInterceptOutputStream;
import com.ibm.ws.cache.esi.ESIInvalidator;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.util.PlatformHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ESIInvalidatorHelper {
    private static TraceComponent tc;
    public static PlatformHelper ph;
    private static final String cr = "\r";
    private static final String lf = "\n";
    private static final String crlf = "\r\n";
    protected static final byte[] crlfbytes;
    private static final String timeoutProperty = "private.com.ibm.ws.cache.esi.ESIInvalidator.socket.timeout";
    private static final String poolsizeProperty = "private.com.ibm.ws.cache.esi.ESIInvalidator.threadpool.size";
    protected static final String ESI_URL = "/_DynaCacheEsi/esiInvalidator";
    protected static final String EXPECT_100 = "Expect: 100-Continue";
    private static final String http100 = "HTTP/1.1 100 Continue\r\n";
    private static final String http200 = "HTTP/1.1 200 OK\r\n";
    protected static final String location = "Location: ";
    private static final String server = "Server: WebSphere Application Server/5.1\r\n";
    private static final String chunked = "Transfer-Encoding: chunked\r\n";
    private static final String close = "Connection: close\r\n";
    private static final String language = "Content-Language: en-US\r\n";
    private static final String responseLine = "Server: WebSphere Application Server/5.1\r\nContent-Language: en-US\r\nTransfer-Encoding: chunked\r\n\r\n";
    protected static byte[] contbytes;
    protected static byte[] okbytes;
    protected static final byte[] length4;
    protected static final byte[] length8;
    protected static final byte MSG_GET_PID = 1;
    protected static final byte MSG_GATHER = 2;
    protected static final byte MSG_INVALIDATE_ID = 5;
    protected static final byte MSG_END = 6;
    public static final byte MSG_CONTACT = 7;
    protected static final byte BLOCK_START = 1;
    protected static final int CACHE_HITS = 7;
    protected static final int CACHE_MISSES_BY_URL = 8;
    protected static final int CACHE_MISSES_BY_ID = 9;
    protected static final int CACHE_EXPIRES = 10;
    protected static final int CACHE_PURGES = 11;
    protected static final int CACHE_ENTRY = 12;
    protected static final int CACHE_COUNTS = 3968;
    protected static final int GATHER_ALL = 8064;
    protected static final String ESI_CONTROLLER_PROXY_ID = "ESIInvalidatorControllerProxy";
    protected static final String ESI_CONTROLLER_PROXY_IMPL = "com.ibm.ws.cache.esi.ESIInvalidatorControllerProxyImpl";
    protected static int timeout;
    protected static int threads;
    public static int cacheInterval;
    public static final String ok = "ok";
    public static final String notok = "notok";
    public static final String proxyDown = "down";
    public static final boolean isZOS;
    public static final boolean isZOSController;

    protected static ESIInterceptInputStream chunkCommand(ESIInterceptOutputStream eSIInterceptOutputStream, int n, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("chunkCommand() " + ESIInvalidatorHelper.getThread() + " " + ESIInvalidator.cmdVal));
        }
        eSIInterceptOutputStream.write(length4);
        eSIInterceptOutputStream.write(crlfbytes, 0, crlfbytes.length);
        eSIInterceptOutputStream.writeInt(n);
        eSIInterceptOutputStream.write(crlfbytes, 0, crlfbytes.length);
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("chunkCommand() : returning response " + ESIInvalidatorHelper.getThread() + " "));
            }
            return eSIInterceptOutputStream.flushWithResponse();
        }
        eSIInterceptOutputStream.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("chunkCommand() " + ESIInvalidatorHelper.getThread() + " "));
        }
        return null;
    }

    protected static void dechunkResponse(DataInputStream dataInputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dechunkResponse() " + ESIInvalidatorHelper.getThread() + " " + ESIInvalidator.cmdVal));
        }
        byte[] byArray = new byte[8];
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dechunkResponse() " + ESIInvalidatorHelper.getThread() + " available : " + dataInputStream.available()));
        }
        byArray[0] = dataInputStream.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dechunkResponse() byte 0 " + byArray[0]));
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte by = dataInputStream.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("dechunkResponse() chunkcr " + by));
            }
            if (by != 13) continue;
            byte by2 = dataInputStream.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("dechunkResponse() chunklf " + by2));
            }
            if (by2 == 10) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("dechunkResponse() " + ESIInvalidatorHelper.getThread()));
        }
    }

    protected static String getThread() {
        return "(# " + Thread.currentThread().getName() + ")";
    }

    protected static byte[] toAsciiBytes(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("toAsciiBytes() " + string));
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"toAsciiBytes()");
            }
            return string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("toAsciiBytes() error converting : " + string));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"toAsciiBytes()");
            }
            return null;
        }
    }

    protected static String setShort(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setShort() " + n));
        }
        byte[] byArray = new byte[]{(byte)(0xFF & n >> 8), (byte)(0xFF & n)};
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setShort()");
        }
        return new String(byArray);
    }

    protected static String setInt(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setInt() " + n));
        }
        byte[] byArray = new byte[]{(byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n)};
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInt()");
        }
        return new String(byArray);
    }

    static {
        CacheConfig cacheConfig;
        CacheService cacheService;
        tc = Tr.register((Class)ESIInvalidatorHelper.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
        ph = AdminHelper.getPlatformHelper();
        crlfbytes = ESIInvalidatorHelper.toAsciiBytes(crlf);
        contbytes = ESIInvalidatorHelper.toAsciiBytes("HTTP/1.1 100 Continue\r\nServer: WebSphere Application Server/5.1\r\nContent-Language: en-US\r\nTransfer-Encoding: chunked\r\n\r\n");
        okbytes = ESIInvalidatorHelper.toAsciiBytes("HTTP/1.1 200 OK\r\nServer: WebSphere Application Server/5.1\r\nContent-Language: en-US\r\nTransfer-Encoding: chunked\r\n\r\n");
        length4 = ESIInvalidatorHelper.toAsciiBytes("4");
        length8 = ESIInvalidatorHelper.toAsciiBytes("8");
        timeout = (Integer.getInteger(timeoutProperty, 5) + Integer.getInteger(timeoutProperty, 5) / 5) * 1000;
        threads = Integer.getInteger(poolsizeProperty, 10);
        cacheInterval = timeout;
        isZOS = ph.isZOS();
        boolean bl = isZOSController = isZOS && ph.isControlJvm();
        if (!isZOSController && (cacheService = ServerCache.cacheService) != null && (cacheConfig = cacheService.getCacheConfig()) != null) {
            cacheInterval = cacheConfig.getBatchUpdateInterval() / 2;
        }
    }
}

