/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cache.esi.ESIInvalidatorControllerProxy;
import com.ibm.ws.cache.esi.ESIInvalidatorHelper;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ComponentImpl;

public class ESIInvalidatorComponentImpl
extends ComponentImpl {
    private static TraceComponent tc = Tr.register((Class)ESIInvalidatorComponentImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static ESIInvalidatorControllerProxy proxy = null;

    public void start() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start() : getting CR/SR");
        }
        if (this.shouldRunInThisJVM() && ESIInvalidatorHelper.isZOSController) {
            this.setStartupState("STARTING");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"start() : in z CR - init ESI Proxy");
            }
            try {
                System.loadLibrary("bbocomm");
            }
            catch (Throwable throwable) {
                this.setStartupState("FAILED");
                throw new RuntimeWarning(throwable);
            }
            try {
                proxy = (ESIInvalidatorControllerProxy)this.getProxyInstance();
                AdminHelper.getPlatformHelper().register_initial_reference(proxy.getName(), (Object)proxy);
                proxy.init();
                this.setStartupState("STARTED");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"start() : created ESIControllerProxy");
                }
            }
            catch (Throwable throwable) {
                this.setStartupState("FAILED");
                Tr.event((TraceComponent)tc, (String)("start() : Error creating ESIControllerProxy : " + throwable));
                throw new RuntimeWarning(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start()");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop()");
        }
        if (this.shouldRunInThisJVM()) {
            block6: {
                this.setDownState("STOPPING");
                if (ESIInvalidatorHelper.isZOSController) {
                    try {
                        proxy.shutdown();
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug((TraceComponent)tc, (String)("stop() : exception occurred " + exception));
                    }
                }
            }
            this.setDownState("STOPPED");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop()");
        }
    }

    public void initialize() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize()");
        }
        if (this.shouldRunInThisJVM()) {
            try {
                this.setInitializationState("INITIALIZED");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("initialize() : exception occurred " + exception));
                }
                throw new RuntimeWarning((Throwable)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize()");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy()");
        }
        if (this.shouldRunInThisJVM()) {
            this.setDownState("DESTROYED");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy()");
        }
    }

    protected void setStartupState(String string) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setStartupState() " + string));
        }
        try {
            this.setStartState(string);
        }
        catch (Exception exception) {
            throw new RuntimeWarning((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setStartupState()");
        }
    }

    protected void setDownState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setDownState() " + string));
        }
        Thread.currentThread();
        Thread.dumpStack();
        try {
            this.setStartState(string);
        }
        catch (Throwable throwable) {
            Tr.event((TraceComponent)tc, (String)("Exception occurred setting down state : " + throwable));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDownState()");
        }
    }

    private Object getProxyInstance() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProxyInstance() : com.ibm.ws.cache.esi.ESIInvalidatorControllerProxyImpl");
        }
        Class<?> clazz = null;
        Object var2_2 = null;
        try {
            clazz = Class.forName("com.ibm.ws.cache.esi.ESIInvalidatorControllerProxyImpl");
            var2_2 = clazz.newInstance();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getProxyInstance() : exception occurred " + exception));
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProxyInstance()");
        }
        return var2_2;
    }

    private boolean shouldRunInThisJVM() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ESIInvalidatorComponentImpl.shouldRunInThisJVM: Entry.");
        }
        boolean bl = false;
        bl = ESIInvalidatorHelper.isZOS;
        if (bl) {
            bl = ESIInvalidatorHelper.isZOSController;
        }
        if (bl) {
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ESIInvalidatorComponentImpl.shouldRunInThisJVM:  Process Type = " + string));
            }
            if (string.equals("NodeAgent") || string.equals("DeploymentManager")) {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("ESIInvalidatorComponentImpl.shouldRunInThisJVM: Exit rc = " + bl));
        }
        return bl;
    }
}

