/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIIntercept;
import com.ibm.ws.cache.esi.ESIInvalidatorConnection;
import com.ibm.ws.cache.esi.ESIInvalidatorDriver;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class ESIInvalidator {
    private static TraceComponent tc = Tr.register((Class)ESIInvalidator.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static ESIInvalidatorDriver driver = null;
    protected static boolean isUp = false;
    protected static String cmdStr = null;
    protected static int cmdVal = 0;
    protected static String response = null;
    protected static Hashtable connections = new Hashtable();

    public ESIInvalidator() {
        driver = new ESIInvalidatorDriver();
        isUp = true;
    }

    private void setCommandValues(String string) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setCommandValues() : " + string));
        }
        if (isUp) {
            if (string == null) {
                throw new RemoteException("ESIInvalidator.SetCommandValues received null string");
            }
        } else {
            throw new RemoteException("down");
        }
        cmdStr = string;
        cmdVal = new Integer(cmdStr.substring(0, 1));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setCommandValues() : " + cmdVal + " / " + cmdStr));
        }
    }

    public synchronized void sendCommand(String string) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sendCommand() : " + string));
        }
        this.setCommandValues(string);
        driver.sendCommand();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendCommand()");
        }
    }

    public synchronized String flowCommand(String string) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("flowCommand() : " + string));
        }
        this.setCommandValues(string);
        response = driver.sendCommand();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("flowCommand() " + response));
        }
        return response;
    }

    public static synchronized void addConnection(byte[] byArray, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addConnection() : " + string + " " + string2));
        }
        if (isUp) {
            ESIInvalidatorConnection eSIInvalidatorConnection = new ESIInvalidatorConnection(byArray, string, string2);
            if (eSIInvalidatorConnection.isBound) {
                connections.put(string, eSIInvalidatorConnection);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addConnection() : plugin connection " + eSIInvalidatorConnection.getPlugin() + " state : " + eSIInvalidatorConnection.isBound));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"addConnection() :  proxy is not active - freeing session");
            }
            ESIIntercept.ESIFree(byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addConnection()");
        }
    }

    public static synchronized void removeConnection(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeConnection() : ");
        }
        ESIInvalidatorConnection eSIInvalidatorConnection = (ESIInvalidatorConnection)connections.get(string);
        byte[] byArray = eSIInvalidatorConnection.getSession();
        connections.remove(string);
        ESIIntercept.ESIFree(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeConnection()");
        }
    }

    public void shutdown() {
        isUp = false;
    }
}

