/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.esi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.esi.ESIIntercept;
import com.ibm.ws.cache.esi.ESIInterceptInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ESIInterceptOutputStream
extends DataOutputStream {
    private static final TraceComponent tc = Tr.register((Class)ESIInterceptOutputStream.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private ByteArrayOutputStream bos = null;
    private byte[] session;

    public ESIInterceptOutputStream(byte[] byArray) {
        super(new ByteArrayOutputStream());
        this.session = byArray;
        this.bos = (ByteArrayOutputStream)this.out;
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flush() ");
        }
        if (this.bos != null) {
            String string = new String(this.bos.toByteArray()).trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("flush() command : " + string));
            }
            try {
                ESIIntercept.ESISend(this.session, this.bos.toByteArray());
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("flush() caught exception " + throwable));
                }
                throw new IOException();
            }
            finally {
                this.bos.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush()");
        }
    }

    public ESIInterceptInputStream flushWithResponse() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushWithResponse() ");
        }
        byte[] byArray = null;
        if (this.bos != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushWithResponse() command :");
            }
            try {
                byArray = ESIIntercept.ESIFlow(this.session, this.bos.toByteArray());
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("flush() caught exception " + throwable));
                }
                throw new IOException();
            }
            finally {
                this.bos.reset();
            }
        }
        if (byArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushWithResponse() : null response received.");
            }
            throw new IOException("flushWithResponse() : null response received.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("flushWithResponse() " + byArray.length));
        }
        return new ESIInterceptInputStream(byArray);
    }
}

