/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.eca;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.eca.ECAOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class ECAConnection {
    private static TraceComponent tc = Trace.register(ECAConnection.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean usingSocket = true;
    Socket sock;

    public ECAConnection() {
        usingSocket = false;
    }

    public ECAConnection(Socket socket) {
        this.sock = socket;
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getInputStream");
            }
            inputStream = null;
            try {
                if (usingSocket) {
                    inputStream = this.sock.getInputStream();
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("getInputStream exception " + iOException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInputStream stream : " + inputStream));
        }
        return inputStream;
    }

    public OutputStream getOutputStream() {
        OutputStream outputStream;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOutputStream");
            }
            outputStream = null;
            try {
                outputStream = usingSocket ? this.sock.getOutputStream() : new ECAOutputStream(null);
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("getOutputStream exception " + iOException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getOutputStream stream : " + outputStream));
        }
        return outputStream;
    }

    public InetAddress getInetAddress() {
        InetAddress inetAddress;
        block4: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getInetAddress");
            }
            inetAddress = null;
            try {
                inetAddress = usingSocket ? this.sock.getInetAddress() : InetAddress.getLocalHost();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("getInetAddress exception " + iOException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInetAddress addr : " + inetAddress));
        }
        return inetAddress;
    }

    public void close() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"close");
            }
            if (usingSocket) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("close exception " + iOException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }
}

