/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerInstanceImpl;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSBootstrapMsg;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSServantProxy;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DynacacheDRSControllerBootstrap
implements DRSBootstrap {
    private DynacacheDRSControllerInstanceImpl xddci = null;
    private static TraceComponent tc = Tr.register((Class)DynacacheDRSControllerBootstrap.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private Integer lock;

    public DynacacheDRSControllerBootstrap(DynacacheDRSControllerInstanceImpl dynacacheDRSControllerInstanceImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DynacacheDRSControllerBootstrap() - CTOR");
        }
        this.xddci = dynacacheDRSControllerInstanceImpl;
        this.lock = new Integer(999);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DynacacheDRSControllerBootstrap() - CTOR");
        }
    }

    public void bootstrapRequest(DRSBootstrapMsg dRSBootstrapMsg) {
    }

    public void handleBootstrapRequest(DRSBootstrapMsg dRSBootstrapMsg) {
        String string = "DynacacheDRSControllerBootstrap.handleBootstrapRequest/" + this.xddci.instanceUniqueId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "DRS is sending handleBootstrapRequest:  dbm = " + dRSBootstrapMsg));
        }
        Object var3_3 = null;
        DRSInstanceToken dRSInstanceToken = null;
        DRSBootstrapMsg dRSBootstrapMsg2 = null;
        DRSBootstrapMsg dRSBootstrapMsg3 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        if (dRSBootstrapMsg == null) {
            Tr.error((TraceComponent)tc, (String)"DYNA1017E", (Object)string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Returning: dbm is null"));
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + "Number of servants = " + this.xddci.getDRSInstanceTokenTable().size()));
        }
        if (this.xddci.getDRSInstanceTokenTable().size() > 0) {
            dRSBootstrapMsg2 = (DRSBootstrapMsg)dRSBootstrapMsg.clone();
            dRSBootstrapMsg3 = (DRSBootstrapMsg)dRSBootstrapMsg.clone();
            Iterator iterator = this.xddci.getDRSInstanceTokenTable().getIterator();
            try {
                while (iterator.hasNext()) {
                    dRSInstanceToken = (DRSInstanceToken)iterator.next();
                    this.sendHandleBootstrapRequestToServant(dRSInstanceToken, dRSBootstrapMsg2, true);
                    dRSBootstrapMsg.setComponentData(dRSBootstrapMsg2.getComponentData());
                    dRSBootstrapMsg.getJvmId().setServantToken(dRSInstanceToken.getStoken());
                    while (iterator.hasNext()) {
                        dRSInstanceToken = (DRSInstanceToken)iterator.next();
                        DRSBootstrapMsg dRSBootstrapMsg4 = (DRSBootstrapMsg)dRSBootstrapMsg3.clone();
                        this.sendHandleBootstrapRequestToServant(dRSInstanceToken, dRSBootstrapMsg4, true);
                        dRSBootstrapMsg4.getJvmId().setServantToken(dRSInstanceToken.getStoken());
                        this.xddci.getDynacacheDRSControllerDataXfer().sendGenerateBootstrapResponseToDRS(dRSBootstrapMsg4);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerBootstrap.handleBootstrapRequest", "138", this);
                Tr.error((TraceComponent)tc, (String)"DYNA1006E", (Object)new Object[]{string, throwable});
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " There are no registered servants"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
    }

    public void sendHandleBootstrapRequestToServant(DRSInstanceToken dRSInstanceToken, DRSBootstrapMsg dRSBootstrapMsg, boolean bl) {
        String string = "DynacacheDRSControllerBootstrap.sendHandleBootstrapRequestToServant/" + this.xddci.instanceUniqueId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry token = " + dRSInstanceToken + " dbm = " + dRSBootstrapMsg));
        }
        if (dRSInstanceToken == null) {
            Tr.error((TraceComponent)tc, (String)"DYNA1009E", (Object)string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Exit - token = null."));
            }
            return;
        }
        if (dRSBootstrapMsg == null) {
            Tr.error((TraceComponent)tc, (String)"DYNA1017E", (Object)string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Returning: dbm is null"));
            }
            return;
        }
        try {
            byte[] byArray;
            byte[] byArray2 = this.convertToBytes(dRSInstanceToken);
            if (byArray2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(string + " Returning: tokenBytes is null"));
                }
                return;
            }
            byte[] byArray3 = this.convertToBytes(dRSBootstrapMsg);
            if (byArray3 == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA1016E", (Object)new Object[]{string, dRSBootstrapMsg, byArray3});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(string + " Returning: dbmBytes is null"));
                }
                return;
            }
            DRSServantProxy dRSServantProxy = this.getProxy(dRSInstanceToken);
            if (dRSServantProxy == null) {
                if (bl) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)(string + " Returning: proxy is null"));
                    }
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string + " Throwing exception: proxy is null"));
                }
                throw new NoSuchElementException();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + "Sending handleBootstrapRequest to SR with token= " + dRSInstanceToken + " dbm = " + dRSBootstrapMsg));
            }
            if ((byArray = dRSServantProxy.handleBootstrapRequest(byArray2, byArray3)) == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA1018E", (Object)new Object[]{string, byArray, dRSInstanceToken});
                dRSBootstrapMsg.setComponentData(null);
            } else {
                Object object = DynacachePlatformHelper.getObject(byArray);
                if (object == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1018E", (Object)new Object[]{string, byArray, dRSInstanceToken});
                    dRSBootstrapMsg.setComponentData(null);
                } else {
                    DRSBootstrapMsg dRSBootstrapMsg2 = (DRSBootstrapMsg)object;
                    dRSBootstrapMsg.setComponentData(dRSBootstrapMsg2.getComponentData());
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (bl) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)(string + " Returning: caught exception, but called from DRS. Continue with other servant regions."));
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + "Caught NoSuchElementException, rethrowing, servant with token= " + dRSInstanceToken + " is down. dbm = " + dRSBootstrapMsg));
            }
            throw new NoSuchElementException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerBootstrap.sendHandleBootstrapRequestToServant", "223", this);
            Tr.error((TraceComponent)tc, (String)"DYNA1006E", (Object)new Object[]{string, throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exiting with dbm:" + dRSBootstrapMsg));
        }
    }

    public void bootstrapResponse(DRSBootstrapMsg dRSBootstrapMsg) {
        String string = "DynacacheDRSControllerBootstrap.bootstrapResponse/" + this.xddci.instanceUniqueId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry: bootstrapResponse is from DRS"));
        }
        Object var3_3 = null;
        DRSInstanceToken dRSInstanceToken = null;
        if (dRSBootstrapMsg == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Exit - dbm = null."));
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + "Number of servants = " + this.xddci.getDRSInstanceTokenTable().size()));
        }
        if (this.xddci.shouldSaveBootstrapResponse(dRSBootstrapMsg)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Exit - dbm saved.  No servants to bootstrap."));
            }
            return;
        }
        Object var6_5 = null;
        byte[] byArray = this.convertToBytes(dRSBootstrapMsg);
        if (byArray != null) {
            Iterator iterator = this.xddci.getDRSInstanceTokenTable().getIterator();
            while (iterator.hasNext()) {
                dRSInstanceToken = (DRSInstanceToken)iterator.next();
                this.sendBootstrapResponseToServant(dRSInstanceToken, dRSBootstrapMsg);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1016E", (Object)new Object[]{string, dRSBootstrapMsg, byArray});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit: bootstrapResponse is from DRS"));
        }
    }

    public void sendBootstrapResponseToServant(DRSInstanceToken dRSInstanceToken, DRSBootstrapMsg dRSBootstrapMsg) {
        String string = "DynacacheDRSControllerBootstrap.sendBootstrapResponseToServant/" + this.xddci.instanceUniqueId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "token = " + dRSInstanceToken + "- Entry. "));
        }
        DRSServantProxy dRSServantProxy = null;
        if (dRSInstanceToken == null) {
            Tr.error((TraceComponent)tc, (String)"DYNA1009E", (Object)string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Exit - token = null."));
            }
            return;
        }
        if (dRSBootstrapMsg == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Exit - dbm = null."));
            }
            return;
        }
        if (dRSBootstrapMsg.getComponentData() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(string + " Exit - dbm.getComponentData() = null."));
            }
            return;
        }
        byte[] byArray = this.convertToBytes(dRSBootstrapMsg);
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = this.convertToBytes(dRSInstanceToken);
            if (byArray2 != null) {
                dRSServantProxy = this.getProxy(dRSInstanceToken);
                if (dRSServantProxy != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(string + "Sending bootstrapResponse to SR with token= " + dRSInstanceToken + " dbm = " + dRSBootstrapMsg));
                        }
                        dRSServantProxy.bootstrapResponse(byArray2, byArray);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerBootstrap.sendBootstrapResponseToServant", "331", this);
                        Tr.error((TraceComponent)tc, (String)"DYNA1006E", (Object)new Object[]{string, throwable});
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"DYNA1008E", (Object)string);
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"DYNA1011E", (Object)new Object[]{string, dRSInstanceToken, byArray2});
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"DYNA1016E", (Object)new Object[]{string, dRSBootstrapMsg, byArray});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit."));
        }
    }

    private DRSServantProxy getProxy(DRSInstanceToken dRSInstanceToken) {
        String string = "DynacacheDRSControllerBootstrap.getProxy/" + this.xddci.instanceUniqueId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        DRSServantProxy dRSServantProxy = null;
        if (dRSInstanceToken != null) {
            try {
                dRSServantProxy = this.xddci.drsServantProxyFactory.createProxyForSpecificServant(dRSInstanceToken);
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerBootstrap.getProxy", "364", this);
                    Tr.debug((TraceComponent)tc, (String)(string + "Caught exception while trying to create a proxy to token " + dRSInstanceToken));
                    Tr.debug((TraceComponent)tc, (String)(string + "This exception is not necessarily an error."));
                    Tr.error((TraceComponent)tc, (String)"DYNA1006E", (Object)new Object[]{string, throwable});
                }
                dRSServantProxy = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
        return dRSServantProxy;
    }

    private byte[] convertToBytes(Object object) {
        String string = "DynacacheDRSControllerBootstrap.convertToBytes/" + this.xddci.instanceUniqueId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        byte[] byArray = null;
        if (object != null) {
            try {
                byArray = this.xddci.drsServantProxyFactory.getByteArray(object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.drs.ws390.DynacacheDRSControllerBootstrap.convertToBytes", "388", this);
                Tr.error((TraceComponent)tc, (String)"DYNA1006E", (Object)new Object[]{string, throwable});
                byArray = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
        return byArray;
    }
}

