/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.ExternalCacheFragment;
import com.ibm.ws.cache.IdObject;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.devmon.Monitor;
import com.ibm.ws.cache.drs.DRSNotificationService;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSNotReadyException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

public class DRSRemoteServices
implements RemoteServices {
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    private static final boolean IS_UNIT_TEST = false;
    private Monitor monitor = null;
    private String uniqueCacheName = null;
    private String cacheName = null;
    private CacheUnit cacheUnit = null;
    private DRSNotificationService notificationService = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DRSRemoteServices() {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
    }

    public void setCacheUnit(String string, CacheUnitImpl cacheUnitImpl) {
        this.uniqueCacheName = string;
        this.cacheUnit = cacheUnitImpl;
    }

    public void setCacheName(String string) {
        this.cacheName = string;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = (DRSNotificationService)notificationService;
    }

    public void setEntry(CacheEntry cacheEntry) {
        if (!$assertionsDisabled && cacheEntry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cacheEntry.getSharingPolicy() == 1) {
            throw new AssertionError();
        }
        int n = cacheEntry.getSharingPolicy();
        IdObject idObject = new IdObject(cacheEntry.getIdObject());
        if (!cacheEntry.prepareForSerialization()) {
            return;
        }
        CacheEntry cacheEntry2 = null;
        if (cacheEntry instanceof AliasEntry) {
            this.sendObjectWithRetry(idObject, cacheEntry);
        } else if (n == 2) {
            this.sendObjectWithRetry(idObject, cacheEntry);
        } else {
            Object object;
            Enumeration enumeration = cacheEntry.getAliasList();
            while (enumeration.hasMoreElements()) {
                if (cacheEntry2 == null) {
                    cacheEntry2 = new AliasEntry(idObject, "AddAlias", n, CacheEntry.EMPTY_OBJECT_ARRAY);
                }
                object = enumeration.nextElement();
                cacheEntry2.addAlias(object);
            }
            if (cacheEntry2 != null) {
                this.sendObjectWithRetry(idObject, cacheEntry2);
            }
            object = new ArrayList();
            ((ArrayList)object).add((IdObject)idObject);
            this.notificationService.announceEntries((ArrayList)object);
        }
    }

    public void setExternalCacheFragment(String string, ExternalCacheFragment externalCacheFragment) {
        this.cacheUnit.setExternalCacheFragment(externalCacheFragment);
    }

    public void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2) {
        if (!$assertionsDisabled && !this.isDRSReady()) {
            throw new AssertionError((Object)"Should not call batchUpdate if DRS is not ready");
        }
        this.notificationService.batchUpdate(hashMap, hashMap2, arrayList, arrayList2, this.cacheUnit);
    }

    public void start() {
        if (this.notificationService == null) {
            throw new IllegalStateException("notificationService must be set before calling start()");
        }
    }

    public CacheEntry getEntry(Object object) {
        CacheEntry cacheEntry;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getEntry " + object));
            }
            cacheEntry = null;
            Object object2 = null;
            try {
                object2 = this.notificationService.getEntry(object);
                cacheEntry = (CacheEntry)object2;
            }
            catch (DRSCongestedException dRSCongestedException) {
                FFDCFilter.processException((Throwable)dRSCongestedException, "com.ibm.ws.cache.drs.DRSRemoteServices.getEntry", "204", this);
                if (tc.isDebugEnabled()) {
                    dRSCongestedException.printStackTrace();
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSRemoteServices.getEntry", "210", this);
                if (!tc.isDebugEnabled()) break block6;
                dRSNotReadyException.printStackTrace();
            }
        }
        if (cacheEntry != null) {
            cacheEntry.processDrsInbound(System.currentTimeMillis());
        }
        return cacheEntry;
    }

    public boolean shouldPull(int n, Object object) {
        boolean bl = false;
        if (n == 4 || n == 3) {
            bl = this.notificationService.shouldPull(object);
        }
        return bl;
    }

    public boolean isDRSReady() {
        return this.notificationService.isDRSReady();
    }

    public boolean isDRSCongested() {
        return this.notificationService.isDRSCongested();
    }

    private void sendObjectWithRetry(IdObject idObject, CacheEntry cacheEntry) {
        block5: {
            if (!$assertionsDisabled && cacheEntry.getSharingPolicy() != 2) {
                throw new AssertionError();
            }
            cacheEntry.processDrsOutbound();
            try {
                this.notificationService.updateEntryProp(idObject, DRSNotificationService.drsSetEntryObj, cacheEntry);
            }
            catch (DRSCongestedException dRSCongestedException) {
                FFDCFilter.processException((Throwable)dRSCongestedException, "com.ibm.ws.cache.drs.DRSRemoteServices.sendObjectWithRetry", "282", this);
                dRSCongestedException.printStackTrace();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sendObjectWithRetry() FFDC exception logged");
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSRemoteServices.sendObjectWithRetry", "290", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"sendObjectWithRetry() FFDC exception logged");
            }
        }
    }

    public int getPushPullTableSize() {
        return this.notificationService.getPushPullTableSize();
    }

    static {
        $assertionsDisabled = !DRSRemoteServices.class.desiredAssertionStatus();
        tc = Trace.register(DRSRemoteServices.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
    }
}

