/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.drs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.IdObject;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.devmon.Monitor;
import com.ibm.ws.cache.drs.DRSMessageListener;
import com.ibm.ws.cache.drs.ws390.DynacacheDRSBootstrapMsgImpl;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSBootstrapMsg;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSJvmId;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSNotReadyException;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class DRSNotificationService
implements NotificationService,
DRSBootstrap {
    private static final long serialVersionUID = -3271165947086877873L;
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    private static final boolean IS_UNIT_TEST = false;
    private static final Integer INTEGER_BOOTSTRAP_PUSH_PULL;
    private Monitor monitor = null;
    private static Object bootstrapLock;
    private CacheUnit cacheUnit = null;
    private String uniqueCacheName = null;
    private String cacheName = null;
    private DRSDataXfer ddx = null;
    private DRSMessageListener drsMessageListener = null;
    private boolean startCompleted = false;
    public static final short drsBatchUpdate = 1;
    public static final Short drsBatchUpdateObj;
    public static final short drsAddExternal = 2;
    public static final Short drsAddExternalObj;
    public static final short drsRemoveExternal = 3;
    public static final Short drsRemoveExternalObj;
    public static final short drsRegisterCU = 4;
    public static final Short drsRegisterCUObj;
    public static final short invaIDs = 5;
    public static final Short invaIDsObj;
    public static final short invalTempls = 6;
    public static final Short invalTemplsObj;
    public static final short pushes = 7;
    public static final Short pushesObj;
    public static final short cacheIdInt = 15;
    public static final Short cacheIdObj;
    public static final short getDynaEntry = 8;
    public static final Short getDynaEntryObj;
    public static final short getDynaCmd = 9;
    public static final Short getDynaCmdObj;
    public static final short groupId = 10;
    public static final Short groupIdObj;
    public static final short address = 11;
    public static final Short addressObj;
    public static final short beanName = 12;
    public static final Short beanNameObj;
    public static final short drsSetEntry = 13;
    public static final Short drsSetEntryObj;
    public static final short drsCacheAlias = 16;
    public static final Short drsCacheAliasObj;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DRSNotificationService() {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
    }

    public void setCacheName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCacheName() cacheName=" + string));
        }
        this.cacheName = string;
    }

    public void setDRSMessageListener(DRSMessageListener dRSMessageListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDRSMessageListener() setDRSMessageListener=" + dRSMessageListener));
        }
        this.drsMessageListener = dRSMessageListener;
    }

    public boolean isDRSReady() {
        return this.drsMessageListener.isDRSReady();
    }

    public boolean isDRSCongested() {
        return this.drsMessageListener.isDRSCongested();
    }

    public void registerCacheUnit(String string, CacheUnit cacheUnit) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("registerCacheUnit() uniqueCacheName=" + string));
        }
        if (!this.startCompleted) {
            throw new IllegalStateException("DRS NS is not ready");
        }
        this.cacheUnit = cacheUnit;
        this.uniqueCacheName = string;
    }

    public void start() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("start() cacheName=" + this.cacheName));
        }
        if (!$assertionsDisabled && this.cacheName == null) {
            throw new AssertionError((Object)"cacheName is null");
        }
        this.startCompleted = true;
    }

    private void pubMsg(Object object, Object object2, Object object3) {
        block9: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("pubMsg() partKey=" + object + "key=" + object2));
            }
            try {
                this.updateEntryProp(object, object2, object3);
            }
            catch (DRSCongestedException dRSCongestedException) {
                try {
                    Thread.sleep(250L);
                    this.updateEntryProp(object, object2, object3);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "256", this);
                    interruptedException.printStackTrace();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"pubMsg() FFDC exception logged");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "264", this);
                    exception.printStackTrace();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"pubMsg() FFDC exception logged");
                    }
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "271", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"pubMsg() FFDC exception logged");
            }
        }
    }

    public void batchUpdate(HashMap object, HashMap hashMap, ArrayList arrayList, ArrayList arrayList2, CacheUnit cacheUnit) {
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("batchUpdate() invalidateIdEvents.size()=" + ((HashMap)object).size() + " invalidateTemplateEvents.size()=" + hashMap.size() + "pushEntryEvents.size()=" + arrayList.size() + " aliasEntryEvents.size()=" + arrayList2));
        }
        if (!this.startCompleted) {
            throw new IllegalStateException("DRS NS is not ready");
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList arrayList4 = null;
        HashSet hashSet = new HashSet();
        if (((HashMap)object).size() > 0) {
            Cache cache = ServerCache.getCache(this.cacheName);
            iterator = new HashMap();
            object4 = ((HashMap)object).values().iterator();
            while (object4.hasNext()) {
                InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)object4.next();
                if (cache.shouldFilterTimeOutInvalidation(invalidateByIdEvent.causeOfInvalidation) || !invalidateByIdEvent.prepareForSerialization()) continue;
                if (invalidateByIdEvent.getId() instanceof String) {
                    ((HashMap)((Object)iterator)).put(invalidateByIdEvent.getId(), invalidateByIdEvent);
                    continue;
                }
                ((HashMap)((Object)iterator)).put(invalidateByIdEvent.getSerializedId(), invalidateByIdEvent);
            }
            object = iterator;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            iterator = (CacheEntry)arrayList.get(i);
            object4 = new IdObject(((CacheEntry)((Object)iterator)).getIdObject());
            int n = ((CacheEntry)((Object)iterator)).getSharingPolicy();
            if (!$assertionsDisabled && n == 1) {
                throw new AssertionError();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("batchUpdate() CE=" + iterator + "shareType=" + n));
            }
            if (n != 4 && n != 3) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("batchUpdate() - announce CacheEntry " + object4));
            }
            arrayList3.add(object4);
            object3 = ((CacheEntry)((Object)iterator)).getAliasList();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("batchUpdate() - announce AliasEntry " + object2));
                }
                arrayList3.add(new IdObject(object2));
            }
            hashSet.add(iterator);
        }
        if (hashSet.size() > 0) {
            arrayList.removeAll(hashSet);
        }
        String string = this.uniqueCacheName;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            if (!(object4 instanceof CacheEntry)) continue;
            ((CacheEntry)object4).processDrsOutbound();
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object4 = (AliasEntry)iterator.next();
            ((CacheEntry)object4).processDrsOutbound();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("batchUpdate() pushPullEntries_Announce=" + arrayList3));
        }
        if (arrayList3.size() > 0) {
            this.announceEntries(arrayList3);
        }
        arrayList4 = this.buildRenounceList((HashMap)object, hashMap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("batchUpdate() pushPullEntries_Renounce=" + arrayList4));
        }
        if (arrayList4.size() > 0) {
            this.renounceEntries(arrayList4);
        }
        if (arrayList.size() > 0) {
            object4 = ServerCache.getCache(this.cacheName);
            int n = (((Cache)object4).getNumberCacheEntries() << 1) / 100;
            if (n > 50) {
                n = 50;
            } else if (n <= 1) {
                n = 2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("batchUpdate() window size = " + n));
            }
            object3 = arrayList.iterator();
            object2 = new ArrayList();
            while (object3.hasNext()) {
                boolean bl;
                CacheEntry cacheEntry = (CacheEntry)object3.next();
                if (cacheEntry != null) {
                    ((ArrayList)object2).add((CacheEntry)cacheEntry);
                }
                if (object3.hasNext() && ((ArrayList)object2).size() < n) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("batchUpdate() push window size = " + ((ArrayList)object2).size()));
                }
                if (!(bl = ((HashMap)object).size() > 0 || hashMap.size() > 0 || ((ArrayList)object2).size() > 0 || arrayList2.size() > 0)) continue;
                HashMap<Short, Object> hashMap2 = new HashMap<Short, Object>();
                hashMap2.put(cacheIdObj, this.cacheName);
                hashMap2.put(invaIDsObj, object);
                hashMap2.put(invalTemplsObj, hashMap);
                hashMap2.put(pushesObj, object2);
                hashMap2.put(drsCacheAliasObj, arrayList2);
                this.pubMsg(string, drsBatchUpdateObj, hashMap2);
                ((ArrayList)object2).clear();
                ((HashMap)object).clear();
                hashMap.clear();
                arrayList2.clear();
                hashMap2.clear();
            }
        } else {
            boolean bl;
            boolean bl2 = bl = ((HashMap)object).size() > 0 || hashMap.size() > 0 || arrayList.size() > 0 || arrayList2.size() > 0;
            if (bl) {
                HashMap<Short, Object> hashMap3 = new HashMap<Short, Object>();
                hashMap3.put(cacheIdObj, this.cacheName);
                hashMap3.put(invaIDsObj, object);
                hashMap3.put(invalTemplsObj, hashMap);
                hashMap3.put(pushesObj, arrayList);
                hashMap3.put(drsCacheAliasObj, arrayList2);
                this.pubMsg(string, drsBatchUpdateObj, hashMap3);
            }
        }
    }

    private ArrayList buildRenounceList(HashMap hashMap, HashMap hashMap2) {
        Iterator iterator;
        Collection collection;
        Object object;
        Externalizable externalizable;
        Cache cache = ((CacheUnitImpl)this.cacheUnit).getCache(this.cacheName);
        ArrayList<IdObject> arrayList = new ArrayList<IdObject>();
        Iterator iterator2 = hashMap.values().iterator();
        while (iterator2.hasNext()) {
            externalizable = (InvalidateByIdEvent)iterator2.next();
            object = ((InvalidateByIdEvent)externalizable).getId();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("buildRenounceList() will renounce CacheEntry " + object));
            }
            arrayList.add(new IdObject(object));
            collection = cache.getCacheIdsByDependency(object);
            if (null == collection) continue;
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("buildRenounceList() will renounce depId " + object));
                }
                arrayList.add(new IdObject(object));
            }
        }
        iterator2 = hashMap2.values().iterator();
        while (iterator2.hasNext()) {
            externalizable = (InvalidateByTemplateEvent)iterator2.next();
            object = ((InvalidateByTemplateEvent)externalizable).getTemplate();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("buildRenounceList() will renounce CacheEntries for template " + (String)object + " - isCacheCommand_Clear=" + ((InvalidateByTemplateEvent)externalizable).isCacheCommand_Clear()));
            }
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommand_Clear()) {
                this.drsMessageListener.clearPushPullTable();
                continue;
            }
            collection = cache.getCacheIdsByTemplate((String)object);
            if (null == collection) continue;
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                arrayList.add(new IdObject(object));
            }
        }
        return arrayList;
    }

    public void createEntry(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.createEntry(object, object2);
    }

    public void createEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.createEntryProp(object, object2, object3);
    }

    public void updateEntry(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.updateEntry(object, object2);
    }

    public void updateEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        if (object3 instanceof CacheEntry) {
            ((CacheEntry)object3).processDrsOutbound();
        }
        if (object instanceof CacheableCommand) {
            object = ((CacheableCommand)object).getId();
        }
        this.ddx.updateEntryProp(object, object2, object3);
    }

    public Object getEntryProp(Object object, Object object2) throws DRSCongestedException, DRSNotReadyException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return this.ddx.getEntryProp(object2, object);
    }

    public Object getEntry(Object object) throws DRSCongestedException, DRSNotReadyException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntry()cacheName=" + this.cacheName + " - id=" + object + " id instanceof IdObject=" + (object instanceof IdObject)));
        }
        Object object2 = null;
        IdObject idObject = new IdObject(object);
        DRSJvmId dRSJvmId = this.drsMessageListener.getPushPullTable().getJvmId(idObject);
        if (null != dRSJvmId) {
            object2 = this.ddx.getEntry((Object)idObject, dRSJvmId);
            this.drsMessageListener.getPushPullTable().renounceEntry(idObject);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getEntry() Warning: Object not found in pushPullTable.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEntry()cacheName=" + this.cacheName + " - o=" + object2 + " o instanceof CacheEntry=" + (object2 instanceof CacheEntry)));
        }
        return object2;
    }

    public void removeEntry(Object object) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.removeEntry(object);
    }

    public void removeEntryProp(Object object, Object object2, Object object3) throws DRSCongestedException, DRSNotReadyException {
        this.ddx.removeEntryProp(object2, object, object3);
    }

    public boolean entryIDExists(Object object) throws DRSCongestedException, DRSNotReadyException {
        return this.ddx.entryIDExists(object);
    }

    public long getInstanceId() {
        return this.ddx.getInstanceId();
    }

    public void setDDX(DRSDataXfer dRSDataXfer) {
        this.ddx = dRSDataXfer;
    }

    public long getPartition(Object object) {
        return this.ddx.getPartition(object);
    }

    public Identity getWLMIdentity(Object object) {
        return this.ddx.getWLMIdentity(object);
    }

    public boolean shouldPull(Object object) {
        boolean bl = this.drsMessageListener.getPushPullTable().shouldPull(new IdObject(object));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("shouldPull() - id=" + object + " = " + bl));
        }
        return bl;
    }

    public void announceEntries(ArrayList arrayList) {
        block6: {
            try {
                this.ddx.announceEntries(arrayList);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("announceEntries() - complete. list=" + arrayList));
                    for (int i = 0; i != arrayList.size(); ++i) {
                        if (arrayList.get(i) instanceof IdObject) continue;
                        Tr.debug((TraceComponent)tc, (String)("announceEntries() WARNING - Key is not an instance of IdObject!!! key=" + arrayList.get(i)));
                    }
                }
            }
            catch (DRSCongestedException dRSCongestedException) {
                FFDCFilter.processException((Throwable)dRSCongestedException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "648", this);
                dRSCongestedException.printStackTrace();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"announceEntries() FFDC exception logged");
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "655", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"announceEntries() FFDC exception logged");
            }
        }
    }

    public void renounceEntries(ArrayList arrayList) {
        block6: {
            try {
                this.ddx.renounceEntries(arrayList);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("renounceEntries() - complete. list=" + arrayList));
                    for (int i = 0; i != arrayList.size(); ++i) {
                        if (arrayList.get(i) instanceof IdObject) continue;
                        Tr.debug((TraceComponent)tc, (String)("renounceEntries() WARNING - Key is not an instance of IdObject!!! key=" + arrayList.get(i)));
                    }
                }
                this.drsMessageListener.getPushPullTable().renounceEntries(arrayList);
            }
            catch (DRSCongestedException dRSCongestedException) {
                FFDCFilter.processException((Throwable)dRSCongestedException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "682", this);
                dRSCongestedException.printStackTrace();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"renounceEntries() FFDC exception logged");
                }
            }
            catch (DRSNotReadyException dRSNotReadyException) {
                FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.pubMsg", "689", this);
                dRSNotReadyException.printStackTrace();
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"renounceEntries() FFDC exception logged");
            }
        }
    }

    public int getPushPullTableSize() {
        return this.drsMessageListener.getPushPullTable().size();
    }

    public void bootstrapRequest(DRSBootstrapMsg dRSBootstrapMsg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleBootstrapRequest(DRSBootstrapMsg dRSBootstrapMsg) {
        Object object;
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleBootstrapRequest() cacheName=" + this.cacheName));
        }
        if (!$assertionsDisabled && this.cacheName == null) {
            throw new AssertionError();
        }
        Cache cache = ServerCache.getCache(this.cacheName);
        if (!$assertionsDisabled && cache == null) {
            throw new AssertionError((Object)this.cacheName);
        }
        if (!cache.isDRSBootstrapEnabled()) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() Boostrapping is disabled for cache instance " + this.cacheName));
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() cache size = " + cache.getNumberCacheEntries()));
            Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() isSolicit = " + dRSBootstrapMsg.isSolicit()));
        }
        HashMap<Integer, Cloneable> hashMap2 = new HashMap<Integer, Cloneable>(3);
        if (dRSBootstrapMsg.isSolicit()) {
            dRSBootstrapMsg.setComponentData(hashMap2);
            return;
        }
        Enumeration enumeration = cache.getAllIds();
        Vector<Object> vector = new Vector<Object>();
        Vector<IdObject> vector2 = new Vector<IdObject>();
        int n = (cache.getNumberCacheEntries() << 1) / 100;
        if (n > 50) {
            n = 50;
        } else if (n <= 1) {
            n = 2;
        }
        while (enumeration.hasMoreElements()) {
            int n2;
            Object var19_24;
            hashMap = (HashMap)enumeration.nextElement();
            object = this.cacheUnit.getEntry(this.cacheName, hashMap, false);
            if (object != null) {
                int n3 = object.getSharingPolicy();
                if (n3 == 4 || n3 == 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() adding push-pull entry " + hashMap + " to pushpull ce vector "));
                    }
                    vector2.addElement(new IdObject(hashMap));
                    object.finish();
                }
                if (n3 == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() adding push entry " + hashMap + " to push ce vector "));
                    }
                    vector.addElement(object);
                }
            }
            if (enumeration.hasMoreElements() && vector2.size() + vector.size() < n) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() number of push entries = " + vector.size()));
                Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() number of push pull entries = " + vector2.size()));
                Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() window size = " + n));
            }
            if (vector.size() <= 0 && vector2.size() <= 0) continue;
            if (vector.size() > 0) {
                hashMap2.put(new Integer(2), vector);
            }
            if (vector2.size() > 0) {
                hashMap2.put(new Integer(4), vector2);
            }
            dRSBootstrapMsg.setComponentData(hashMap2);
            try {
                try {
                    Object object2 = bootstrapLock;
                    synchronized (object2) {
                        this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                        vector2.clear();
                        hashMap2.clear();
                    }
                }
                catch (DRSNotReadyException dRSNotReadyException) {
                    FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "809", this);
                    dRSNotReadyException.printStackTrace();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"handleBootstrapRequest() FFDC exception logged");
                    }
                    var19_24 = null;
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        object = (com.ibm.websphere.cache.CacheEntry)vector.elementAt(n2);
                        object.finish();
                    }
                    vector.clear();
                    continue;
                }
                catch (DRSCongestedException dRSCongestedException) {
                    block52: {
                        try {
                            long l = 30000L;
                            for (long l2 = 5000L; this.isDRSCongested() && l2 < l; l2 = 2L * l2) {
                                Thread.sleep(l2);
                            }
                            Object object2 = bootstrapLock;
                            synchronized (object2) {
                                this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                                vector2.clear();
                                hashMap2.clear();
                            }
                        }
                        catch (InterruptedException l2) {
                            FFDCFilter.processException((Throwable)l2, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "827", this);
                            l2.printStackTrace();
                            if (!tc.isDebugEnabled()) break block52;
                            Tr.debug((TraceComponent)tc, (String)"handleBootstrapRequest() FFDC exception logged");
                        }
                        catch (Exception interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "834", this);
                            interruptedException.printStackTrace();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"handleBootstrapRequest() FFDC exception logged");
                            }
                            var19_24 = null;
                            for (n2 = 0; n2 < vector.size(); ++n2) {
                                object = (com.ibm.websphere.cache.CacheEntry)vector.elementAt(n2);
                                object.finish();
                            }
                            vector.clear();
                            break;
                        }
                    }
                    var19_24 = null;
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        object = (com.ibm.websphere.cache.CacheEntry)vector.elementAt(n2);
                        object.finish();
                    }
                    vector.clear();
                    continue;
                }
                var19_24 = null;
            }
            catch (Throwable throwable) {
                var19_24 = null;
                n2 = 0;
                while (true) {
                    if (n2 >= vector.size()) {
                        vector.clear();
                        throw throwable;
                    }
                    object = (com.ibm.websphere.cache.CacheEntry)vector.elementAt(n2);
                    object.finish();
                    ++n2;
                }
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = (com.ibm.websphere.cache.CacheEntry)vector.elementAt(n2);
                object.finish();
            }
            vector.clear();
        }
        hashMap = null;
        if (dRSBootstrapMsg instanceof DynacacheDRSBootstrapMsgImpl) {
            hashMap = this.drsMessageListener.getPushPullTable().getTableClone();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleBootstrapRequest() Got " + hashMap.size() + " elements from pushPullTable."));
            }
            if (hashMap.size() == 0) {
                hashMap = null;
            }
        }
        if (hashMap == null) return;
        hashMap2.put(INTEGER_BOOTSTRAP_PUSH_PULL, hashMap);
        dRSBootstrapMsg.setComponentData(hashMap2);
        try {
            object = bootstrapLock;
            synchronized (object) {
                this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                hashMap2.clear();
                return;
            }
        }
        catch (DRSNotReadyException dRSNotReadyException) {
            FFDCFilter.processException((Throwable)dRSNotReadyException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "875", this);
            dRSNotReadyException.printStackTrace();
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"handleBootstrapRequest() FFDC exception logged");
            return;
        }
        catch (DRSCongestedException dRSCongestedException) {
            try {
                Thread.sleep(1000L);
                Object object4 = bootstrapLock;
                synchronized (object4) {
                    this.ddx.generateBootstrapResponse(dRSBootstrapMsg);
                    hashMap2.clear();
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "889", this);
                interruptedException.printStackTrace();
                if (!tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)"handleBootstrapRequest() FFDC exception logged");
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.drs.DRSNotificationService.handleBootstrapRequest", "895", this);
                exception.printStackTrace();
                if (!tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)"handleBootstrapRequest() FFDC exception logged");
            }
        }
    }

    public void bootstrapResponse(DRSBootstrapMsg dRSBootstrapMsg) {
        HashMap hashMap;
        ArrayList arrayList;
        int n;
        HashMap hashMap2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bootstrapResponse() cacheName=" + this.cacheName));
        }
        if (null == (hashMap2 = (HashMap)dRSBootstrapMsg.getComponentData())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("bootstrapResponse() cacheName=" + this.cacheName + " Exit. componentData is null."));
            }
            return;
        }
        Vector vector = (Vector)hashMap2.get(new Integer(2));
        int n2 = 0;
        if (vector != null) {
            n2 = vector.size();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bootstrapResponse() number of push entries = " + n2));
            }
            for (n = 0; n < n2; ++n) {
                arrayList = vector.elementAt(n);
                if (arrayList instanceof CacheEntry) {
                    CacheEntry cacheEntry = (CacheEntry)((Object)arrayList);
                    this.cacheUnit.setEntry(this.cacheName, cacheEntry);
                    if (!$assertionsDisabled && cacheEntry.getSharingPolicy() != 2) {
                        throw new AssertionError();
                    }
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Can only bootstrap CEs");
                }
            }
        }
        n = n2;
        arrayList = new ArrayList();
        vector = (Vector)hashMap2.get(new Integer(4));
        n2 = 0;
        if (vector != null) {
            n2 = vector.size();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bootstrapResponse() number of pushpull entries = " + n2));
            }
            for (int i = 0; i < n2; ++i) {
                Object e = vector.elementAt(i);
                if (e instanceof IdObject) {
                    IdObject idObject = (IdObject)e;
                    arrayList.add(idObject);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Can only bootstrap IdObjects");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bootstrapResponse() For SHARED_PUSH_PULL, v.size=" + vector.size() + " pushPullKeys.size=" + arrayList.size()));
            }
        }
        if (0 < arrayList.size()) {
            DRSJvmId dRSJvmId = dRSBootstrapMsg.getJvmId();
            if (null != dRSJvmId) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("bootstrapResponse() JvmId = " + dRSJvmId));
                }
                this.drsMessageListener.getPushPullTable().announceEntries(arrayList, dRSJvmId);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"bootstrapResponse() Ignoring announce entries because no jvmID was specified.");
            }
        }
        if ((hashMap = (HashMap)hashMap2.get(INTEGER_BOOTSTRAP_PUSH_PULL)) != null) {
            this.drsMessageListener.getPushPullTable().addEntries(hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("bootstrapResponse() cacheName=" + this.cacheName + " inbound bootstrap of " + n + " push entrie(s), " + n2 + " pushPull entrie(s), and " + (null == hashMap ? "0" : "" + hashMap.size()) + " pushPullTableClone entrie(s)."));
        }
    }

    public void queryReq(Object object) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !DRSNotificationService.class.desiredAssertionStatus();
        tc = Trace.register(DRSNotificationService.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
        INTEGER_BOOTSTRAP_PUSH_PULL = new Integer(257461);
        bootstrapLock = new Object();
        drsBatchUpdateObj = new Short(1);
        drsAddExternalObj = new Short(2);
        drsRemoveExternalObj = new Short(3);
        drsRegisterCUObj = new Short(4);
        invaIDsObj = new Short(5);
        invalTemplsObj = new Short(6);
        pushesObj = new Short(7);
        cacheIdObj = new Short(15);
        getDynaEntryObj = new Short(8);
        getDynaCmdObj = new Short(9);
        groupIdObj = new Short(10);
        addressObj = new Short(11);
        beanNameObj = new Short(12);
        drsSetEntryObj = new Short(13);
        drsCacheAliasObj = new Short(16);
    }
}

